/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class CookieAuthenticationLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(CookieAuthenticationLoginModule.class);
    private static final String LOGIN_COOKIE_NAME = "JSPWikiUID";
    protected static final String COOKIE_DIR = "logincookies";
    public static final String PROP_LOGIN_EXPIRY_DAYS = "jspwiki.cookieAuthentication.expiry";
    private static final int DEFAULT_EXPIRY_DAYS = 14;
    private static long c_lastScrubTime = 0L;
    private static final long SCRUB_PERIOD = 3600000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        WikiEngineCallback wcb = new WikiEngineCallback();
        Callback[] callbacks = new Callback[]{hcb, wcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
            if (uid == null) return false;
            WikiEngine engine = wcb.getEngine();
            File cookieFile = CookieAuthenticationLoginModule.getCookieFile(engine, uid);
            if (cookieFile == null) return false;
            if (!cookieFile.exists()) return false;
            if (!cookieFile.canRead()) return false;
            Reader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cookieFile), "UTF-8"));
                String username = FileUtil.readContents(in);
                if (log.isDebugEnabled()) {
                    log.debug("Logged in cookie authenticated name=" + username, new Object[0]);
                }
                this.m_principals.add(new WikiPrincipal(username, "loginName"));
                cookieFile.setLastModified(System.currentTimeMillis());
                return true;
            }
            catch (IOException e) {
                return false;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e2) {
            String message = "IO exception; disallowing login.";
            log.error(message, e2);
            throw new LoginException(message);
        }
        catch (UnsupportedCallbackException e3) {
            String message = "Unable to handle callback; disallowing login.";
            log.error(message, e3);
            throw new LoginException(message);
        }
    }

    private static File getCookieFile(WikiEngine engine, String uid) {
        File cookieDir = new File(engine.getWorkDir(), COOKIE_DIR);
        if (!cookieDir.exists()) {
            cookieDir.mkdirs();
        }
        if (!cookieDir.canRead()) {
            log.error("Cannot read from cookie directory!" + cookieDir.getAbsolutePath(), new Object[0]);
            return null;
        }
        if (!cookieDir.canWrite()) {
            log.error("Cannot write to cookie directory!" + cookieDir.getAbsolutePath(), new Object[0]);
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > c_lastScrubTime + 3600000L) {
            CookieAuthenticationLoginModule.scrub(TextUtil.getIntegerProperty(engine.getWikiProperties(), PROP_LOGIN_EXPIRY_DAYS, 14), cookieDir);
            c_lastScrubTime = now;
        }
        File cookieFile = new File(cookieDir, uid);
        return cookieFile;
    }

    private static String getLoginCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue(request, LOGIN_COOKIE_NAME);
        return cookie;
    }

    public static void setLoginCookie(WikiEngine engine, HttpServletResponse response, String username) {
        block13: {
            UUID uid = UUID.randomUUID();
            int days = TextUtil.getIntegerProperty(engine.getWikiProperties(), PROP_LOGIN_EXPIRY_DAYS, 14);
            Cookie userId = new Cookie(LOGIN_COOKIE_NAME, uid.toString());
            userId.setMaxAge(days * 24 * 60 * 60);
            response.addCookie(userId);
            File cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid.toString());
            Writer out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cf), "UTF-8"));
                    FileUtil.copyContents(new StringReader(username), out);
                    if (log.isDebugEnabled()) {
                        log.debug("Created login cookie for user " + username + " for " + days + " days", new Object[0]);
                    }
                }
                catch (IOException ex) {
                    log.error("Unable to create cookie file to store user id: " + uid, new Object[0]);
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (IOException ex2) {
                        log.error("Unable to close stream", new Object[0]);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        log.error("Unable to close stream", new Object[0]);
                    }
                }
            }
        }
    }

    public static void clearLoginCookie(WikiEngine engine, HttpServletRequest request, HttpServletResponse response) {
        File cf;
        Cookie userId = new Cookie(LOGIN_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
        String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
        if (uid != null && (cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid)) != null) {
            cf.delete();
        }
    }

    private static synchronized void scrub(int days, File cookieDir) {
        log.debug("Scrubbing cookieDir...", new Object[0]);
        File[] files = cookieDir.listFiles();
        long obsoleteDateLimit = System.currentTimeMillis() - ((long)days + 1L) * 24L * 60L * 60L * 1000L;
        int deleteCount = 0;
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            long lastModified = f.lastModified();
            if (lastModified < obsoleteDateLimit) {
                f.delete();
                ++deleteCount;
            }
            ++i;
        }
        log.debug("Removed " + deleteCount + " obsolete cookie logins", new Object[0]);
    }
}

