/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class CookieAssertionLoginModule
extends AbstractLoginModule {
    public static final String PREFS_COOKIE_NAME = "JSPWikiAssertedName";
    public static final String PROMPT = "User name";
    protected static final Logger log = LoggerFactory.getLogger(CookieAssertionLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            String name;
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            HttpSession session = request == null ? null : request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            String string = name = request != null ? CookieAssertionLoginModule.getUserCookie(request) : null;
            if (name == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No cookie JSPWikiAssertedName present in session ID=:  " + sid, new Object[0]);
                }
                throw new FailedLoginException("The user cookie was not found.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Logged in session ID=" + sid + "; asserted=" + name, new Object[0]);
            }
            this.m_principals.add(new WikiPrincipal(name, "fullName"));
            return true;
        }
        catch (IOException e) {
            log.error("IOException: " + e.getMessage(), new Object[0]);
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error(message, e);
            throw new LoginException(message);
        }
    }

    public static String getUserCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue(request, PREFS_COOKIE_NAME);
        return TextUtil.urlDecodeUTF8(cookie);
    }

    public static void setUserCookie(HttpServletResponse response, String name) {
        name = TextUtil.urlEncodeUTF8(name);
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, name);
        userId.setMaxAge(86486400);
        response.addCookie(userId);
    }

    public static void clearUserCookie(HttpServletResponse response) {
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
    }
}

