/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class AnonymousLoginModule
extends AbstractLoginModule {
    public static final String PROMPT = "User name";
    protected static final Logger log = LoggerFactory.getLogger(AnonymousLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            WikiPrincipal ipAddr = new WikiPrincipal(request.getRemoteAddr(), "ipAddress");
            if (log.isDebugEnabled()) {
                HttpSession session = request.getSession(false);
                String sid = session == null ? "(null)" : session.getId();
                log.debug("Logged in session ID=" + sid + "; IP=" + ipAddr, new Object[0]);
            }
            this.m_principals.add(ipAddr);
            return true;
        }
        catch (IOException e) {
            log.error("IOException: " + e.getMessage(), new Object[0]);
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error(message, e);
            throw new LoginException(message);
        }
    }
}

