/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginModule.class);
    protected CallbackHandler m_handler;
    protected Locale m_locale = null;
    protected Map<String, ?> m_options;
    protected Collection<Principal> m_previousWikiPrincipals;
    protected Collection<Principal> m_principals;
    protected Collection<Principal> m_principalsToRemove;
    protected Collection<Principal> m_principalsToOverwrite;
    protected Map<String, ?> m_state;
    protected Subject m_subject;
    protected static final String NULL = "(null)";

    @Override
    public final boolean abort() throws LoginException {
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return true;
    }

    @Override
    public final boolean commit() {
        if (this.succeeded()) {
            this.removePrincipals(this.m_previousWikiPrincipals);
            for (Principal principal : this.m_principals) {
                this.m_subject.getPrincipals().add(principal);
                if (!log.isDebugEnabled()) continue;
                log.debug("Committed Principal " + principal.getName(), new Object[0]);
            }
            this.removePrincipals(this.m_principalsToOverwrite);
            return true;
        }
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return false;
    }

    @Override
    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.m_previousWikiPrincipals = new HashSet<Principal>();
        this.m_principals = new HashSet<Principal>();
        this.m_principalsToRemove = new HashSet<Principal>();
        this.m_principalsToOverwrite = new HashSet<Principal>();
        this.m_subject = subject;
        this.m_handler = callbackHandler;
        this.m_state = sharedState;
        this.m_options = options;
        if (subject == null) {
            throw new IllegalStateException("Subject cannot be null");
        }
        if (callbackHandler == null) {
            throw new IllegalStateException("Callback handler cannot be null");
        }
        this.m_previousWikiPrincipals.addAll(subject.getPrincipals(WikiPrincipal.class));
        Callback[] callbacks = new Callback[]{new LanguageCallback()};
        try {
            callbackHandler.handle(callbacks);
            this.m_locale = ((LanguageCallback)callbacks[0]).getLocale();
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
    }

    @Override
    public abstract boolean login() throws LoginException;

    @Override
    public final boolean logout() throws LoginException {
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return true;
    }

    private final boolean succeeded() {
        return this.m_principals.size() > 0;
    }

    private final void removePrincipals(Collection<Principal> principals) {
        for (Principal principal : principals) {
            if (!this.m_subject.getPrincipals().contains(principal)) continue;
            this.m_subject.getPrincipals().remove(principal);
            if (!log.isDebugEnabled()) continue;
            log.debug("Removed Principal " + principal.getName(), new Object[0]);
        }
    }
}

