/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupDatabase;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLGroupDatabase
implements GroupDatabase {
    protected static final Logger log = LoggerFactory.getLogger(XMLGroupDatabase.class);
    public static final String PROP_DATABASE = "jspwiki.xmlGroupDatabaseFile";
    private static final String DEFAULT_DATABASE = "groupdatabase.xml";
    private static final String CREATED = "created";
    private static final String CREATOR = "creator";
    private static final String GROUP_TAG = "group";
    private static final String GROUP_NAME = "name";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String MODIFIER = "modifier";
    private static final String MEMBER_TAG = "member";
    private static final String PRINCIPAL = "principal";
    private Document m_dom = null;
    private DateFormat m_defaultFormat = DateFormat.getDateTimeInstance();
    private DateFormat m_format = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss:SSS z");
    private File m_file = null;
    private WikiEngine m_engine = null;
    private Map<String, Group> m_groups = new HashMap<String, Group>();
    private long m_lastCheck = 0L;
    private long m_lastModified = 0L;

    public void commit() throws WikiSecurityException {
    }

    public void delete(Group group) throws WikiSecurityException {
        String index = group.getName();
        boolean exists = this.m_groups.containsKey(index);
        if (!exists) {
            throw new NoSuchPrincipalException("Not in database: " + group.getName());
        }
        this.m_groups.remove(index);
        this.saveDOM();
    }

    public Group[] groups() throws WikiSecurityException {
        this.buildDOM();
        Collection<Group> groups = this.m_groups.values();
        return groups.toArray(new Group[groups.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, WikiSecurityException {
        this.m_engine = engine;
        File defaultFile = null;
        if (engine.getRootPath() == null) {
            log.warn("Cannot identify JSPWiki root path", new Object[0]);
            defaultFile = new File("WEB-INF/groupdatabase.xml").getAbsoluteFile();
        } else {
            defaultFile = new File(String.valueOf(engine.getRootPath()) + "/WEB-INF/" + DEFAULT_DATABASE);
        }
        String file = props.getProperty(PROP_DATABASE);
        if (file == null) {
            log.warn("XML group database property jspwiki.xmlGroupDatabaseFile not found; trying " + defaultFile, new Object[0]);
            this.m_file = defaultFile;
        } else {
            this.m_file = new File(file);
        }
        log.info("XML group database at " + this.m_file.getAbsolutePath(), new Object[0]);
        this.buildDOM();
    }

    public void save(Group group, Principal modifier) throws WikiSecurityException {
        if (group == null || modifier == null) {
            throw new IllegalArgumentException("Group or modifier cannot be null.");
        }
        this.checkForRefresh();
        String index = group.getName();
        boolean isNew = !this.m_groups.containsKey(index);
        Date modDate = new Date(System.currentTimeMillis());
        if (isNew) {
            group.setCreated(modDate);
            group.setCreator(modifier.getName());
        }
        group.setModifier(modifier.getName());
        group.setLastModified(modDate);
        this.m_groups.put(index, group);
        this.saveDOM();
    }

    private void buildDOM() throws WikiSecurityException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        try {
            this.m_dom = factory.newDocumentBuilder().parse(this.m_file);
            log.debug("Database successfully initialized", new Object[0]);
            this.m_lastModified = this.m_file.lastModified();
            this.m_lastCheck = System.currentTimeMillis();
        }
        catch (ParserConfigurationException e) {
            log.error("Configuration error: " + e.getMessage(), new Object[0]);
        }
        catch (SAXException e) {
            log.error("SAX error: " + e.getMessage(), new Object[0]);
        }
        catch (FileNotFoundException e) {
            log.info("Group database not found; creating from scratch...", new Object[0]);
        }
        catch (IOException e) {
            log.error("IO error: " + e.getMessage(), new Object[0]);
        }
        if (this.m_dom == null) {
            try {
                this.m_dom = factory.newDocumentBuilder().newDocument();
                this.m_dom.appendChild(this.m_dom.createElement("groups"));
            }
            catch (ParserConfigurationException e) {
                log.error("Could not create in-memory DOM", new Object[0]);
            }
        }
        if (this.m_dom != null) {
            NodeList groupNodes = this.m_dom.getElementsByTagName(GROUP_TAG);
            int i = 0;
            while (i < groupNodes.getLength()) {
                Element groupNode = (Element)groupNodes.item(i);
                String groupName = groupNode.getAttribute(GROUP_NAME);
                if (groupName == null) {
                    log.warn("Detected null group name in XMLGroupDataBase. Check your group database.", new Object[0]);
                } else {
                    Group group = this.buildGroup(groupNode, groupName);
                    this.m_groups.put(groupName, group);
                }
                ++i;
            }
        }
    }

    private void checkForRefresh() {
        long lastModified;
        long time = System.currentTimeMillis();
        if (time - this.m_lastCheck > 60000L && (lastModified = this.m_file.lastModified()) > this.m_lastModified) {
            try {
                this.buildDOM();
            }
            catch (WikiSecurityException e) {
                log.error("Could not refresh DOM", e);
            }
        }
    }

    private Group buildGroup(Element groupNode, String name) {
        if (groupNode == null || name == null) {
            throw new IllegalArgumentException("DOM element or name cannot be null.");
        }
        Group group = new Group(name, this.m_engine.getApplicationName());
        NodeList members = groupNode.getElementsByTagName(MEMBER_TAG);
        int i = 0;
        while (i < members.getLength()) {
            Element memberNode = (Element)members.item(i);
            String principalName = memberNode.getAttribute(PRINCIPAL);
            WikiPrincipal member = new WikiPrincipal(principalName);
            group.add(member);
            ++i;
        }
        String creator = groupNode.getAttribute(CREATOR);
        String created = groupNode.getAttribute(CREATED);
        String modifier = groupNode.getAttribute(MODIFIER);
        String modified = groupNode.getAttribute(LAST_MODIFIED);
        try {
            group.setCreated(this.m_format.parse(created));
            group.setLastModified(this.m_format.parse(modified));
        }
        catch (ParseException e) {
            try {
                group.setCreated(this.m_defaultFormat.parse(created));
                group.setLastModified(this.m_defaultFormat.parse(modified));
            }
            catch (ParseException e2) {
                log.warn("Could not parse 'created' or 'lastModified' attribute for  group'" + group.getName() + "'." + " It may have been tampered with.", new Object[0]);
            }
        }
        group.setCreator(creator);
        group.setModifier(modifier);
        return group;
    }

    private void saveDOM() throws WikiSecurityException {
        if (this.m_dom == null) {
            log.error("Group database doesn't exist in memory.", new Object[0]);
        }
        File newFile = new File(String.valueOf(this.m_file.getAbsolutePath()) + ".new");
        try {
            BufferedWriter io = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8"));
            io.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            io.write("<groups>\n");
            for (Group group : this.m_groups.values()) {
                io.write("  <group ");
                io.write(GROUP_NAME);
                io.write("=\"" + StringEscapeUtils.escapeXml((String)group.getName()) + "\" ");
                io.write(CREATOR);
                io.write("=\"" + StringEscapeUtils.escapeXml((String)group.getCreator()) + "\" ");
                io.write(CREATED);
                io.write("=\"" + this.m_format.format(group.getCreated()) + "\" ");
                io.write(MODIFIER);
                io.write("=\"" + group.getModifier() + "\" ");
                io.write(LAST_MODIFIED);
                io.write("=\"" + this.m_format.format(group.getLastModified()) + "\"");
                io.write(">\n");
                Principal[] principalArray = group.members();
                int n = principalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Principal member = principalArray[n2];
                    io.write("    <member ");
                    io.write(PRINCIPAL);
                    io.write("=\"" + StringEscapeUtils.escapeXml((String)member.getName()) + "\" ");
                    io.write("/>\n");
                    ++n2;
                }
                io.write("  </group>\n");
            }
            io.write("</groups>");
            io.close();
        }
        catch (IOException e) {
            throw new WikiSecurityException(e.getLocalizedMessage(), e);
        }
        File backup = new File(String.valueOf(this.m_file.getAbsolutePath()) + ".old");
        if (backup.exists() && !backup.delete()) {
            log.error("Could not delete old group database backup: " + backup, new Object[0]);
        }
        if (!this.m_file.renameTo(backup)) {
            log.error("Could not create group database backup: " + backup, new Object[0]);
        }
        if (!newFile.renameTo(this.m_file)) {
            log.error("Could not save database: " + backup + " restoring backup.", new Object[0]);
            if (!backup.renameTo(this.m_file)) {
                log.error("Restore failed. Check the file permissions.", new Object[0]);
            }
            log.error("Could not save database: " + this.m_file + ". Check the file permissions", new Object[0]);
        }
    }
}

