/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class WebContainerAuthorizer
implements WebAuthorizer {
    private static final String J2EE_SCHEMA_24_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    protected static final Logger log = LoggerFactory.getLogger(WebContainerAuthorizer.class);
    protected WikiEngine m_engine;
    protected Role[] m_containerRoles = new Role[0];
    protected boolean m_containerAuthorized = false;
    private Document m_webxml = null;

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_containerAuthorized = false;
        try {
            this.m_webxml = this.getWebXml();
            if (this.m_webxml != null) {
                this.m_webxml.getRootElement().setNamespace(Namespace.getNamespace((String)J2EE_SCHEMA_24_NAMESPACE));
                boolean bl = this.m_containerAuthorized = this.isConstrained("/Delete.jsp", Role.ALL) && this.isConstrained("/Login.jsp", Role.ALL);
            }
            if (this.m_containerAuthorized) {
                this.m_containerRoles = this.getRoles(this.m_webxml);
                log.info("JSPWiki is using container-managed authentication.", new Object[0]);
            } else {
                log.info("JSPWiki is using custom authentication.", new Object[0]);
            }
        }
        catch (IOException e) {
            log.error("Initialization failed: ", e);
            throw new InternalWikiException(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        }
        catch (JDOMException e) {
            log.error("Malformed XML in web.xml", e);
            throw new InternalWikiException(String.valueOf(((Object)((Object)e)).getClass().getName()) + ": " + e.getMessage());
        }
        if (this.m_containerRoles.length > 0) {
            String roles = "";
            Role[] roleArray = this.m_containerRoles;
            int n = this.m_containerRoles.length;
            int n2 = 0;
            while (n2 < n) {
                Role containerRole = roleArray[n2];
                roles = String.valueOf(roles) + containerRole + " ";
                ++n2;
            }
            log.info(" JSPWiki determined the web container manages these roles: " + roles, new Object[0]);
        }
        log.info("Authorizer WebContainerAuthorizer initialized successfully.", new Object[0]);
    }

    public boolean isUserInRole(HttpServletRequest request, Principal role) {
        return request.isUserInRole(role.getName());
    }

    public boolean isUserInRole(WikiSession session, Principal role) {
        if (session == null || role == null) {
            return false;
        }
        return session.hasPrincipal(role);
    }

    public Principal findRole(String role) {
        Role[] roleArray = this.m_containerRoles;
        int n = this.m_containerRoles.length;
        int n2 = 0;
        while (n2 < n) {
            Role containerRole = roleArray[n2];
            if (containerRole.getName().equals(role)) {
                return containerRole;
            }
            ++n2;
        }
        return null;
    }

    public Role[] findRoles(WikiSession session) throws WikiSecurityException {
        throw new WikiSecurityException("Not supported by this Authorizer.");
    }

    public boolean isConstrained(String url, Role role) throws JDOMException {
        Element root = this.m_webxml.getRootElement();
        String selector = "//j:web-app/j:security-constraint[j:web-resource-collection/j:url-pattern=\"" + url + "\"]";
        XPath xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_24_NAMESPACE);
        List constraints = xpath.selectNodes((Object)root);
        selector = "//j:web-app/j:security-constraint[j:auth-constraint/j:role-name=\"" + role.getName() + "\"]";
        xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_24_NAMESPACE);
        List roles = xpath.selectNodes((Object)root);
        if (constraints.size() == 0) {
            return false;
        }
        if (role.equals(Role.ALL)) {
            return true;
        }
        if (roles.size() == 0) {
            return false;
        }
        for (Element constraint : constraints) {
            for (Element roleConstraint : roles) {
                if (!constraint.equals((Object)roleConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainerAuthorized() {
        return this.m_containerAuthorized;
    }

    public Principal[] getRoles() {
        return (Principal[])this.m_containerRoles.clone();
    }

    protected Role[] getRoles(Document webxml) throws JDOMException {
        String role;
        HashSet<Role> roles = new HashSet<Role>();
        Element root = webxml.getRootElement();
        String selector = "//j:web-app/j:security-constraint/j:auth-constraint/j:role-name";
        XPath xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_24_NAMESPACE);
        List nodes = xpath.selectNodes((Object)root);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            role = ((Element)it.next()).getTextTrim();
            roles.add(new Role(role));
        }
        selector = "//j:web-app/j:security-role/j:role-name";
        xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_24_NAMESPACE);
        nodes = xpath.selectNodes((Object)root);
        it = nodes.iterator();
        while (it.hasNext()) {
            role = ((Element)it.next()).getTextTrim();
            roles.add(new Role(role));
        }
        return roles.toArray(new Role[roles.size()]);
    }

    protected Document getWebXml() throws JDOMException, IOException {
        URL url;
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        Document doc = null;
        if (this.m_engine.getServletContext() == null) {
            ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
            url = cl.getResource("WEB-INF/web.xml");
            if (url != null) {
                log.info("Examining " + url.toExternalForm(), new Object[0]);
            }
        } else {
            url = this.m_engine.getServletContext().getResource("/WEB-INF/web.xml");
            if (url != null) {
                log.info("Examining " + url.toExternalForm(), new Object[0]);
            }
        }
        if (url == null) {
            throw new IOException("Unable to find web.xml for processing.");
        }
        log.debug("Processing web.xml at " + url.toExternalForm(), new Object[0]);
        doc = builder.build(url);
        return doc;
    }
}

