/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.LdapConfig;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;

public class LdapAuthorizer
implements Authorizer {
    private Hashtable<String, String> m_jndiEnv;
    private LdapConfig m_cfg = null;
    private String m_allRolesFilter = null;
    private String m_roleFilter = null;
    private String m_userRolesFilter = null;
    private static final String[] REQUIRED_PROPERTIES = new String[]{"ldap.connectionURL", "ldap.roleBase", "ldap.isInRoleFilter"};
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();

    static {
        SEARCH_CONTROLS.setSearchScope(2);
    }

    public Principal findRole(String role) {
        try {
            InitialLdapContext ctx = new InitialLdapContext(this.m_jndiEnv, null);
            String filter = this.m_roleFilter;
            filter = filter.replace("{0}", LdapConfig.escapeFilterString(role));
            NamingEnumeration<SearchResult> roles = ctx.search(this.m_cfg.roleBase, filter, SEARCH_CONTROLS);
            if (roles.hasMore()) {
                return new Role(role);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Principal[] getRoles() {
        HashSet<Role> foundRoles = new HashSet<Role>();
        try {
            InitialLdapContext ctx = new InitialLdapContext(this.m_jndiEnv, null);
            NamingEnumeration<SearchResult> roles = ctx.search(this.m_cfg.roleBase, this.m_allRolesFilter, SEARCH_CONTROLS);
            while (roles.hasMore()) {
                SearchResult foundRole = roles.next();
                String roleName = (String)foundRole.getAttributes().get("cn").get(0);
                foundRoles.add(new Role(roleName));
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return foundRoles.toArray(new Role[foundRoles.size()]);
    }

    public Role[] findRoles(WikiSession session) throws WikiSecurityException {
        String loginName = session.getLoginPrincipal().getName();
        HashSet<Role> foundRoles = new HashSet<Role>();
        try {
            String dn = this.m_cfg.getUserDn(loginName);
            dn = LdapConfig.escapeFilterString(dn);
            String filter = this.m_userRolesFilter.replace("{1}", dn);
            InitialLdapContext ctx = new InitialLdapContext(this.m_jndiEnv, null);
            NamingEnumeration<SearchResult> roles = ctx.search(this.m_cfg.roleBase, filter, SEARCH_CONTROLS);
            while (roles.hasMore()) {
                SearchResult foundRole = roles.next();
                String roleName = (String)foundRole.getAttributes().get("cn").get(0);
                foundRoles.add(new Role(roleName));
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return foundRoles.toArray(new Role[foundRoles.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws WikiSecurityException {
        this.m_cfg = LdapConfig.getInstance(engine.getAuthenticationManager().getKeychain(), props, REQUIRED_PROPERTIES);
        this.m_roleFilter = this.m_cfg.isInRoleFilter.replace("{1}", "*");
        this.m_userRolesFilter = this.m_cfg.isInRoleFilter.replace("{0}", "*");
        this.m_allRolesFilter = this.m_userRolesFilter.replace("{1}", "*");
        try {
            this.m_jndiEnv = this.m_cfg.newJndiEnvironment();
            new InitialLdapContext(this.m_jndiEnv, null);
        }
        catch (NamingException e) {
            throw new WikiSecurityException("Could not start LdapAuthorizer! Cause: " + e.getMessage(), e);
        }
    }

    public boolean isUserInRole(WikiSession session, Principal role) {
        String loginName = session.getLoginPrincipal().getName();
        try {
            String dn = this.m_cfg.getUserDn(loginName);
            dn = LdapConfig.escapeFilterString(dn);
            InitialLdapContext ctx = new InitialLdapContext(this.m_jndiEnv, null);
            String roleName = LdapConfig.escapeFilterString(role.getName());
            String filter = this.m_cfg.isInRoleFilter.replace("{0}", roleName);
            filter = filter.replace("{1}", dn);
            NamingEnumeration<SearchResult> roles = ctx.search(this.m_cfg.roleBase, filter, SEARCH_CONTROLS);
            boolean isMember = roles.hasMore();
            return isMember;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return false;
        }
    }
}

