/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupDatabase;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.XMLGroupDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.InputValidator;
import org.apache.wiki.util.ClassUtil;

public final class GroupManager
implements Authorizer,
WikiEventListener {
    public static final String MESSAGES_KEY = "group";
    private static final String PROP_GROUPDATABASE = "jspwiki.groupdatabase";
    static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    protected WikiEngine m_engine;
    protected WikiEventListener m_groupListener;
    private GroupDatabase m_groupDatabase = null;
    private final Map<Principal, Group> m_groups = new HashMap<Principal, Group>();

    public Principal findRole(String name) {
        try {
            Group group = this.getGroup(name);
            return group.getPrincipal();
        }
        catch (NoSuchPrincipalException e) {
            return null;
        }
    }

    public Role[] findRoles(WikiSession session) throws WikiSecurityException {
        throw new WikiSecurityException("Not supported by this Authorizer.");
    }

    public Group getGroup(String name, boolean create) throws NoSuchPrincipalException, WikiSecurityException {
        if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
            throw new WikiSecurityException("Illegal group name: " + name);
        }
        Group group = this.m_groups.get(new GroupPrincipal(name));
        if (group == null) {
            if (create) {
                group = new Group(name, this.m_engine.getApplicationName());
            } else {
                throw new NoSuchPrincipalException("Group " + name + " not found.");
            }
        }
        return group;
    }

    public final Group getGroup(String name) throws NoSuchPrincipalException {
        Group group = this.m_groups.get(new GroupPrincipal(name));
        if (group != null) {
            return group;
        }
        throw new NoSuchPrincipalException("Group " + name + " not found.");
    }

    public final GroupDatabase getGroupDatabase() throws WikiSecurityException {
        if (this.m_groupDatabase != null) {
            return this.m_groupDatabase;
        }
        String dbClassName = "<unknown>";
        String dbInstantiationError = null;
        Exception cause = null;
        try {
            Properties props = this.m_engine.getWikiProperties();
            dbClassName = props.getProperty(PROP_GROUPDATABASE);
            if (dbClassName == null) {
                dbClassName = XMLGroupDatabase.class.getName();
            }
            log.info("Attempting to load group database class " + dbClassName, new Object[0]);
            Class<?> dbClass = ClassUtil.findClass("org.apache.wiki.auth.authorize", dbClassName);
            this.m_groupDatabase = (GroupDatabase)dbClass.newInstance();
            this.m_groupDatabase.initialize(this.m_engine, this.m_engine.getWikiProperties());
            log.info("Group database initialized.", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.error("GroupDatabase class " + dbClassName + " cannot be found.", e);
            dbInstantiationError = "Failed to locate GroupDatabase class " + dbClassName;
            cause = e;
        }
        catch (InstantiationException e) {
            log.error("GroupDatabase class " + dbClassName + " cannot be created.", e);
            dbInstantiationError = "Failed to create GroupDatabase class " + dbClassName;
            cause = e;
        }
        catch (IllegalAccessException e) {
            log.error("You are not allowed to access group database class " + dbClassName + ".", e);
            dbInstantiationError = "Access GroupDatabase class " + dbClassName + " denied";
            cause = e;
        }
        catch (NoRequiredPropertyException e) {
            log.error("Missing property: " + e.getMessage() + ".", new Object[0]);
            dbInstantiationError = "Missing property: " + e.getMessage();
            cause = e;
        }
        if (dbInstantiationError != null) {
            throw new WikiSecurityException(String.valueOf(dbInstantiationError) + " Cause: " + (cause != null ? cause.getMessage() : ""), cause);
        }
        return this.m_groupDatabase;
    }

    public final Principal[] getRoles() {
        return this.m_groups.keySet().toArray(new Principal[this.m_groups.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(WikiEngine engine, Properties props) throws WikiSecurityException {
        this.m_engine = engine;
        try {
            this.m_groupDatabase = this.getGroupDatabase();
        }
        catch (WikiException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Group[] groups = this.m_groupDatabase.groups();
        Map<Principal, Group> map = this.m_groups;
        synchronized (map) {
            Group[] groupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                this.m_groups.put(group.getPrincipal(), group);
                this.fireEvent(46, group);
                ++n2;
            }
        }
        engine.getUserManager().addWikiEventListener(this);
        log.info("Authorizer GroupManager initialized successfully; loaded " + groups.length + " group(s).", new Object[0]);
    }

    public final boolean isUserInRole(WikiSession session, Principal role) {
        if (session == null || role == null || !(role instanceof GroupPrincipal) || !session.isAuthenticated()) {
            return false;
        }
        Group group = this.m_groups.get(role);
        if (group == null) {
            return false;
        }
        Principal[] principalArray = session.getPrincipals();
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal principal = principalArray[n2];
            if (AuthenticationManager.isUserPrincipal(principal) && group.isMember(principal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Group parseGroup(String name, String memberLine, boolean create) throws WikiSecurityException {
        int n;
        int n2;
        Object[] objectArray;
        Group group;
        block8: {
            if (name == null) {
                if (!create) throw new WikiSecurityException("Group name cannot be blank.");
                name = "MyGroup";
            } else if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
                throw new WikiSecurityException("Illegal group name: " + name);
            }
            name = name.trim();
            if (InputValidator.isBlank(memberLine)) {
                memberLine = "";
            }
            memberLine = memberLine.trim();
            group = new Group(name, this.m_engine.getApplicationName());
            try {
                Group existingGroup = this.getGroup(name);
                group.setCreator(existingGroup.getCreator());
                group.setCreated(existingGroup.getCreated());
                group.setModifier(existingGroup.getModifier());
                group.setLastModified(existingGroup.getLastModified());
                objectArray = existingGroup.members();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object existingMember = objectArray[n];
                    group.add((Principal)existingMember);
                    ++n;
                }
            }
            catch (NoSuchPrincipalException e) {
                if (create) break block8;
                throw new NoSuchPrincipalException("Group '" + name + "' does not exist.");
            }
        }
        String[] members = this.extractMembers(memberLine);
        if (members.length <= 0) return group;
        group.clear();
        objectArray = members;
        n2 = members.length;
        n = 0;
        while (n < n2) {
            Object member = objectArray[n];
            group.add(new WikiPrincipal((String)member));
            ++n;
        }
        return group;
    }

    public final Group parseGroup(WikiContext context, boolean create) throws WikiSecurityException {
        String memberLine;
        HttpServletRequest request = context.getHttpRequest();
        String name = request.getParameter(MESSAGES_KEY);
        Group group = this.parseGroup(name, memberLine = request.getParameter("members"), create);
        if (group.members().length == 0) {
            group.add(context.getWikiSession().getUserPrincipal());
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGroup(String index) throws WikiSecurityException {
        if (index == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        Group group = this.m_groups.get(new GroupPrincipal(index));
        if (group == null) {
            throw new NoSuchPrincipalException("Group " + index + " not found");
        }
        Map<Principal, Group> map = this.m_groups;
        synchronized (map) {
            this.m_groups.remove(group.getPrincipal());
        }
        this.m_groupDatabase.delete(group);
        this.fireEvent(47, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGroup(WikiSession session, Group group) throws WikiSecurityException {
        Map<Principal, Group> map;
        Group oldGroup = this.m_groups.get(group.getPrincipal());
        if (oldGroup != null) {
            this.fireEvent(47, oldGroup);
            map = this.m_groups;
            synchronized (map) {
                this.m_groups.remove(oldGroup.getPrincipal());
            }
        }
        if (oldGroup != null) {
            group.setCreator(oldGroup.getCreator());
            group.setCreated(oldGroup.getCreated());
            group.setModifier(oldGroup.getModifier());
            group.setLastModified(oldGroup.getLastModified());
        }
        map = this.m_groups;
        synchronized (map) {
            this.m_groups.put(group.getPrincipal(), group);
        }
        this.fireEvent(46, group);
        try {
            this.m_groupDatabase.save(group, session.getUserPrincipal());
        }
        catch (WikiSecurityException e) {
            if (oldGroup != null) {
                this.fireEvent(47, group);
                this.fireEvent(46, oldGroup);
                Map<Principal, Group> map2 = this.m_groups;
                synchronized (map2) {
                    this.m_groups.put(oldGroup.getPrincipal(), oldGroup);
                }
                throw new WikiSecurityException(String.valueOf(e.getMessage()) + " (rolled back to previous version).", e);
            }
            throw new WikiSecurityException(e.getMessage(), e);
        }
    }

    public final void validateGroup(WikiContext context, Group group) {
        InputValidator validator = new InputValidator(MESSAGES_KEY, context);
        try {
            this.checkGroupName(context, group.getName());
        }
        catch (WikiSecurityException wikiSecurityException) {
            // empty catch block
        }
        Principal[] members = group.members();
        int i = 0;
        while (i < members.length) {
            validator.validateNotNull(members[i].getName(), "Full name", 2);
            ++i;
        }
    }

    protected final String[] extractMembers(String memberLine) {
        HashSet<String> members = new HashSet<String>();
        if (memberLine != null) {
            StringTokenizer tok = new StringTokenizer(memberLine, "\n");
            while (tok.hasMoreTokens()) {
                String uid = tok.nextToken().trim();
                if (uid == null || uid.length() <= 0) continue;
                members.add(uid);
            }
        }
        return members.toArray(new String[members.size()]);
    }

    protected final void checkGroupName(WikiContext context, String name) throws WikiSecurityException {
        InputValidator validator = new InputValidator(MESSAGES_KEY, context);
        validator.validateNotNull(name, "Group name");
        if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
            throw new WikiSecurityException("The group name '" + name + "' is illegal. Choose another.");
        }
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent((Object)this, type, target, new Serializable[0]));
        }
    }

    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            WikiSession session = (WikiSession)se.getSource();
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            int groupsChanged = 0;
            try {
                Group[] groupArray = this.m_groupDatabase.groups();
                int n = groupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Group group = groupArray[n2];
                    boolean groupChanged = false;
                    Principal[] principalArray = oldPrincipals;
                    int n3 = oldPrincipals.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Principal oldPrincipal = principalArray[n4];
                        if (group.isMember(oldPrincipal)) {
                            group.remove(oldPrincipal);
                            group.add(newPrincipal);
                            groupChanged = true;
                        }
                        ++n4;
                    }
                    if (groupChanged) {
                        this.setGroup(session, group);
                        ++groupsChanged;
                    }
                    ++n2;
                }
            }
            catch (WikiException e) {
                log.error("Could not change user name in Group lists because of GroupDatabase error:" + e.getMessage(), new Object[0]);
            }
            log.info("Profile name change for '" + newPrincipal.toString() + "' caused " + groupsChanged + " groups to change also.", new Object[0]);
        }
    }
}

