/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.acl;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclEntryImpl;
import org.apache.wiki.auth.acl.AclImpl;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;

public class DefaultAclManager
implements AclManager {
    static Logger log = LoggerFactory.getLogger(DefaultAclManager.class);
    private AuthorizationManager m_auth = null;
    private WikiEngine m_engine = null;
    private static final String PERM_REGEX = "(comment|delete|edit|modify|rename|upload|view)";
    private static final String ACL_REGEX = "\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]";
    public static final Pattern ACL_PATTERN = Pattern.compile("\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]");

    public void initialize(WikiEngine engine, Properties props) {
        this.m_auth = engine.getAuthorizationManager();
        this.m_engine = engine;
    }

    public Acl parseAcl(WikiPage page, String ruleLine) throws WikiSecurityException {
        Acl acl = page.getAcl();
        if (acl == null) {
            acl = new AclImpl();
        }
        try {
            StringTokenizer fieldToks = new StringTokenizer(ruleLine);
            fieldToks.nextToken();
            String actions = fieldToks.nextToken();
            page.getName();
            while (fieldToks.hasMoreTokens()) {
                String principalName = fieldToks.nextToken(",").trim();
                Principal principal = this.m_auth.resolvePrincipal(principalName);
                AclEntry oldEntry = acl.getEntry(principal);
                if (oldEntry != null) {
                    log.debug("Adding to old acl list: " + principal + ", " + actions, new Object[0]);
                    oldEntry.addPermission(PermissionFactory.getPagePermission(page, actions));
                    continue;
                }
                log.debug("Adding new acl entry for " + actions, new Object[0]);
                AclEntryImpl entry = new AclEntryImpl();
                entry.setPrincipal(principal);
                entry.addPermission(PermissionFactory.getPagePermission(page, actions));
                acl.addEntry(entry);
            }
            page.setAcl(acl);
            log.debug(acl.toString(), new Object[0]);
        }
        catch (NoSuchElementException nsee) {
            log.warn("Invalid access rule: " + ruleLine + " - defaults will be used.", new Object[0]);
            throw new WikiSecurityException("Invalid access rule: " + ruleLine, nsee);
        }
        catch (IllegalArgumentException iae) {
            throw new WikiSecurityException("Invalid permission type: " + ruleLine, iae);
        }
        return acl;
    }

    public Acl getPermissions(WikiPage page) throws WikiSecurityException {
        Acl acl = page.getAcl();
        if (log.isDebugEnabled()) {
            log.debug("page=" + page.getName() + "\n" + acl, new Object[0]);
        }
        if (acl == null) {
            try {
                WikiPage parent = page.getParent();
                acl = this.getPermissions(parent);
            }
            catch (PageNotFoundException e) {
                return new AclImpl();
            }
            catch (ProviderException e) {
                throw new WikiSecurityException("Unable to get parent page to check for permissions.", e);
            }
        }
        return acl;
    }

    public void setPermissions(WikiPage page, Acl acl) throws WikiSecurityException {
        try {
            String pageText = page.getContentAsString();
            Matcher matcher = ACL_PATTERN.matcher(pageText);
            String cleansedText = matcher.replaceAll("");
            page.setAcl(acl);
            if (pageText != null && !pageText.equals(cleansedText)) {
                page.setContent(cleansedText);
            }
        }
        catch (ProviderException e) {
            throw new WikiSecurityException("Could not set Acl. Reason: ProviderException " + e.getMessage(), e);
        }
    }

    protected static String printAcl(Acl acl) {
        List<Principal> principals;
        TreeMap<String, ArrayList<Principal>> permissionPrincipals = new TreeMap<String, ArrayList<Principal>>();
        Enumeration<AclEntry> entries = acl.entries();
        while (entries.hasMoreElements()) {
            AclEntry entry = entries.nextElement();
            Principal principal = entry.getPrincipal();
            Enumeration<Permission> permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission permission = permissions.nextElement();
                principals = (List)permissionPrincipals.get(permission.getActions());
                if (principals == null) {
                    principals = new ArrayList<Principal>();
                    String action = permission.getActions();
                    if (action.indexOf(44) != -1) {
                        throw new IllegalStateException("AclEntry permission cannot have multiple targets.");
                    }
                    permissionPrincipals.put(action, (ArrayList<Principal>)principals);
                }
                principals.add(principal);
            }
        }
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : permissionPrincipals.entrySet()) {
            String action = (String)entry.getKey();
            principals = (ArrayList<Principal>)entry.getValue();
            Collections.sort(principals, new PrincipalComparator());
            s.append("[{ALLOW ");
            s.append(action);
            s.append(" ");
            int i = 0;
            while (i < principals.size()) {
                Principal principal = (Principal)principals.get(i);
                s.append(principal.getName());
                if (i < principals.size() - 1) {
                    s.append(",");
                }
                ++i;
            }
            s.append("}]\n");
        }
        return s.toString();
    }
}

