/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.acl;

import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.permissions.PagePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryImpl
implements AclEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<Permission> m_permissions = new Vector();
    private Principal m_principal;

    @Override
    public synchronized boolean addPermission(Permission permission) {
        if (permission instanceof PagePermission && this.findPermission(permission) == null) {
            this.m_permissions.add(permission);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkPermission(Permission permission) {
        return this.findPermission(permission) != null;
    }

    @Override
    public synchronized Principal getPrincipal() {
        return this.m_principal;
    }

    @Override
    public Enumeration<Permission> permissions() {
        return this.m_permissions.elements();
    }

    @Override
    public synchronized boolean removePermission(Permission permission) {
        Permission p = this.findPermission(permission);
        if (p != null) {
            this.m_permissions.remove(p);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setPrincipal(Principal user) {
        if (this.m_principal != null || user == null) {
            return false;
        }
        this.m_principal = user;
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Principal p = this.getPrincipal();
        sb.append("[AclEntry ALLOW " + (p != null ? p.getName() : "null"));
        sb.append(" ");
        for (Permission pp : this.m_permissions) {
            sb.append(pp.toString());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private Permission findPermission(Permission p) {
        for (Permission pp : this.m_permissions) {
            if (!pp.implies(p)) continue;
            return pp;
        }
        return null;
    }
}

