/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.rpc.RPCCallable;
import org.apache.wiki.rpc.json.JSONRPCManager;
import org.apache.wiki.ui.InputValidator;
import org.apache.wiki.util.MailUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;

public final class UserManager {
    public static final String PROP_READ_ONLY_PROFILES = "jspwiki.userdatabase.readOnlyProfiles";
    private static final String USERDATABASE_PACKAGE = "org.apache.wiki.auth.user";
    private static final String SESSION_MESSAGES = "profile";
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_FULLNAME = "fullname";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_LOGINNAME = "loginname";
    private static final String UNKNOWN_CLASS = "<unknown>";
    private WikiEngine m_engine;
    private boolean m_readOnlyProfiles = false;
    private static Logger log = LoggerFactory.getLogger(UserManager.class);
    public static final String SAVE_APPROVER = "workflow.createUserProfile";
    public static final String PROP_DATABASE = "jspwiki.userdatabase";
    protected static final String SAVE_TASK_MESSAGE_KEY = "task.createUserProfile";
    protected static final String SAVED_PROFILE = "userProfile";
    protected static final String SAVE_DECISION_MESSAGE_KEY = "decision.createUserProfile";
    protected static final String FACT_SUBMITTER = "fact.submitter";
    protected static final String PREFS_LOGIN_NAME = "prefs.loginname";
    protected static final String PREFS_FULL_NAME = "prefs.fullname";
    protected static final String PREFS_EMAIL = "prefs.email";
    private final Map<WikiSession, UserProfile> m_profiles = new WeakHashMap<WikiSession, UserProfile>();
    private UserDatabase m_database;
    private boolean m_useJAAS = true;

    public final void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_useJAAS = "jaas".equals(props.getProperty("jspwiki.security", "jaas"));
        this.m_readOnlyProfiles = TextUtil.isPositive(props.getProperty(PROP_READ_ONLY_PROFILES));
        this.addWikiEventListener(engine.getContentManager());
        JSONRPCManager.registerGlobalObject("users", new JSONUserModule(this), new AllPermission(null));
    }

    /*
     * Exception decompiling
     */
    public final UserDatabase getUserDatabase() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final UserProfile getUserProfile(WikiSession session) {
        UserProfile profile = this.m_profiles.get(session);
        boolean newProfile = profile == null;
        Principal user = null;
        if (session.isAuthenticated()) {
            user = session.getUserPrincipal();
            try {
                profile = this.getUserDatabase().find(user.getName());
                newProfile = false;
            }
            catch (NoSuchPrincipalException noSuchPrincipalException) {
                // empty catch block
            }
        }
        if (newProfile) {
            profile = this.getUserDatabase().newProfile();
            if (user != null) {
                profile.setLoginName(user.getName());
            }
            if (!profile.isNew()) {
                throw new IllegalStateException("New profile should be marked 'new'. Check your UserProfile implementation.");
            }
        }
        this.m_profiles.put(session, profile);
        return profile;
    }

    public boolean isReadOnly() {
        return this.m_readOnlyProfiles;
    }

    public final void setUserProfile(WikiSession session, UserProfile profile) throws DuplicateUserException, WikiException {
        UserProfile otherProfile;
        WikiPermission p = new WikiPermission(this.m_engine.getApplicationName(), "editProfile");
        if (!this.m_engine.getAuthorizationManager().checkPermission(session, p)) {
            throw new WikiSecurityException("You are not allowed to save wiki profiles.");
        }
        boolean newProfile = profile.isNew();
        UserProfile oldProfile = this.getUserProfile(session);
        boolean nameChanged = oldProfile == null || oldProfile.getFullname() == null ? false : !oldProfile.getFullname().equals(profile.getFullname()) || !oldProfile.getLoginName().equals(profile.getLoginName());
        try {
            otherProfile = this.getUserDatabase().findByLoginName(profile.getLoginName());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("The login name '" + profile.getLoginName() + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByFullName(profile.getFullname());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("The full name '" + profile.getFullname() + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (newProfile && oldProfile != null && oldProfile.isNew()) {
            WorkflowBuilder builder = WorkflowBuilder.getBuilder(this.m_engine);
            Principal submitter = session.getUserPrincipal();
            SaveUserProfileTask completionTask = new SaveUserProfileTask(this.m_engine);
            boolean hasEmail = profile.getEmail() != null;
            Fact[] facts = new Fact[hasEmail ? 4 : 3];
            facts[0] = new Fact(PREFS_FULL_NAME, (Serializable)((Object)profile.getFullname()));
            facts[1] = new Fact(PREFS_LOGIN_NAME, (Serializable)((Object)profile.getLoginName()));
            facts[2] = new Fact(FACT_SUBMITTER, (Serializable)((Object)submitter.getName()));
            if (hasEmail) {
                facts[3] = new Fact(PREFS_EMAIL, (Serializable)((Object)profile.getEmail()));
            }
            Workflow workflow = builder.buildApprovalWorkflow(submitter, SAVE_APPROVER, null, SAVE_DECISION_MESSAGE_KEY, facts, completionTask, null);
            workflow.setAttribute(SAVED_PROFILE, profile);
            this.m_engine.getWorkflowManager().start(workflow);
            boolean approvalRequired = workflow.getCurrentStep() instanceof Decision;
            if (approvalRequired) {
                throw new DecisionRequiredException("This profile must be approved before it becomes active");
            }
            try {
                AuthenticationManager mgr = this.m_engine.getAuthenticationManager();
                if (newProfile && !mgr.isContainerAuthenticated()) {
                    mgr.login(session, null, profile.getLoginName(), profile.getPassword());
                }
            }
            catch (LoginException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
            this.fireEvent(53, session, profile);
        } else {
            if (nameChanged && oldProfile != null && !oldProfile.getLoginName().equals(profile.getLoginName())) {
                this.getUserDatabase().rename(oldProfile.getLoginName(), profile.getLoginName());
            }
            this.getUserDatabase().save(profile);
            if (nameChanged) {
                UserProfile[] profiles = new UserProfile[]{oldProfile, profile};
                this.fireEvent(54, session, profiles);
            } else {
                this.fireEvent(53, session, profile);
            }
        }
    }

    public final UserProfile parseProfile(WikiContext context) {
        UserProfile profile = this.getUserProfile(context.getWikiSession());
        HttpServletRequest request = context.getHttpRequest();
        String loginName = request.getParameter(PARAM_LOGINNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String fullname = request.getParameter(PARAM_FULLNAME);
        String email = request.getParameter(PARAM_EMAIL);
        loginName = InputValidator.isBlank(loginName) ? null : loginName;
        password = InputValidator.isBlank(password) ? null : password;
        fullname = InputValidator.isBlank(fullname) ? null : fullname;
        String string = email = InputValidator.isBlank(email) ? null : email;
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && context.getWikiSession().isAuthenticated()) {
            loginName = context.getWikiSession().getLoginPrincipal().getName();
        }
        profile.setLoginName(loginName);
        profile.setEmail(email);
        profile.setFullname(fullname);
        profile.setPassword(password);
        return profile;
    }

    public final void validateProfile(WikiContext context, UserProfile profile) {
        Object[] args2;
        UserProfile otherProfile;
        boolean isNew = profile.isNew();
        WikiSession session = context.getWikiSession();
        InputValidator validator = new InputValidator(SESSION_MESSAGES, context);
        ResourceBundle rb = context.getBundle("CoreResources");
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && !context.getWikiSession().isAuthenticated()) {
            session.addMessage(SESSION_MESSAGES, rb.getString("security.error.createprofilebeforelogin"));
        }
        validator.validateNotNull(profile.getLoginName(), rb.getString("security.user.loginname"));
        validator.validateNotNull(profile.getFullname(), rb.getString("security.user.fullname"));
        validator.validate(profile.getEmail(), rb.getString("security.user.email"), 1);
        if (!this.m_engine.getAuthenticationManager().isContainerAuthenticated()) {
            String password = profile.getPassword();
            if (password == null) {
                if (isNew) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.blankpassword"));
                }
            } else {
                String password2;
                HttpServletRequest request = context.getHttpRequest();
                String string = password2 = request == null ? null : request.getParameter("password2");
                if (!password.equals(password2)) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.passwordnomatch"));
                }
            }
        }
        String fullName = profile.getFullname();
        String loginName = profile.getLoginName();
        try {
            otherProfile = this.getUserDatabase().find(fullName);
            if (otherProfile != null && !profile.equals(otherProfile) && !fullName.equals(otherProfile.getFullname())) {
                args2 = new Object[]{fullName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalfullname"), args2));
            }
        }
        catch (NoSuchPrincipalException args2) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().find(loginName);
            if (otherProfile != null && !profile.equals(otherProfile) && !loginName.equals(otherProfile.getLoginName())) {
                args2 = new Object[]{loginName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalloginname"), args2));
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
    }

    public Principal[] listWikiNames() throws WikiSecurityException {
        return this.getUserDatabase().getWikiNames();
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, WikiSession session, Object profile) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent((Object)session, type, profile, new Serializable[0]));
        }
    }

    public static class DummyUserDatabase
    extends AbstractUserDatabase {
        public void commit() throws WikiSecurityException {
        }

        public void deleteByLoginName(String loginName) throws WikiSecurityException {
        }

        public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public Principal[] getWikiNames() throws WikiSecurityException {
            return new Principal[0];
        }

        public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        }

        public void rename(String loginName, String newName) throws DuplicateUserException, WikiSecurityException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public void save(UserProfile profile) throws WikiSecurityException {
        }
    }

    public static final class JSONUserModule
    implements RPCCallable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private volatile UserManager m_manager;

        public JSONUserModule(UserManager mgr) {
            this.m_manager = mgr;
        }

        public UserProfile getUserInfo(String uid) throws NoSuchPrincipalException {
            if (this.m_manager != null) {
                UserProfile prof = this.m_manager.getUserDatabase().find(uid);
                return prof;
            }
            throw new IllegalStateException("The manager is offline.");
        }
    }

    public static class SaveUserProfileTask
    extends Task {
        private static final long serialVersionUID = 6994297086560480285L;
        private final UserDatabase m_db;
        private final WikiEngine m_engine;

        public SaveUserProfileTask(WikiEngine engine) {
            super(UserManager.SAVE_TASK_MESSAGE_KEY);
            this.m_engine = engine;
            this.m_db = engine.getUserManager().getUserDatabase();
        }

        public Outcome execute() throws WikiException {
            UserProfile profile = (UserProfile)this.getWorkflow().getAttribute(UserManager.SAVED_PROFILE);
            this.m_db.save(profile);
            if (profile.getEmail() != null) {
                try {
                    String app = this.m_engine.getApplicationName();
                    String to = profile.getEmail();
                    String subject = "Welcome to " + app;
                    String content = "Congratulations! Your new profile on " + app + " has been created. Your profile details are as follows: \n\n" + "Login name: " + profile.getLoginName() + "\n" + "Your name : " + profile.getFullname() + "\n" + "E-mail    : " + profile.getEmail() + "\n\n" + "If you forget your password, you can reset it at " + this.m_engine.getURL(WikiContext.LOGIN, null, null, true);
                    MailUtil.sendMessage(this.m_engine, to, subject, content);
                }
                catch (AddressException app) {
                }
                catch (MessagingException e) {
                    log.error("Could not send registration confirmation e-mail. Is the e-mail server running?", new Object[0]);
                }
            }
            return Outcome.STEP_COMPLETE;
        }
    }
}

