/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.rpc.json.JSONRPCManager;
import org.apache.wiki.ui.TemplateManager;

public class SessionMonitor
implements HttpSessionListener,
ServletContextListener,
WikiEventListener {
    private static Logger log;
    private static Map<WikiEngine, SessionMonitor> c_monitors;
    private final Map<String, WikiSession> m_sessions = new WeakHashMap<String, WikiSession>();
    private WikiEngine m_engine;
    private final PrincipalComparator m_comparator = new PrincipalComparator();

    static {
        if (System.getSecurityManager() != null) {
            throw new InternalWikiException("FATAL ERROR: An active Java Security Manager was found, JSPWiki will not work !!");
        }
        log = LoggerFactory.getLogger(SessionMonitor.class);
        c_monitors = new HashMap<WikiEngine, SessionMonitor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SessionMonitor getInstance(WikiEngine engine) {
        SessionMonitor monitor;
        if (engine == null) {
            throw new IllegalArgumentException("Engine cannot be null.");
        }
        Map<WikiEngine, SessionMonitor> map = c_monitors;
        synchronized (map) {
            monitor = c_monitors.get(engine);
            if (monitor == null) {
                monitor = new SessionMonitor(engine);
                engine.addWikiEventListener(monitor);
                c_monitors.put(engine, monitor);
            }
        }
        return monitor;
    }

    public SessionMonitor() {
    }

    private SessionMonitor(WikiEngine engine) {
        this.m_engine = engine;
    }

    private WikiSession findSession(HttpSession session) {
        WikiSession wikiSession = null;
        String sid = session == null ? "(null)" : session.getId();
        WikiSession storedSession = this.m_sessions.get(sid);
        if (storedSession != null) {
            if (log.isDebugEnabled()) {
                log.debug("Looking up WikiSession for session ID=" + sid + "... found it", new Object[0]);
            }
            wikiSession = storedSession;
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && event.getType() == 1) {
            log.info("SessionMonitor detected wiki engine shutdown: flushing session cache and killing self.", new Object[0]);
            Map<Object, WikiEventListener> map = this.m_sessions;
            synchronized (map) {
                this.m_sessions.clear();
            }
            map = c_monitors;
            synchronized (map) {
                c_monitors.remove(this.m_engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WikiSession find(HttpSession session) {
        String sid;
        WikiSession wikiSession = this.findSession(session);
        String string = sid = session == null ? "(null)" : session.getId();
        if (wikiSession == null) {
            if (log.isDebugEnabled()) {
                log.debug("Looking up WikiSession for session ID=" + sid + "... not found. Creating guestSession()", new Object[0]);
            }
            wikiSession = WikiSession.guestSession(this.m_engine);
            Map<String, WikiSession> map = this.m_sessions;
            synchronized (map) {
                this.m_sessions.put(sid, wikiSession);
            }
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null.");
        }
        Map<String, WikiSession> map = this.m_sessions;
        synchronized (map) {
            this.m_sessions.remove(session.getId());
        }
    }

    public final int sessions() {
        return this.userPrincipals().length;
    }

    public final Principal[] userPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (WikiSession session : this.m_sessions.values()) {
            principals.add(session.getUserPrincipal());
        }
        Principal[] p = principals.toArray(new Principal[principals.size()]);
        Arrays.sort(p, this.m_comparator);
        return p;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, WikiSession session) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent((Object)this, type, principal, session, new Serializable[0]));
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        ServletContext servletContext = session.getServletContext();
        session.setAttribute("templates", TemplateManager.getResourceResolver(servletContext));
        JSONRPCManager.sessionCreated(session);
        WikiEngine engine = WikiEngine.getInstance(servletContext, null);
        if (this.m_engine == null) {
            this.m_engine = engine;
        }
        session.setAttribute("wikiEngine", (Object)engine);
        session.setAttribute("wikiSession", (Object)this.find(session));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        for (SessionMonitor monitor : c_monitors.values()) {
            WikiSession storedSession = monitor.findSession(session);
            monitor.remove(session);
            log.debug("Removed session " + session.getId() + ".", new Object[0]);
            if (storedSession == null) continue;
            this.fireEvent(45, storedSession.getLoginPrincipal(), storedSession);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        WikiEngine engine = WikiEngine.getInstance(sce.getServletContext(), null);
        if (engine != null) {
            engine.shutdown();
        }
    }
}

