/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupDatabase;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebContainerAuthorizer;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.freshcookies.security.policy.PolicyReader;
import org.jdom.JDOMException;

public final class SecurityVerifier {
    private static final long serialVersionUID = -3859563355089169941L;
    private WikiEngine m_engine;
    private boolean m_isSecurityPolicyConfigured = false;
    private Principal[] m_policyPrincipals = new Principal[0];
    private WikiSession m_session;
    public static final String ERROR = "Error.";
    public static final String WARNING = "Warning.";
    public static final String INFO = "Info.";
    public static final String ERROR_POLICY = "Error.Policy";
    public static final String WARNING_POLICY = "Warning.Policy";
    public static final String INFO_POLICY = "Info.Policy";
    public static final String ERROR_JAAS = "Error.Jaas";
    public static final String WARNING_JAAS = "Warning.Jaas";
    public static final String ERROR_ROLES = "Error.Roles";
    public static final String INFO_ROLES = "Info.Roles";
    public static final String ERROR_DB = "Error.UserDatabase";
    public static final String WARNING_DB = "Warning.UserDatabase";
    public static final String INFO_DB = "Info.UserDatabase";
    public static final String ERROR_GROUPS = "Error.GroupDatabase";
    public static final String WARNING_GROUPS = "Warning.GroupDatabase";
    public static final String INFO_GROUPS = "Info.GroupDatabase";
    public static final String INFO_JAAS = "Info.Jaas";
    private static final String[] CONTAINER_ACTIONS = new String[]{"View pages", "Comment on existing pages", "Edit pages", "Upload attachments", "Create a new group", "Rename an existing page", "Delete pages"};
    private static final String[] CONTAINER_JSPS = new String[]{"/Wiki.jsp", "/Comment.jsp", "/Edit.jsp", "/Upload.jsp", "/NewGroup.jsp", "/Rename.jsp", "/Delete.jsp"};
    private static final String BG_GREEN = "bgcolor=\"#c0ffc0\"";
    private static final String BG_RED = "bgcolor=\"#ffc0c0\"";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityVerifier.class.getName());

    public SecurityVerifier(WikiEngine engine, WikiSession session) {
        this.m_engine = engine;
        this.m_session = session;
        this.m_session.clearMessages();
        this.verifyJaas();
        this.verifyPolicy();
        try {
            this.verifyPolicyAndContainerRoles();
        }
        catch (WikiException e) {
            this.m_session.addMessage(ERROR_ROLES, e.getMessage());
        }
        this.verifyGroupDatabase();
        this.verifyUserDatabase();
    }

    public final Principal[] policyPrincipals() {
        return this.m_policyPrincipals;
    }

    public final String getPolicyRoleTable() {
        Permission permission;
        int n;
        int n2;
        String[] stringArray;
        Principal role;
        int n3;
        Principal[] principalArray;
        int n4;
        Object[] objectArray;
        Principal[] roles = this.m_policyPrincipals;
        String wiki = this.m_engine.getApplicationName();
        String[] pages = new String[]{"Main", "Index", "GroupTest", "GroupAdmin"};
        String[] pageActions = new String[]{"view", "edit", "modify", "rename", "delete"};
        String[] groups = new String[]{"Admin", "TestGroup", "Foo"};
        String[] stringArray2 = new String[5];
        stringArray2[0] = "view";
        stringArray2[1] = "edit";
        stringArray2[4] = "delete";
        String[] groupActions = stringArray2;
        String colWidth = pageActions.length > 0 && roles.length > 0 ? String.valueOf(String.valueOf(67.0f / (float)(pageActions.length * roles.length))) + "%" : "67%";
        StringBuilder s = new StringBuilder();
        s.append("<table class=\"wikitable\" border=\"1\">\n");
        s.append("  <colgroup span=\"1\" width=\"33%\"/>\n");
        s.append("  <colgroup span=\"" + pageActions.length * roles.length + "\" width=\"" + colWidth + "\" align=\"center\"/>\n");
        s.append("  <tr>\n");
        s.append("    <th rowspan=\"2\" valign=\"bottom\">Permission</th>\n");
        int i = 0;
        while (i < roles.length) {
            s.append("    <th colspan=\"" + pageActions.length + "\" title=\"" + roles[i].getClass().getName() + "\">" + roles[i].getName() + "</th>\n");
            ++i;
        }
        s.append("  </tr>\n");
        s.append("  <tr>\n");
        i = 0;
        while (i < roles.length) {
            objectArray = pageActions;
            int n5 = pageActions.length;
            n4 = 0;
            while (n4 < n5) {
                String pageAction = objectArray[n4];
                String action = pageAction.substring(0, 1);
                s.append("    <th title=\"" + pageAction + "\">" + action + "</th>\n");
                ++n4;
            }
            ++i;
        }
        s.append("  </tr>\n");
        String[] stringArray3 = pages;
        n4 = pages.length;
        int pageAction = 0;
        while (pageAction < n4) {
            String page = stringArray3[pageAction];
            s.append("  <tr>\n");
            s.append("    <td>PagePermission \"" + wiki + ":" + page + "\"</td>\n");
            principalArray = roles;
            n3 = roles.length;
            int action = 0;
            while (action < n3) {
                role = principalArray[action];
                stringArray = pageActions;
                n2 = pageActions.length;
                n = 0;
                while (n < n2) {
                    String pageAction2 = stringArray[n];
                    permission = PermissionFactory.getPagePermission(String.valueOf(wiki) + ":" + page, pageAction2);
                    s.append(this.printPermissionTest(permission, role, 1));
                    ++n;
                }
                ++action;
            }
            s.append("  </tr>\n");
            ++pageAction;
        }
        stringArray3 = groups;
        n4 = groups.length;
        pageAction = 0;
        while (pageAction < n4) {
            String group = stringArray3[pageAction];
            s.append("  <tr>\n");
            s.append("    <td>GroupPermission \"" + wiki + ":" + group + "\"</td>\n");
            principalArray = roles;
            n3 = roles.length;
            int action = 0;
            while (action < n3) {
                role = principalArray[action];
                stringArray = groupActions;
                n2 = groupActions.length;
                n = 0;
                while (n < n2) {
                    String groupAction = stringArray[n];
                    permission = null;
                    if (groupAction != null) {
                        permission = new GroupPermission(String.valueOf(wiki) + ":" + group, groupAction);
                    }
                    s.append(this.printPermissionTest(permission, role, 1));
                    ++n;
                }
                ++action;
            }
            s.append("  </tr>\n");
            ++pageAction;
        }
        String[] wikiPerms = new String[]{"createGroups", "createPages", "login", "editPreferences", "editProfile"};
        objectArray = wikiPerms;
        int n6 = wikiPerms.length;
        n4 = 0;
        while (n4 < n6) {
            String wikiPerm = objectArray[n4];
            s.append("  <tr>\n");
            s.append("    <td>WikiPermission \"" + wiki + "\",\"" + wikiPerm + "\"</td>\n");
            Principal[] principalArray2 = roles;
            int n7 = roles.length;
            n3 = 0;
            while (n3 < n7) {
                Principal role2 = principalArray2[n3];
                WikiPermission permission2 = new WikiPermission(wiki, wikiPerm);
                s.append(this.printPermissionTest(permission2, role2, pageActions.length));
                ++n3;
            }
            s.append("  </tr>\n");
            ++n4;
        }
        s.append("  <tr>\n");
        s.append("    <td>AllPermission \"" + wiki + "\"</td>\n");
        objectArray = roles;
        n6 = roles.length;
        n4 = 0;
        while (n4 < n6) {
            Object role3 = objectArray[n4];
            AllPermission permission3 = new AllPermission(wiki);
            s.append(this.printPermissionTest(permission3, (Principal)role3, pageActions.length));
            ++n4;
        }
        s.append("  </tr>\n");
        s.append("</table>");
        return s.toString();
    }

    private final String printPermissionTest(Permission permission, Principal principal, int cols) {
        StringBuilder s = new StringBuilder();
        if (permission == null) {
            s.append("    <td colspan=\"" + cols + "\" align=\"center\" title=\"N/A\">");
            s.append("&nbsp;</td>\n");
        } else {
            boolean allowed = this.verifyStaticPermission(principal, permission);
            s.append("    <td colspan=\"" + cols + "\" align=\"center\" title=\"");
            s.append(allowed ? "ALLOW: " : "DENY: ");
            s.append(permission.getClass().getName());
            s.append(" &quot;");
            s.append(permission.getName());
            s.append("&quot;");
            if (permission.getName() != null) {
                s.append(",&quot;");
                s.append(permission.getActions());
                s.append("&quot;");
            }
            s.append(" ");
            s.append(principal.getClass().getName());
            s.append(" &quot;");
            s.append(principal.getName());
            s.append("&quot;");
            s.append("\"");
            s.append(allowed ? "bgcolor=\"#c0ffc0\">" : "bgcolor=\"#ffc0c0\">");
            s.append("&nbsp;</td>\n");
        }
        return s.toString();
    }

    public final String getContainerRoleTable() throws WikiException {
        AuthorizationManager authorizationManager = this.m_engine.getAuthorizationManager();
        Authorizer authorizer = authorizationManager.getAuthorizer();
        if (!(authorizer instanceof WebContainerAuthorizer)) {
            throw new IllegalStateException("Authorizer should be WebContainerAuthorizer");
        }
        StringBuilder s = new StringBuilder();
        Principal[] roles = authorizer.getRoles();
        s.append("<table class=\"wikitable\" border=\"1\">\n");
        s.append("<thead>\n");
        s.append("  <tr>\n");
        s.append("    <th rowspan=\"2\">Action</th>\n");
        s.append("    <th rowspan=\"2\">Page</th>\n");
        s.append("    <th colspan=\"" + roles.length + 1 + "\">Roles</th>\n");
        s.append("  </tr>\n");
        s.append("  <tr>\n");
        s.append("    <th>Anonymous</th>\n");
        Principal[] principalArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Principal role = principalArray[n2];
            s.append("    <th>" + role.getName() + "</th>\n");
            ++n2;
        }
        s.append("</tr>\n");
        s.append("</thead>\n");
        s.append("<tbody>\n");
        try {
            WebContainerAuthorizer wca = (WebContainerAuthorizer)authorizer;
            int i = 0;
            while (i < CONTAINER_ACTIONS.length) {
                String action = CONTAINER_ACTIONS[i];
                String jsp = CONTAINER_JSPS[i];
                boolean allowsAnonymous = !wca.isConstrained(jsp, Role.ALL);
                s.append("  <tr>\n");
                s.append("    <td>" + action + "</td>\n");
                s.append("    <td>" + jsp + "</td>\n");
                s.append("    <td title=\"");
                s.append(allowsAnonymous ? "ALLOW: " : "DENY: ");
                s.append(jsp);
                s.append(" Anonymous");
                s.append("\"");
                s.append(allowsAnonymous ? "bgcolor=\"#c0ffc0\">" : "bgcolor=\"#ffc0c0\">");
                s.append("&nbsp;</td>\n");
                Principal[] principalArray2 = roles;
                int n3 = roles.length;
                int n4 = 0;
                while (n4 < n3) {
                    Principal role = principalArray2[n4];
                    boolean allowed = allowsAnonymous || wca.isConstrained(jsp, (Role)role);
                    s.append("    <td title=\"");
                    s.append(allowed ? "ALLOW: " : "DENY: ");
                    s.append(jsp);
                    s.append(" ");
                    s.append(role.getClass().getName());
                    s.append(" &quot;");
                    s.append(role.getName());
                    s.append("&quot;");
                    s.append("\"");
                    s.append(allowed ? "bgcolor=\"#c0ffc0\">" : "bgcolor=\"#ffc0c0\">");
                    s.append("&nbsp;</td>\n");
                    ++n4;
                }
                s.append("  </tr>\n");
                ++i;
            }
        }
        catch (JDOMException e) {
            LOG.error("Malformed XML in web.xml", e);
            throw new InternalWikiException(String.valueOf(((Object)((Object)e)).getClass().getName()) + ": " + e.getMessage());
        }
        s.append("</tbody>\n");
        s.append("</table>\n");
        return s.toString();
    }

    public final boolean isSecurityPolicyConfigured() {
        return this.m_isSecurityPolicyConfigured;
    }

    public final Principal[] getWebContainerRoles() throws WikiException {
        Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
        if (authorizer instanceof WebContainerAuthorizer) {
            return ((WebContainerAuthorizer)authorizer).getRoles();
        }
        return new Principal[0];
    }

    protected final void verifyPolicyAndContainerRoles() throws WikiException {
        Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
        Object[] containerRoles = authorizer.getRoles();
        boolean missing = false;
        Principal[] principalArray = this.m_policyPrincipals;
        int n = this.m_policyPrincipals.length;
        int n2 = 0;
        while (n2 < n) {
            Principal principal = principalArray[n2];
            if (principal instanceof Role) {
                Role role = (Role)principal;
                boolean isContainerRole = ArrayUtils.contains((Object[])containerRoles, (Object)role);
                if (!Role.isBuiltInRole(role) && !isContainerRole) {
                    this.m_session.addMessage(ERROR_ROLES, "Role '" + role.getName() + "' is defined in security policy but not in web.xml.");
                    missing = true;
                }
            }
            ++n2;
        }
        if (!missing) {
            this.m_session.addMessage(INFO_ROLES, "Every non-standard role defined in the security policy was also found in web.xml.");
        }
    }

    protected final void verifyGroupDatabase() {
        GroupManager mgr = this.m_engine.getGroupManager();
        GroupDatabase db = null;
        try {
            db = this.m_engine.getGroupManager().getGroupDatabase();
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_GROUPS, "Could not retrieve GroupManager: " + e.getMessage());
        }
        if (mgr == null || db == null) {
            if (mgr == null) {
                this.m_session.addMessage(ERROR_GROUPS, "GroupManager is null; JSPWiki could not initialize it. Check the error logs.");
            }
            if (db == null) {
                this.m_session.addMessage(ERROR_GROUPS, "GroupDatabase is null; JSPWiki could not initialize it. Check the error logs.");
            }
            return;
        }
        this.m_session.addMessage(INFO_GROUPS, "GroupDatabase is of type '" + db.getClass().getName() + "'. It appears to be initialized properly.");
        int oldGroupCount = 0;
        try {
            Group[] groups = db.groups();
            oldGroupCount = groups.length;
            this.m_session.addMessage(INFO_GROUPS, "The group database contains " + oldGroupCount + " groups.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_GROUPS, "Could not obtain a list of current groups: " + e.getMessage());
            return;
        }
        String name = "TestGroup" + String.valueOf(System.currentTimeMillis());
        Group group = null;
        try {
            group = mgr.parseGroup(name, "", true);
            WikiPrincipal user = new WikiPrincipal("TestUser");
            group.add(user);
            db.save(group, new WikiPrincipal("SecurityVerifier"));
            if (db.groups().length == oldGroupCount) {
                this.m_session.addMessage(ERROR_GROUPS, "Could not add a test group to the database.");
                return;
            }
            this.m_session.addMessage(INFO_GROUPS, "The group database allows new groups to be created, as it should.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_GROUPS, "Could not add a group to the database: " + e.getMessage());
            return;
        }
        try {
            db.delete(group);
            if (db.groups().length != oldGroupCount) {
                this.m_session.addMessage(ERROR_GROUPS, "Could not delete a test group from the database.");
                return;
            }
            this.m_session.addMessage(INFO_GROUPS, "The group database allows groups to be deleted, as it should.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_GROUPS, "Could not delete a test group from the database: " + e.getMessage());
            return;
        }
        this.m_session.addMessage(INFO_GROUPS, "The group database configuration looks fine.");
    }

    protected final void verifyJaas() {
        String jaasClass;
        AuthorizationManager authMgr = this.m_engine.getAuthorizationManager();
        if (!authMgr.isJAASAuthorized()) {
            this.m_session.addMessage(ERROR_JAAS, "JSPWiki's JAAS-based authentication and authorization system is turned off (your jspwiki.properties file contains the setting 'jspwiki.security = container'. This setting disables authorization checks and is meant for testing and troubleshooting only. The test results on this page will not be reliable as a result. You should set this to 'jaas' so that security works properly.");
        }
        if ((jaasClass = this.m_engine.getWikiProperties().getProperty("jspwiki.loginModule.class")) == null || jaasClass.length() == 0) {
            this.m_session.addMessage(ERROR_JAAS, "The value of the 'jspwiki.loginModule.class' property was null or blank. This is a fatal error. This value should be set to a valid LoginModule implementation on the classpath.");
            return;
        }
        Class<?> c = null;
        try {
            this.m_session.addMessage(INFO_JAAS, "The property 'jspwiki.loginModule.class' specified the class '" + jaasClass + ".'");
            c = Class.forName(jaasClass);
        }
        catch (ClassNotFoundException e) {
            this.m_session.addMessage(ERROR_JAAS, "We could not find the the class '" + jaasClass + "' on the " + "classpath. This is fatal error.");
        }
        if (LoginModule.class.isAssignableFrom(c)) {
            this.m_session.addMessage(INFO_JAAS, "We found the the class '" + jaasClass + "' on the " + "classpath, and it is a LoginModule implementation. Good!");
        } else {
            this.m_session.addMessage(ERROR_JAAS, "We found the the class '" + jaasClass + "' on the " + "classpath, but it does not seem to be LoginModule implementation! This is fatal error.");
        }
    }

    protected final File getFileFromProperty(String property) {
        String propertyValue;
        block8: {
            propertyValue = null;
            try {
                propertyValue = System.getProperty(property);
                if (propertyValue != null) break block8;
                this.m_session.addMessage(ERROR + property, "The system property '" + property + "' is null.");
                return null;
            }
            catch (SecurityException e) {
                this.m_session.addMessage(ERROR + property, "We could not read system property '" + property + "'. This is probably because you are running with a security manager.");
                return null;
            }
        }
        if (propertyValue.startsWith("=")) {
            propertyValue = propertyValue.substring(1);
        }
        try {
            URL url;
            File file;
            this.m_session.addMessage(INFO + property, "The system property '" + property + "' is set to: " + propertyValue + ".");
            if (!propertyValue.startsWith("file:")) {
                propertyValue = "file:" + propertyValue;
            }
            if ((file = new File((url = new URL(propertyValue)).getPath())).exists()) {
                this.m_session.addMessage(INFO + property, "File '" + propertyValue + "' exists in the filesystem.");
                return file;
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        this.m_session.addMessage(ERROR + property, "File '" + propertyValue + "' doesn't seem to exist. This might be a problem.");
        return null;
    }

    protected final void verifyPolicy() {
        URL policyURL = AuthenticationManager.findConfigFile(this.m_engine, "jspwiki.policy");
        String path = policyURL.getPath();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        File policyFile = new File(path);
        try {
            ProtectionDomain[] domains;
            PolicyReader policy = new PolicyReader(policyFile);
            this.m_session.addMessage(INFO_POLICY, "The security policy '" + policy.getFile() + "' exists.");
            policy.read();
            List errors = policy.getMessages();
            if (errors.size() > 0) {
                for (Exception e : errors) {
                    this.m_session.addMessage(ERROR_POLICY, e.getMessage());
                }
            } else {
                this.m_session.addMessage(INFO_POLICY, "The security policy looks fine.");
                this.m_isSecurityPolicyConfigured = true;
            }
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            principals.add(Role.ALL);
            principals.add(Role.ANONYMOUS);
            principals.add(Role.ASSERTED);
            principals.add(Role.AUTHENTICATED);
            ProtectionDomain[] protectionDomainArray = domains = policy.getProtectionDomains();
            int n = domains.length;
            int n2 = 0;
            while (n2 < n) {
                ProtectionDomain domain = protectionDomainArray[n2];
                Principal[] principalArray = domain.getPrincipals();
                int n3 = principalArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Principal principal = principalArray[n4];
                    principals.add(principal);
                    ++n4;
                }
                ++n2;
            }
            this.m_policyPrincipals = principals.toArray(new Principal[principals.size()]);
        }
        catch (IOException e) {
            this.m_session.addMessage(ERROR_POLICY, e.getMessage());
        }
    }

    protected final boolean verifyStaticPermission(Principal principal, final Permission permission) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        boolean allowedByGlobalPolicy = (Boolean)Subject.doAsPrivileged(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    AccessController.checkPermission(permission);
                    return Boolean.TRUE;
                }
                catch (AccessControlException e) {
                    return Boolean.FALSE;
                }
            }
        }, null);
        if (allowedByGlobalPolicy) {
            return true;
        }
        Principal[] principals = new Principal[]{principal};
        return this.m_engine.getAuthorizationManager().allowedByLocalPolicy(principals, permission);
    }

    protected final void verifyUserDatabase() {
        UserDatabase db = this.m_engine.getUserManager().getUserDatabase();
        if (db == null) {
            this.m_session.addMessage(ERROR_DB, "UserDatabase is null; JSPWiki could not initialize it. Check the error logs.");
            return;
        }
        if (db instanceof UserManager.DummyUserDatabase) {
            this.m_session.addMessage(ERROR_DB, "UserDatabase is DummyUserDatabase; JSPWiki may not have been able to initialize the database you supplied in jspwiki.properties, or you left the 'jspwiki.userdatabase' property blank. Check the error logs.");
        }
        this.m_session.addMessage(INFO_DB, "UserDatabase is of type '" + db.getClass().getName() + "'. It appears to be initialized properly.");
        int oldUserCount = 0;
        try {
            Principal[] users = db.getWikiNames();
            oldUserCount = users.length;
            this.m_session.addMessage(INFO_DB, "The user database contains " + oldUserCount + " users.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_DB, "Could not obtain a list of current users: " + e.getMessage());
            return;
        }
        String loginName = "TestUser" + String.valueOf(System.currentTimeMillis());
        try {
            UserProfile profile = db.newProfile();
            profile.setEmail("testuser@testville.com");
            profile.setLoginName(loginName);
            profile.setFullname("FullName" + loginName);
            profile.setPassword("password");
            db.save(profile);
            if (db.getWikiNames().length == oldUserCount) {
                this.m_session.addMessage(ERROR_DB, "Could not add a test user to the database.");
                return;
            }
            this.m_session.addMessage(INFO_DB, "The user database allows new users to be created, as it should.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_DB, "Could not add a test user to the database: " + e.getMessage());
            return;
        }
        try {
            db.deleteByLoginName(loginName);
            if (db.getWikiNames().length != oldUserCount) {
                this.m_session.addMessage(ERROR_DB, "Could not delete a test user from the database.");
                return;
            }
            this.m_session.addMessage(INFO_DB, "The user database allows users to be deleted, as it should.");
        }
        catch (WikiSecurityException e) {
            this.m_session.addMessage(ERROR_DB, "Could not delete a test user to the database: " + e.getMessage());
            return;
        }
        this.m_session.addMessage(INFO_DB, "The user database configuration looks fine.");
    }
}

