/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.wiki.util.TextUtil;
import org.freshcookies.security.Keychain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConfig {
    public static final String KEYCHAIN_LDAP_BIND_PASSWORD = "ldap.bindPassword";
    public static final String PROPERTY_AUTHENTICATION = "ldap.authentication";
    public static final String PROPERTY_BIND_USER = "ldap.bindUser";
    public static final String PROPERTY_CONFIG = "ldap.config";
    public static final String PROPERTY_CONNECTION_URL = "ldap.connectionURL";
    public static final String PROPERTY_IS_IN_ROLE_FILTER = "ldap.isInRoleFilter";
    public static final String PROPERTY_LOGIN_ID_PATTERN = "ldap.loginIdPattern";
    public static final String PROPERTY_ROLE_BASE = "ldap.roleBase";
    public static final String PROPERTY_SSL = "ldap.ssl";
    public static final String PROPERTY_USER_BASE = "ldap.userBase";
    public static final String PROPERTY_USER_LOGIN_NAME_ATTRIBUTE = "ldap.user.loginName";
    public static final String PROPERTY_USER_OBJECT_CLASS = "ldap.user.objectClass";
    public static final String PROPERTY_USER_FILTER = "ldap.userFilter";
    private static final Map<Default, LdapConfig> CONFIGS = new HashMap<Default, LdapConfig>();
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();
    public final String connectionUrl;
    public final String roleBase;
    public final String isInRoleFilter;
    public final String bindUser;
    public final String ssl;
    public final String authentication;
    public final String userBase;
    public final String loginIdPattern;
    public final String userFilter;
    public final String userLoginNameAttribute;
    public final String userObjectClass;
    private final Set<String> m_configured = new HashSet<String>();
    private final Keychain m_keychain;
    private final Map<String, String> m_userDns = new HashMap<String, String>();

    static {
        SEARCH_CONTROLS.setSearchScope(2);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(PROPERTY_IS_IN_ROLE_FILTER, "(&(&(objectClass=group)(cn={0}))(member={1}))");
        options.put(PROPERTY_LOGIN_ID_PATTERN, "{0}");
        options.put(PROPERTY_USER_LOGIN_NAME_ATTRIBUTE, "sAMAccountName");
        options.put(PROPERTY_USER_OBJECT_CLASS, "person");
        options.put(PROPERTY_USER_FILTER, "(&(objectClass=person)(sAMAccountName={0}))");
        LdapConfig config = new LdapConfig(null, options, new String[0]);
        CONFIGS.put(Default.ACTIVE_DIRECTORY, config);
        options = new HashMap();
        options.put(PROPERTY_IS_IN_ROLE_FILTER, "(&(&(objectClass=groupOfUniqueNames)(cn={0}))(uniqueMember={1}))");
        options.put(PROPERTY_LOGIN_ID_PATTERN, "uid={0},{1}");
        options.put(PROPERTY_USER_LOGIN_NAME_ATTRIBUTE, "uid");
        options.put(PROPERTY_USER_OBJECT_CLASS, "inetOrgPerson");
        options.put(PROPERTY_USER_FILTER, "(&(objectClass=inetOrgPerson)(uid={0}))");
        config = new LdapConfig(null, options, new String[0]);
        CONFIGS.put(Default.OPEN_LDAP, config);
    }

    public static String escapeFilterString(String dn) {
        StringBuilder s = new StringBuilder();
        char[] cArray = dn.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '=': {
                    s.append('\\');
                    s.append('3');
                    s.append('d');
                    break;
                }
                case '(': {
                    s.append('\\');
                    s.append('2');
                    s.append('8');
                    break;
                }
                case ')': {
                    s.append('\\');
                    s.append('2');
                    s.append('9');
                    break;
                }
                case '&': {
                    s.append('\\');
                    s.append('2');
                    s.append('6');
                    break;
                }
                case '|': {
                    s.append('\\');
                    s.append('7');
                    s.append('c');
                    break;
                }
                case '>': {
                    s.append('\\');
                    s.append('3');
                    s.append('e');
                    break;
                }
                case '<': {
                    s.append('\\');
                    s.append('3');
                    s.append('c');
                    break;
                }
                case '~': {
                    s.append('\\');
                    s.append('7');
                    s.append('e');
                    break;
                }
                case '*': {
                    s.append('\\');
                    s.append('2');
                    s.append('a');
                    break;
                }
                case '/': {
                    s.append('\\');
                    s.append('2');
                    s.append('f');
                    break;
                }
                case '\\': {
                    s.append('\\');
                    s.append('5');
                    s.append('c');
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++n2;
        }
        return s.toString();
    }

    public static String getFullName(Attributes attributes) throws NamingException {
        boolean hasCommonName = attributes.get("cn") != null;
        boolean hasSurname = attributes.get("sn") != null;
        boolean hasGivenName = attributes.get("givenName") != null;
        String fullName = null;
        if (hasGivenName && hasSurname) {
            fullName = attributes.get("givenName").get(0) + " " + attributes.get("sn").get(0);
        } else if (hasCommonName) {
            fullName = attributes.get("cn").get(0).toString();
        } else {
            throw new NamingException("User did not have a givenName+sn or cn.");
        }
        return fullName;
    }

    public static LdapConfig getInstance(Keychain keychain, Map<? extends Object, ? extends Object> props, String[] requiredProperties) {
        return new LdapConfig(keychain, props, requiredProperties);
    }

    private LdapConfig(Keychain keychain, Map<? extends Object, ? extends Object> props, String[] requiredProperties) {
        String defaultIsInRoleFilter = null;
        String defaultLoginIdPattern = "{0}";
        String defaultUserLoginNameAttribute = "uid";
        String defaultUserObjectClass = "inetOrgPerson";
        String defaultUserFilter = null;
        String config = (String)props.get(PROPERTY_CONFIG);
        if (config != null) {
            try {
                Default configEnum = Default.valueOf(config);
                LdapConfig defaults = CONFIGS.get((Object)configEnum);
                defaultIsInRoleFilter = defaults.isInRoleFilter;
                defaultLoginIdPattern = defaults.loginIdPattern;
                defaultUserLoginNameAttribute = defaults.userLoginNameAttribute;
                defaultUserObjectClass = defaults.userObjectClass;
                defaultUserFilter = defaults.userFilter;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("'" + config + "' is not a valid config value for " + PROPERTY_CONFIG + ".", e);
            }
        }
        this.connectionUrl = this.getProperty(props, PROPERTY_CONNECTION_URL, null);
        this.m_keychain = keychain;
        this.bindUser = this.getProperty(props, PROPERTY_BIND_USER, null);
        this.userBase = this.getProperty(props, PROPERTY_USER_BASE, null);
        this.userFilter = this.getProperty(props, PROPERTY_USER_FILTER, defaultUserFilter);
        this.roleBase = this.getProperty(props, PROPERTY_ROLE_BASE, null);
        this.isInRoleFilter = this.getProperty(props, PROPERTY_IS_IN_ROLE_FILTER, defaultIsInRoleFilter);
        String parsedSsl = this.getProperty(props, PROPERTY_SSL, null);
        this.ssl = parsedSsl != null && TextUtil.isPositive(parsedSsl) ? "ssl" : "none";
        String parsedAuthentication = this.getProperty(props, PROPERTY_AUTHENTICATION, null);
        this.authentication = parsedAuthentication == null ? ("ssl".equals(this.ssl) ? "simple" : "DIGEST-MD5") : parsedAuthentication;
        String parsedLoginIdPattern = this.getProperty(props, PROPERTY_LOGIN_ID_PATTERN, defaultLoginIdPattern);
        this.loginIdPattern = this.userBase == null ? parsedLoginIdPattern : parsedLoginIdPattern.replace("{1}", this.userBase);
        this.userObjectClass = this.getProperty(props, PROPERTY_USER_OBJECT_CLASS, defaultUserObjectClass);
        this.userLoginNameAttribute = this.getProperty(props, PROPERTY_USER_LOGIN_NAME_ATTRIBUTE, defaultUserLoginNameAttribute);
        String[] stringArray = requiredProperties;
        int n = requiredProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (!this.m_configured.contains(property)) {
                throw new IllegalArgumentException("Property " + property + " is required!");
            }
            ++n2;
        }
    }

    public String getUserDn(String loginName) throws NamingException {
        return this.getUserDn(loginName, null);
    }

    public synchronized String getUserDn(String loginName, DirContext ctx) throws NamingException {
        String dn = this.m_userDns.get(loginName);
        if (dn == null) {
            NamingEnumeration<SearchResult> users;
            String userFinder = this.userFilter.replace("{0}", LdapConfig.escapeFilterString(loginName));
            Hashtable<String, String> env = this.newJndiEnvironment();
            if (ctx == null) {
                ctx = new InitialLdapContext(env, null);
            }
            if ((users = ctx.search(this.userBase, userFinder, SEARCH_CONTROLS)).hasMore()) {
                dn = users.next().getNameInNamespace();
                this.m_userDns.put(loginName, dn);
            }
        }
        return dn;
    }

    public Hashtable<String, String> newJndiEnvironment() throws NamingException {
        String username = this.bindUser;
        String password = null;
        if (username != null) {
            try {
                password = this.getBindPassword();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new NamingException("Could not build JNDI environment: " + e.getMessage());
            }
        }
        return this.newJndiEnvironment(username, password);
    }

    public Hashtable<String, String> newJndiEnvironment(String username, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (this.loginIdPattern != null && username != null) {
            username = this.loginIdPattern.replace("{0}", username);
        }
        env.put("java.naming.provider.url", this.connectionUrl);
        if (username != null) {
            env.put("java.naming.security.principal", username);
        }
        if (password != null) {
            env.put("java.naming.security.credentials", password);
        }
        env.put("java.naming.security.protocol", this.ssl);
        env.put("java.naming.security.authentication", this.authentication);
        env.put("java.naming.referral", "follow");
        return env;
    }

    private String getBindPassword() throws KeyStoreException {
        if (this.m_keychain == null) {
            throw new KeyStoreException("LdapConfig was initialized without a keychain!");
        }
        KeyStore.Entry password = this.m_keychain.getEntry(KEYCHAIN_LDAP_BIND_PASSWORD);
        if (password != null && password instanceof Keychain.Password) {
            return ((Keychain.Password)password).getPassword();
        }
        return null;
    }

    private String getProperty(Map<? extends Object, ? extends Object> props, String property, String defaultValue) {
        String shortProperty = property;
        String value = (String)props.get(property);
        if (value != null && value.length() > 0) {
            this.m_configured.add(shortProperty);
            return props.get(property).toString().trim();
        }
        if (defaultValue != null) {
            this.m_configured.add(shortProperty);
        }
        return defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Default {
        ACTIVE_DIRECTORY,
        OPEN_LDAP;

    }
}

