/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.ClassUtil;
import org.freshcookies.security.policy.LocalPolicy;
import org.freshcookies.security.policy.PolicyException;

public final class AuthorizationManager {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationManager.class);
    public static final String DEFAULT_AUTHORIZER = "org.apache.wiki.auth.authorize.WebContainerAuthorizer";
    protected static final String POLICY = "jspwiki.policy.file";
    protected static final String DEFAULT_POLICY = "jspwiki.policy";
    public static final String PROP_AUTHORIZER = "jspwiki.authorizer";
    private Authorizer m_authorizer = null;
    private Map<Principal, ProtectionDomain> m_cachedPds = new WeakHashMap<Principal, ProtectionDomain>();
    private WikiEngine m_engine = null;
    private LocalPolicy m_localPolicy = null;
    private boolean m_useJAAS = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean checkPermission(WikiSession session, Permission permission) {
        if (!this.m_useJAAS) {
            return permission != null && !"login".equals(permission.getActions());
        }
        if (session == null || permission == null) {
            this.fireEvent(52, null, permission);
            return false;
        }
        Principal user = session.getLoginPrincipal();
        if (this.hasRoleOrPrincipal(session, Role.SUPERUSER)) {
            this.fireEvent(51, user, permission);
            return true;
        }
        AllPermission allPermission = new AllPermission(this.m_engine.getApplicationName());
        boolean hasAllPermission = this.checkStaticPermission(session, allPermission);
        if (hasAllPermission) {
            this.fireEvent(51, user, permission);
            return true;
        }
        boolean hasPolicyPermission = this.checkStaticPermission(session, permission);
        if (!hasPolicyPermission) {
            this.fireEvent(52, user, permission);
            return false;
        }
        if (!(permission instanceof PagePermission)) {
            this.fireEvent(51, user, permission);
            return true;
        }
        try {
            String pageName = ((PagePermission)permission).getPage();
            WikiPage page = this.m_engine.getPage(pageName);
            Acl acl = this.m_engine.getAclManager().getPermissions(page);
            if (page == null || acl == null || acl.isEmpty()) {
                this.fireEvent(51, user, permission);
                return true;
            }
            Principal[] aclPrincipals = acl.findPrincipals(permission);
            log.debug("Checking ACL entries...", new Object[0]);
            log.debug("Acl for this page is: " + acl, new Object[0]);
            log.debug("Checking for principal: " + String.valueOf(aclPrincipals), new Object[0]);
            log.debug("Permission: " + permission, new Object[0]);
            Principal[] principalArray = aclPrincipals;
            int n = aclPrincipals.length;
            int n2 = 0;
            while (n2 < n) {
                Principal aclPrincipal = principalArray[n2];
                if (aclPrincipal instanceof UnresolvedPrincipal) {
                    AclEntry aclEntry = acl.getEntry(aclPrincipal);
                    aclPrincipal = this.resolvePrincipal(aclPrincipal.getName());
                    if (aclEntry != null && !(aclPrincipal instanceof UnresolvedPrincipal)) {
                        aclEntry.setPrincipal(aclPrincipal);
                    }
                }
                if (this.hasRoleOrPrincipal(session, aclPrincipal)) {
                    this.fireEvent(51, user, permission);
                    return true;
                }
                ++n2;
            }
        }
        catch (WikiSecurityException e) {
            this.fireEvent(52, user, permission);
            return false;
        }
        catch (PageNotFoundException e) {
            this.fireEvent(51, user, permission);
            return true;
        }
        catch (ProviderException e) {
            log.info("Unable to get ACL on page", e, new Object[0]);
        }
        this.fireEvent(52, user, permission);
        return false;
    }

    public final boolean isUserInRole(WikiSession session, Principal principal) {
        if (session == null || principal == null || AuthenticationManager.isUserPrincipal(principal)) {
            return false;
        }
        if (principal instanceof Role && Role.isBuiltInRole((Role)principal)) {
            return session.hasPrincipal(principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isRolePrincipal(principal)) {
            return session.hasPrincipal(principal);
        }
        return false;
    }

    public final Authorizer getAuthorizer() throws WikiSecurityException {
        if (this.m_authorizer != null) {
            return this.m_authorizer;
        }
        throw new WikiSecurityException("Authorizer did not initialize properly. Check the logs.");
    }

    protected boolean hasRoleOrPrincipal(WikiSession session, Principal principal) {
        if (session == null || principal == null) {
            return false;
        }
        if (AuthenticationManager.isRolePrincipal(principal)) {
            return this.isUserInRole(session, principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isUserPrincipal(principal)) {
            Principal[] userPrincipals;
            String principalName = principal.getName();
            Principal[] principalArray = userPrincipals = session.getPrincipals();
            int n = userPrincipals.length;
            int n2 = 0;
            while (n2 < n) {
                Principal userPrincipal = principalArray[n2];
                if (userPrincipal.getName().equals(principalName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public final void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_useJAAS = "jaas".equals(properties.getProperty("jspwiki.security", "jaas"));
        if (!this.m_useJAAS) {
            return;
        }
        this.m_authorizer = this.getAuthorizerImplementation(properties);
        this.m_authorizer.initialize(engine, properties);
        try {
            String policyFileName = properties.getProperty(POLICY, DEFAULT_POLICY);
            URL policyURL = AuthenticationManager.findConfigFile(engine, policyFileName);
            if (policyURL == null) {
                StringBuilder sb = new StringBuilder("JSPWiki was unable to initialize the ");
                sb.append("default security policy (WEB-INF/jspwiki.policy) file. ");
                sb.append("Please ensure that the jspwiki.policy file exists in the default location. ");
                sb.append("This file should exist regardless of the existance of a global policy file. ");
                sb.append("The global policy file is identified by the java.security.policy variable. ");
                WikiSecurityException wse = new WikiSecurityException(sb.toString());
                log.error(sb.toString(), wse);
                throw wse;
            }
            File policyFile = new File(policyURL.getPath());
            log.info("We found security policy URL: " + policyURL + " and transformed it to file " + policyFile.getAbsolutePath(), new Object[0]);
            this.m_localPolicy = new LocalPolicy(policyFile, engine.getContentEncoding());
            this.m_localPolicy.refresh();
            log.info("Initialized default security policy: " + policyFile.getAbsolutePath(), new Object[0]);
        }
        catch (PolicyException e) {
            log.error("Could not initialize local security policy: " + e.getMessage(), new Object[0]);
            throw new WikiException("Could not initialize local security policy: " + e.getMessage(), e);
        }
    }

    protected boolean isJAASAuthorized() {
        return this.m_useJAAS;
    }

    private final Authorizer getAuthorizerImplementation(Properties props) throws WikiException {
        String authClassName = props.getProperty(PROP_AUTHORIZER, DEFAULT_AUTHORIZER);
        return (Authorizer)this.locateImplementation(authClassName);
    }

    private final Object locateImplementation(String clazz) throws WikiException {
        if (clazz != null) {
            try {
                Class<?> authClass = ClassUtil.findClass("org.apache.wiki.auth.authorize", clazz);
                Object impl = authClass.newInstance();
                return impl;
            }
            catch (ClassNotFoundException e) {
                log.error("Authorizer " + clazz + " cannot be found", e);
                throw new WikiException("Authorizer " + clazz + " cannot be found", e);
            }
            catch (InstantiationException e) {
                log.error("Authorizer " + clazz + " cannot be created", e);
                throw new WikiException("Authorizer " + clazz + " cannot be created", e);
            }
            catch (IllegalAccessException e) {
                log.error("You are not allowed to access this authorizer class", e);
                throw new WikiException("You are not allowed to access this authorizer class", e);
            }
        }
        throw new NoRequiredPropertyException("Unable to find a jspwiki.authorizer entry in the properties.", PROP_AUTHORIZER);
    }

    protected boolean allowedByLocalPolicy(Principal[] principals, Permission permission) {
        Principal[] principalArray = principals;
        int n = principals.length;
        int n2 = 0;
        while (n2 < n) {
            Principal principal = principalArray[n2];
            ProtectionDomain pd = this.m_cachedPds.get(principal);
            if (pd == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                CodeSource cs = new CodeSource(null, null);
                pd = new ProtectionDomain(cs, null, cl, new Principal[]{principal});
                this.m_cachedPds.put(principal, pd);
            }
            if (this.m_localPolicy.implies(pd, permission)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final boolean checkStaticPermission(final WikiSession session, final Permission permission) {
        if (!this.m_useJAAS) {
            return true;
        }
        Boolean allowed = (Boolean)WikiSession.doPrivileged(session, new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    AccessController.checkPermission(permission);
                    return Boolean.TRUE;
                }
                catch (AccessControlException accessControlException) {
                    if (AuthorizationManager.this.allowedByLocalPolicy(session.getRoles(), permission) || AuthorizationManager.this.allowedByLocalPolicy(session.getPrincipals(), permission)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        });
        return allowed;
    }

    public final Principal resolvePrincipal(String name) {
        if (!this.m_useJAAS) {
            return new UnresolvedPrincipal(name);
        }
        Role role = new Role(name);
        if (Role.isBuiltInRole(role)) {
            return role;
        }
        Principal principal = this.m_authorizer.findRole(name);
        if (principal != null) {
            return principal;
        }
        principal = this.m_engine.getGroupManager().findRole(name);
        if (principal != null) {
            return principal;
        }
        Principal[] principals = null;
        UserProfile profile = null;
        UserDatabase db = this.m_engine.getUserManager().getUserDatabase();
        try {
            profile = db.find(name);
            principals = db.getPrincipals(profile.getLoginName());
            int i = 0;
            while (i < principals.length) {
                principal = principals[i];
                if (principal.getName().equals(name)) {
                    return principal;
                }
                ++i;
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        return new UnresolvedPrincipal(name);
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal user, Object permission) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent((Object)this, type, user, permission, new Serializable[0]));
        }
    }
}

