/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.apache.wiki.auth.authorize.WebContainerAuthorizer;
import org.apache.wiki.auth.login.AnonymousLoginModule;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.login.CookieAuthenticationLoginModule;
import org.apache.wiki.auth.login.UserDatabaseLoginModule;
import org.apache.wiki.auth.login.WebContainerCallbackHandler;
import org.apache.wiki.auth.login.WebContainerLoginModule;
import org.apache.wiki.auth.login.WikiCallbackHandler;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.CryptoUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.TimedCounterList;
import org.freshcookies.security.Keychain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationManager {
    private static final long LASTLOGINS_CLEANUP_TIME = 600000L;
    private static final long MAX_LOGIN_DELAY = 20000L;
    public static final String COOKIE_MODULE = CookieAssertionLoginModule.class.getName();
    public static final String COOKIE_AUTHENTICATION_MODULE = CookieAuthenticationLoginModule.class.getName();
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    public static final String PROP_ALLOW_COOKIE_AUTH = "jspwiki.cookieAuthentication";
    public static final String PROP_SECURITY = "jspwiki.security";
    public static final String SECURITY_OFF = "off";
    public static final String SECURITY_JAAS = "jaas";
    public static final String PROP_LOGIN_THROTTLING = "jspwiki.login.throttling";
    protected static final Logger log = LoggerFactory.getLogger(AuthenticationManager.class);
    protected static final String PREFIX_LOGIN_MODULE_OPTIONS = "jspwiki.loginModule.options.";
    protected static final String PROP_ALLOW_COOKIE_ASSERTIONS = "jspwiki.cookieAssertions";
    public static final String PROP_LOGIN_MODULE = "jspwiki.loginModule.class";
    protected static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    protected Class<? extends LoginModule> m_loginModuleClass = UserDatabaseLoginModule.class;
    protected Map<String, String> m_loginModuleOptions = new HashMap<String, String>();
    protected static final String SECURITY_CONTAINER = "container";
    protected static final String SUPERUSER = "su";
    private static final String DEFAULT_LOGIN_MODULE = "org.apache.wiki.auth.login.UserDatabaseLoginModule";
    private static final Set<Principal> NO_PRINCIPALS = new HashSet<Principal>();
    private boolean m_allowsCookieAssertions = true;
    private boolean m_throttleLogins = true;
    private boolean m_allowsCookieAuthentication = false;
    private WikiEngine m_engine = null;
    private boolean m_storeIPAddress = true;
    private boolean m_useJAAS = true;
    private TimedCounterList<String> m_lastLoginAttempts = new TimedCounterList();
    protected static final String DEFAULT_KEYCHAIN_PATH = "keychain";
    public static final String PROP_KEYCHAIN_PASSWORD = "jspwiki.keychainPassword";
    public static final String PROP_KEYCHAIN_PATH = "jspwiki.keychainPath";
    private Keychain m_keychain = null;
    private String m_keychainPath = null;

    public Keychain getKeychain() {
        return this.m_keychain;
    }

    public final void initialize(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_keychain = new Keychain();
        String path = props.getProperty(PROP_KEYCHAIN_PATH);
        String string = path = path == null || path.trim().length() == 0 ? null : path.trim();
        if (path == null) {
            path = "WEB-INF/keychain";
        } else {
            File filePath = new File(path);
            if (filePath.getParent() == null) {
                path = "WEB-INF/" + path;
            }
        }
        this.m_keychainPath = path;
        String password = props.getProperty(PROP_KEYCHAIN_PASSWORD);
        if (password != null) {
            this.initKeychain(password);
        }
        this.m_storeIPAddress = TextUtil.getBooleanProperty(props, PROP_STOREIPADDRESS, this.m_storeIPAddress);
        this.m_useJAAS = SECURITY_JAAS.equals(props.getProperty(PROP_SECURITY, SECURITY_JAAS));
        this.m_allowsCookieAssertions = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_ASSERTIONS, true);
        this.m_allowsCookieAuthentication = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_AUTH, false);
        this.m_throttleLogins = TextUtil.getBooleanProperty(props, PROP_LOGIN_THROTTLING, true);
        String loginModuleClassName = TextUtil.getStringProperty(props, PROP_LOGIN_MODULE, DEFAULT_LOGIN_MODULE);
        try {
            this.m_loginModuleClass = Class.forName(loginModuleClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new WikiException("Could not instantiate LoginModule class.", e);
        }
        this.initLoginModuleOptions(props);
    }

    public final boolean isContainerAuthenticated() {
        if (!this.m_useJAAS) {
            return true;
        }
        try {
            Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
            if (authorizer instanceof WebContainerAuthorizer) {
                return ((WebContainerAuthorizer)authorizer).isContainerAuthorized();
            }
        }
        catch (WikiException wikiException) {
            // empty catch block
        }
        return false;
    }

    public final boolean login(HttpServletRequest request) throws WikiSecurityException {
        Set<Principal> principals;
        HttpSession httpSession = request.getSession();
        WikiSession session = SessionMonitor.getInstance(this.m_engine).find(httpSession);
        AuthenticationManager authenticationMgr = this.m_engine.getAuthenticationManager();
        AuthorizationManager authorizationMgr = this.m_engine.getAuthorizationManager();
        WebContainerCallbackHandler handler = null;
        Map<String, String> options = EMPTY_MAP;
        if (!session.isAuthenticated()) {
            handler = new WebContainerCallbackHandler(this.m_engine, request);
            principals = null;
            try {
                principals = authenticationMgr.doJAASLogin(WebContainerLoginModule.class, handler, options);
            }
            catch (LoginException loginException) {
                // empty catch block
            }
            try {
                if ((principals == null || principals.size() == 0) && authenticationMgr.allowsCookieAuthentication()) {
                    principals = authenticationMgr.doJAASLogin(CookieAuthenticationLoginModule.class, handler, options);
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
            if (principals != null && principals.size() > 0) {
                this.fireEvent(40, this.getLoginPrincipal(principals), session);
                for (Principal principal : principals) {
                    this.fireEvent(35, principal, session);
                }
                this.injectAuthorizerRoles(session, authorizationMgr.getAuthorizer(), request);
            }
        }
        if (!session.isAuthenticated() && authenticationMgr.allowsCookieAssertions()) {
            principals = null;
            try {
                principals = authenticationMgr.doJAASLogin(CookieAssertionLoginModule.class, handler, options);
                if (principals != null && principals.size() > 0) {
                    this.fireEvent(32, this.getLoginPrincipal(principals), session);
                }
            }
            catch (LoginException principal) {
                // empty catch block
            }
        }
        if (session.isAnonymous()) {
            principals = null;
            try {
                principals = authenticationMgr.doJAASLogin(AnonymousLoginModule.class, handler, options);
                if (principals != null && principals.size() > 0) {
                    this.fireEvent(31, this.getLoginPrincipal(principals), session);
                    return true;
                }
            }
            catch (LoginException e) {
                log.error("Anonymous login failed! Something must be wrong with the configuration...", new Object[0]);
            }
        }
        return false;
    }

    public final boolean login(WikiSession session, String username, String password) throws WikiSecurityException, LoginException {
        return this.login(session, null, username, password);
    }

    public final boolean login(WikiSession session, HttpServletRequest request, String username, String password) throws WikiSecurityException, LoginException {
        String passwordHash;
        if (session == null) {
            log.error("No wiki session provided, cannot log in.", new Object[0]);
            return false;
        }
        if (this.m_throttleLogins) {
            this.delayLogin(username);
        }
        boolean isSu = false;
        if (SUPERUSER.equals(username) && (passwordHash = this.m_engine.getWikiProperties().getProperty("admin.passwordHash")) != null && passwordHash.length() > 0) {
            try {
                isSu = CryptoUtil.verifySaltedPassword(password.getBytes(), passwordHash);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (isSu) {
            this.fireEvent(40, new WikiPrincipal(SUPERUSER, "loginName"), session);
            this.fireEvent(35, Role.SUPERUSER, session);
            return true;
        }
        WikiCallbackHandler handler = new WikiCallbackHandler(this.m_engine, request, username, password);
        Set<Principal> principals = this.doJAASLogin(this.m_loginModuleClass, handler, this.m_loginModuleOptions);
        if (principals.size() > 0) {
            this.fireEvent(40, this.getLoginPrincipal(principals), session);
            for (Principal principal : principals) {
                this.fireEvent(35, principal, session);
            }
            this.injectAuthorizerRoles(session, this.m_engine.getAuthorizationManager().getAuthorizer(), null);
            return true;
        }
        return false;
    }

    private void delayLogin(String username) {
        try {
            this.m_lastLoginAttempts.cleanup(600000L);
            int count = this.m_lastLoginAttempts.count(username);
            long delay = Math.min((long)(1 << count), 20000L);
            log.debug("Sleeping for " + delay + " ms to allow login.", new Object[0]);
            Thread.sleep(delay);
            this.m_lastLoginAttempts.add(username);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void logout(HttpServletRequest request) {
        String sid;
        if (request == null) {
            log.error("No HTTP reqest provided; cannot log out.", new Object[0]);
            return;
        }
        HttpSession session = request.getSession();
        String string = sid = session == null ? "(null)" : session.getId();
        if (log.isDebugEnabled()) {
            log.debug("Invalidating WikiSession for session ID=" + sid, new Object[0]);
        }
        WikiSession wikiSession = WikiSession.getWikiSession(this.m_engine, request);
        Principal originalPrincipal = wikiSession.getLoginPrincipal();
        wikiSession.invalidate();
        WikiSession.removeWikiSession(this.m_engine, request);
        if (session != null) {
            session.invalidate();
        }
        this.fireEvent(44, originalPrincipal, null);
    }

    public final boolean allowsCookieAssertions() {
        return this.m_allowsCookieAssertions;
    }

    public final boolean allowsCookieAuthentication() {
        return this.m_allowsCookieAuthentication;
    }

    public boolean isCookieAuthenticated() {
        return this.m_allowsCookieAuthentication;
    }

    public static final boolean isRolePrincipal(Principal principal) {
        return principal instanceof Role || principal instanceof GroupPrincipal;
    }

    public static final boolean isUserPrincipal(Principal principal) {
        return !AuthenticationManager.isRolePrincipal(principal);
    }

    public void unlockKeychain(String password) throws WikiSecurityException {
        if (!this.m_keychain.isLoaded()) {
            this.initKeychain(password);
        }
        if (!this.m_keychain.isLoaded()) {
            throw new WikiSecurityException("Wrong password.");
        }
    }

    protected Set<Principal> doJAASLogin(Class<? extends LoginModule> clazz, CallbackHandler handler, Map<String, String> options) throws WikiSecurityException, LoginException {
        LoginModule loginModule = null;
        try {
            loginModule = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Subject subject = new Subject();
        loginModule.initialize(subject, handler, EMPTY_MAP, options);
        boolean loginSucceeded = false;
        boolean commitSucceeded = false;
        loginSucceeded = loginModule.login();
        if (loginSucceeded) {
            commitSucceeded = loginModule.commit();
        }
        if (loginSucceeded && commitSucceeded) {
            return subject.getPrincipals();
        }
        return NO_PRINCIPALS;
    }

    protected static final URL findConfigFile(WikiEngine engine, String name) {
        File defaultFile = null;
        if (engine.getRootPath() != null) {
            defaultFile = new File(String.valueOf(engine.getRootPath()) + "/WEB-INF/" + name);
        }
        if (defaultFile != null && defaultFile.exists()) {
            try {
                return defaultFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.warn("Malformed URL: " + e.getMessage(), new Object[0]);
            }
        }
        URL path = null;
        if (engine.getServletContext() != null) {
            try {
                InputStream is = engine.getServletContext().getResourceAsStream("/WEB-INF/" + name);
                File tmpFile = File.createTempFile("temp." + name, "");
                tmpFile.deleteOnExit();
                FileOutputStream os = new FileOutputStream(tmpFile);
                byte[] buff = new byte[1024];
                while (is.read(buff) != -1) {
                    ((OutputStream)os).write(buff);
                }
                ((OutputStream)os).close();
                path = tmpFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.error("Your code is b0rked.  You are a bad person.", new Object[0]);
            }
            catch (IOException e) {
                log.error("failed to load security policy from " + name + ",stacktrace follows", e);
            }
        }
        return path;
    }

    protected Principal getLoginPrincipal(Set<Principal> principals) {
        for (Principal principal : principals) {
            if (!(principal instanceof WikiPrincipal) || ((WikiPrincipal)principal).getType() != "loginName") continue;
            return principal;
        }
        for (Principal principal : principals) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            return principal;
        }
        return null;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent((Object)this, type, principal, target, new Serializable[0]));
        }
    }

    private void initLoginModuleOptions(Properties props) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            String optionKey;
            String propName = key.toString();
            if (!propName.startsWith(PREFIX_LOGIN_MODULE_OPTIONS) || (optionKey = propName.substring(PREFIX_LOGIN_MODULE_OPTIONS.length()).trim()).length() <= 0) continue;
            String optionValue = props.getProperty(propName);
            if (this.m_loginModuleOptions.containsKey(optionKey)) {
                throw new IllegalArgumentException("JAAS LoginModule key " + propName + " cannot be specified twice!");
            }
            options.put(optionKey, optionValue);
        }
        this.m_loginModuleOptions = Collections.unmodifiableMap(options);
    }

    /*
     * Unable to fully structure code
     */
    private final void injectAuthorizerRoles(WikiSession session, Authorizer authorizer, HttpServletRequest request) {
        try {
            var8_7 = roles = authorizer.findRoles(session);
            var7_9 = roles.length;
            var6_11 = 0;
            while (var6_11 < var7_9) {
                role = var8_7[var6_11];
                this.fireEvent(35, role, session);
                if (AuthenticationManager.log.isDebugEnabled()) {
                    AuthenticationManager.log.debug("Added authorizer role " + role.getName() + ".", new Object[0]);
                }
                ++var6_11;
            }
            return;
        }
        catch (WikiSecurityException roles) {
            var7_10 = authorizer.getRoles();
            var6_12 = var7_10.length;
            var5_14 = 0;
            ** while (var5_14 < var6_12)
        }
lbl-1000:
        // 1 sources

        {
            role = var7_10[var5_14];
            if (authorizer.isUserInRole(session, role)) {
                this.fireEvent(35, role, session);
                if (AuthenticationManager.log.isDebugEnabled()) {
                    AuthenticationManager.log.debug("Added authorizer role " + role.getName() + ".", new Object[0]);
                }
            } else if (request != null && authorizer instanceof WebAuthorizer && (wa = (WebAuthorizer)authorizer).isUserInRole(request, role)) {
                this.fireEvent(35, role, session);
                if (AuthenticationManager.log.isDebugEnabled()) {
                    AuthenticationManager.log.debug("Added container role " + role.getName() + ".", new Object[0]);
                }
            }
            ++var5_14;
            continue;
        }
lbl30:
        // 1 sources

    }

    private void initKeychain(String password) throws WikiSecurityException {
        InputStream stream = null;
        log.debug("Loading keychain from path " + this.m_keychainPath, new Object[0]);
        if (this.m_engine.getServletContext() == null) {
            ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
            stream = cl.getResourceAsStream(this.m_keychainPath);
        } else {
            stream = this.m_engine.getServletContext().getResourceAsStream("/" + this.m_keychainPath);
        }
        if (stream == null) {
            File file = new File(this.m_keychainPath);
            try {
                if (file.isAbsolute() && file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stream == null) {
            throw new WikiSecurityException("Unable to find keychain " + this.m_keychainPath + ".");
        }
        char[] passwordChars = password == null ? null : password.toCharArray();
        try {
            this.m_keychain.load(stream, passwordChars);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            log.info("Keychain could not be unlocked; wrong password or PIN.", new Object[0]);
        }
    }
}

