/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.filters.RedirectException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.progress.ProgressItem;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.util.TextUtil;

public class AttachmentServlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 3257282552187531320L;
    private WikiEngine m_engine;
    static Logger log = LoggerFactory.getLogger(AttachmentServlet.class.getName());
    private static final String HDR_VERSION = "version";
    protected static final long DEFAULT_EXPIRY = 86400000L;
    private String m_tmpDir;
    private int m_maxSize = Integer.MAX_VALUE;
    private String[] m_allowedPatterns;
    private String[] m_forbiddenPatterns;

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = WikiEngine.getInstance(config);
        Properties props = this.m_engine.getWikiProperties();
        this.m_tmpDir = String.valueOf(this.m_engine.getWorkDir()) + File.separator + "attach-tmp";
        this.m_maxSize = TextUtil.getIntegerProperty(props, "jspwiki.attachment.maxsize", Integer.MAX_VALUE);
        String allowed = TextUtil.getStringProperty(props, "jspwiki.attachment.allowed", null);
        this.m_allowedPatterns = allowed != null && allowed.length() > 0 ? allowed.toLowerCase().split("\\s") : new String[0];
        String forbidden = TextUtil.getStringProperty(props, "jspwiki.attachment.forbidden", null);
        this.m_forbiddenPatterns = forbidden != null && forbidden.length() > 0 ? forbidden.toLowerCase().split("\\s") : new String[0];
        File f = new File(this.m_tmpDir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            log.error("A file already exists where the temporary dir is supposed to be: " + this.m_tmpDir + ".  Please remove it.", new Object[0]);
        }
        log.debug("UploadServlet initialized. Using " + this.m_tmpDir + " for temporary storage.", new Object[0]);
    }

    private boolean isTypeAllowed(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        name = name.toLowerCase();
        int i = 0;
        while (i < this.m_forbiddenPatterns.length) {
            if (name.endsWith(this.m_forbiddenPatterns[i]) && this.m_forbiddenPatterns[i].length() > 0) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_allowedPatterns.length) {
            if (name.endsWith(this.m_allowedPatterns[i]) && this.m_allowedPatterns[i].length() > 0) {
                return true;
            }
            ++i;
        }
        return this.m_allowedPatterns.length == 0;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Allow", "GET, PUT, POST, OPTIONS");
        res.setStatus(200);
    }

    /*
     * Exception decompiling
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 64[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getMimeType(WikiContext ctx, String fileName) {
        ServletContext s;
        String mimetype = null;
        HttpServletRequest req = ctx.getHttpRequest();
        if (req != null && (s = req.getSession().getServletContext()) != null) {
            mimetype = s.getMimeType(fileName.toLowerCase());
        }
        if (mimetype == null) {
            mimetype = "application/binary";
        }
        return mimetype;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String nextPage = this.upload(req);
            req.getSession().removeAttribute("msg");
            res.sendRedirect(nextPage);
        }
        catch (RedirectException e) {
            WikiSession session = WikiSession.getWikiSession(this.m_engine, req);
            session.addMessage(e.getMessage());
            req.getSession().setAttribute("msg", (Object)e.getMessage());
            res.sendRedirect(e.getRedirect());
        }
    }

    private String validateNextPage(String nextPage, String errorPage) {
        if (nextPage.indexOf("://") != -1 && !nextPage.startsWith(this.m_engine.getBaseURL())) {
            log.warn("Detected phishing attempt by redirecting to an unsecure location: " + nextPage, new Object[0]);
            nextPage = errorPage;
        }
        return nextPage;
    }

    protected String upload(HttpServletRequest req) throws RedirectException, IOException {
        String errorPage;
        String msg = "";
        String attName = "(unknown)";
        String nextPage = errorPage = this.m_engine.getURL(WikiContext.ERROR, "", null, false);
        String progressId = req.getParameter("progressid");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new RedirectException("Not a file upload", errorPage);
        }
        try {
            try {
                WikiActionBeanContext context;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                try {
                    context = this.m_engine.getWikiContextFactory().newContext(req, null, WikiContext.ATTACH);
                }
                catch (WikiException e) {
                    throw new IOException(e.getMessage());
                }
                UploadListener pl = new UploadListener();
                this.m_engine.getProgressManager().startProgress(pl, progressId);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setHeaderEncoding("UTF-8");
                if (!context.hasAdminPermissions()) {
                    upload.setFileSizeMax((long)this.m_maxSize);
                }
                upload.setProgressListener((ProgressListener)pl);
                List items = upload.parseRequest(req);
                String wikipage = null;
                String changeNote = null;
                FileItem actualFile = null;
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (item.getFieldName().equals("page")) {
                            wikipage = item.getString("UTF-8");
                            int x = wikipage.indexOf("/");
                            if (x == -1) continue;
                            wikipage = wikipage.substring(0, x);
                            continue;
                        }
                        if (item.getFieldName().equals("changenote")) {
                            changeNote = item.getString("UTF-8");
                            continue;
                        }
                        if (!item.getFieldName().equals("nextpage")) continue;
                        nextPage = this.validateNextPage(item.getString("UTF-8"), errorPage);
                        continue;
                    }
                    actualFile = item;
                }
                if (actualFile == null) {
                    throw new RedirectException("Broken file upload", errorPage);
                }
                String filename = actualFile.getName();
                long fileSize = actualFile.getSize();
                InputStream in = actualFile.getInputStream();
                try {
                    this.executeUpload(context, in, filename, nextPage, wikipage, changeNote, fileSize);
                }
                finally {
                    in.close();
                }
            }
            catch (ProviderException e) {
                msg = "Upload failed because the provider failed: " + e.getMessage();
                log.warn(String.valueOf(msg) + " (attachment: " + attName + ")", e, new Object[0]);
                throw new IOException(msg);
            }
            catch (IOException e) {
                msg = "Upload failure: " + e.getMessage();
                log.warn(String.valueOf(msg) + " (attachment: " + attName + ")", e, new Object[0]);
                throw e;
            }
            catch (FileUploadException e) {
                msg = "Upload failure: " + e.getMessage();
                log.warn(String.valueOf(msg) + " (attachment: " + attName + ")", e, new Object[0]);
                throw new IOException(msg);
            }
        }
        finally {
            this.m_engine.getProgressManager().stopProgress(progressId);
        }
        return nextPage;
    }

    protected boolean executeUpload(WikiContext context, InputStream data, String filename, String errorPage, String parentPage, String changenote, long contentLength) throws RedirectException, IOException, ProviderException {
        Attachment att;
        boolean created = false;
        try {
            filename = AttachmentManager.cleanFileName(filename);
        }
        catch (WikiException e) {
            throw new RedirectException(context.getBundle("CoreResources").getString(e.getMessage()), errorPage);
        }
        if (!context.hasAdminPermissions()) {
            if (contentLength > (long)this.m_maxSize) {
                throw new RedirectException("File exceeds maximum size (" + this.m_maxSize + " bytes)", errorPage);
            }
            if (!this.isTypeAllowed(filename)) {
                throw new RedirectException("Files of this type may not be uploaded to this wiki", errorPage);
            }
        }
        Principal user = context.getCurrentUser();
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        log.debug("file=" + filename, new Object[0]);
        if (data == null) {
            log.error("File could not be opened.", new Object[0]);
            throw new RedirectException("File could not be opened.", errorPage);
        }
        try {
            att = mgr.getAttachmentInfo(context.getPage().getName());
        }
        catch (PageNotFoundException e) {
            String contentType = "application/octet-stream";
            WikiPath path = context.getPage().getPath().resolve(filename);
            try {
                att = this.m_engine.getContentManager().addPage(path, contentType);
            }
            catch (PageAlreadyExistsException e1) {
                throw new ProviderException(e1.getMessage(), e1);
            }
            created = true;
        }
        PagePermission permission = PermissionFactory.getPagePermission(att, "upload");
        if (this.m_engine.getAuthorizationManager().checkPermission(context.getWikiSession(), permission)) {
            if (user != null) {
                att.setAuthor(user.getName());
            }
            if (changenote != null && changenote.length() > 0) {
                att.setAttribute("changenote", (Serializable)((Object)changenote));
            }
            try {
                this.m_engine.getAttachmentManager().storeAttachment(att, data);
            }
            catch (ProviderException pe) {
                throw new ProviderException(context.getBundle("CoreResources").getString(pe.getMessage()));
            }
        } else {
            throw new RedirectException("No permission to upload a file", errorPage);
        }
        log.info("User " + user + " uploaded attachment to " + parentPage + " called " + filename + ", size " + att.getSize(), new Object[0]);
        return created;
    }

    private static class UploadListener
    extends ProgressItem
    implements ProgressListener {
        public long m_currentBytes;
        public long m_totalBytes;

        private UploadListener() {
        }

        public void update(long recvdBytes, long totalBytes, int item) {
            this.m_currentBytes = recvdBytes;
            this.m_totalBytes = totalBytes;
        }

        public int getProgress() {
            return (int)((double)((float)this.m_currentBytes / (float)this.m_totalBytes * 100.0f) + 0.5);
        }
    }
}

