/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.DynamicAttachment;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentManager {
    public static final String PROP_PROVIDER = "jspwiki.attachmentProvider";
    public static final String PROP_MAXSIZE = "jspwiki.attachment.maxsize";
    public static final String PROP_ALLOWEDEXTENSIONS = "jspwiki.attachment.allowed";
    public static final String PROP_FORDBIDDENEXTENSIONS = "jspwiki.attachment.forbidden";
    static Logger log = LoggerFactory.getLogger(AttachmentManager.class);
    private WikiEngine m_engine;
    private CacheManager m_cachingManager = CacheManager.getInstance();
    private Cache m_dynamicAttachments;
    private static final String CACHE_NAME = "jspwiki.dynamicAttachmentCache";
    private String[] m_allowedPatterns;
    private String[] m_forbiddenPatterns;

    public AttachmentManager(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_dynamicAttachments = this.m_cachingManager.getCache(CACHE_NAME);
        if (this.m_dynamicAttachments == null) {
            this.m_dynamicAttachments = new Cache(CACHE_NAME, 256, false, true, 3600L, 3600L);
            this.m_cachingManager.addCache(this.m_dynamicAttachments);
        }
        this.initFileRestrictions();
    }

    public boolean attachmentsEnabled() {
        return true;
    }

    public Attachment getAttachmentInfo(String name) throws ProviderException, PageNotFoundException {
        return this.m_engine.getContentManager().getPage(WikiPath.valueOf(name));
    }

    public Attachment getAttachmentInfo(String name, int version) throws ProviderException, PageNotFoundException {
        if (name == null) {
            return null;
        }
        return this.getAttachmentInfo(null, name, version);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname) throws ProviderException, PageNotFoundException {
        return this.getAttachmentInfo(context, attachmentname, -1);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname, int version) throws ProviderException, PageNotFoundException {
        WikiPage currentPage = null;
        if (context != null) {
            currentPage = context.getPage();
        }
        if (currentPage == null) {
            return null;
        }
        WikiPath name = currentPage.getPath().resolve(attachmentname);
        JCRWikiPage att = this.getDynamicAttachment(name);
        if (att == null && (att = this.m_engine.getContentManager().getPage(name, version)) != null && att.isAttachment()) {
            return att;
        }
        return null;
    }

    public List<WikiPage> listAttachments(WikiPage wikipage) throws ProviderException {
        return (List)this.listAttachmentsImpl(new ArrayList<WikiPage>(), wikipage);
    }

    public SortedSet<WikiPage> listAttachmentsSorted(WikiPage wikipage) throws ProviderException {
        return (SortedSet)this.listAttachmentsImpl(new TreeSet<WikiPage>(), wikipage);
    }

    private Collection<WikiPage> listAttachmentsImpl(Collection<WikiPage> result, WikiPage wikipage) throws ProviderException {
        List<WikiPage> children = wikipage.getChildren();
        for (WikiPage p : children) {
            JCRWikiPage jwp = (JCRWikiPage)p;
            if (!jwp.isAttachment()) continue;
            result.add(jwp);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAttachments(WikiPage wikipage) {
        try {
            WikiPage p;
            JCRWikiPage jwp;
            List<WikiPage> children = wikipage.getChildren();
            Iterator<WikiPage> iterator = children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(jwp = (JCRWikiPage)(p = iterator.next())).isAttachment());
            return true;
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        return false;
    }

    public InputStream getAttachmentStream(Attachment att) throws IOException, ProviderException {
        return this.getAttachmentStream(null, att);
    }

    public InputStream getAttachmentStream(WikiContext ctx, Attachment att) throws ProviderException, IOException {
        if (att instanceof DynamicAttachment) {
            return ((DynamicAttachment)att).getProvider().getAttachmentData(ctx, att);
        }
        return att.getContentAsStream();
    }

    public void storeDynamicAttachment(WikiContext ctx, DynamicAttachment att) {
        this.m_dynamicAttachments.put(new Element((Object)att.getName(), (Object)att));
    }

    public DynamicAttachment getDynamicAttachment(WikiPath name) {
        Element att = this.m_dynamicAttachments.get((Serializable)((Object)name.toString()));
        if (att != null) {
            return (DynamicAttachment)att.getObjectValue();
        }
        return null;
    }

    public void storeAttachment(Attachment att, File source) throws IOException, ProviderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.storeAttachment(att, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void storeAttachment(Attachment att, InputStream in) throws IOException, ProviderException {
        att.setContent(in);
        att.save();
    }

    public List<WikiPage> getVersionHistory(String attachmentName) throws ProviderException, PageNotFoundException {
        return this.m_engine.getContentManager().getVersionHistory(WikiPath.valueOf(attachmentName));
    }

    public void deleteVersion(WikiPage att) throws ProviderException {
        this.m_engine.getContentManager().deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        this.m_engine.getContentManager().deletePage(att);
    }

    public static String cleanFileName(String filename) throws WikiException {
        if (filename == null || filename.trim().length() == 0) {
            log.error("Empty file name given.", new Object[0]);
            throw new WikiException("attach.empty.file");
        }
        if ((filename = filename.trim()).toLowerCase().endsWith(".jsp") || filename.toLowerCase().endsWith(".jspf")) {
            log.info("Attempt to upload a file with a .jsp/.jspf extension.  In certain cases this can trigger unwanted security side effects, so we're preventing it.", new Object[0]);
            throw new WikiException("attach.unwanted.file");
        }
        String[] splitpath = filename.split("[/\\\\]");
        filename = splitpath[splitpath.length - 1];
        filename = StringUtils.replaceChars((String)filename, (String)"#?\"'", (String)"____");
        return filename;
    }

    public boolean isFileTypeAllowed(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        name = name.toLowerCase();
        int i = 0;
        while (i < this.m_forbiddenPatterns.length) {
            if (name.endsWith(this.m_forbiddenPatterns[i]) && this.m_forbiddenPatterns[i].length() > 0) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_allowedPatterns.length) {
            if (name.endsWith(this.m_allowedPatterns[i]) && this.m_allowedPatterns[i].length() > 0) {
                return true;
            }
            ++i;
        }
        return this.m_allowedPatterns.length == 0;
    }

    private void initFileRestrictions() {
        Properties props = this.m_engine.getWikiProperties();
        String allowed = TextUtil.getStringProperty(props, PROP_ALLOWEDEXTENSIONS, null);
        this.m_allowedPatterns = allowed != null && allowed.length() > 0 ? allowed.toLowerCase().split("\\s") : new String[0];
        String forbidden = TextUtil.getStringProperty(props, PROP_FORDBIDDENEXTENSIONS, null);
        this.m_forbiddenPatterns = forbidden != null && forbidden.length() > 0 ? forbidden.toLowerCase().split("\\s") : new String[0];
        log.debug("AttachmentManager initialized with allowed/denied file patterns.", new Object[0]);
    }
}

