/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.util.List;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionQueue;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Workflow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/Workflow.jsp")
public class WorkflowActionBean
extends AbstractActionBean {
    private Outcome m_outcome = null;
    private int m_id;

    @HandlesEvent(value="abort")
    public Resolution abort() {
        WikiEngine engine = this.getContext().getEngine();
        WikiSession wikiSession = this.getContext().getWikiSession();
        List<Workflow> workflows = engine.getWorkflowManager().getOwnerWorkflows(wikiSession);
        for (Workflow workflow : workflows) {
            if (workflow.getId() != this.m_id) continue;
            workflow.abort();
            break;
        }
        return new RedirectResolution(WorkflowActionBean.class, "view");
    }

    @HandlesEvent(value="decide")
    public Resolution decide() throws WikiException {
        WikiEngine engine = this.getContext().getEngine();
        WikiSession wikiSession = this.getContext().getWikiSession();
        DecisionQueue dq = engine.getWorkflowManager().getDecisionQueue();
        List<Decision> decisions = dq.getActorDecisions(wikiSession);
        for (Decision decision : decisions) {
            if (decision.getId() != this.m_id) continue;
            dq.decide(decision, this.m_outcome);
            break;
        }
        return new RedirectResolution(WorkflowActionBean.class, "view");
    }

    public List<Decision> getDecisions() {
        WikiEngine engine = this.getContext().getEngine();
        WikiSession wikiSession = this.getContext().getWikiSession();
        DecisionQueue dq = engine.getWorkflowManager().getDecisionQueue();
        return dq.getActorDecisions(wikiSession);
    }

    public int getId() {
        return this.m_id;
    }

    public Outcome getOutcome() {
        return this.m_outcome;
    }

    public List<Workflow> getWorkflows() {
        WikiEngine engine = this.getContext().getEngine();
        WikiSession wikiSession = this.getContext().getWikiSession();
        return engine.getWorkflowManager().getOwnerWorkflows(wikiSession);
    }

    @Validate(required=true, on={"abort", "decide"})
    public void setId(int id) {
        this.m_id = id;
    }

    @Validate(required=true, on={"decide"})
    public void setOutcome(Outcome outcome) {
        this.m_outcome = outcome;
    }

    @DefaultHandler
    @HandlesEvent(value="view")
    @WikiRequestContext(value="workflow")
    public Resolution view() {
        return new TemplateResolution("Workflow.jsp");
    }
}

