/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.UrlBindingFactory;
import net.sourceforge.stripes.mock.MockHttpServletRequest;
import net.sourceforge.stripes.mock.MockHttpServletResponse;
import net.sourceforge.stripes.mock.MockHttpSession;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.url.StripesURLConstructor;

public final class WikiContextFactory {
    private static final String ATTR_CONTEXT = "wikiContext";
    public static final String ATTR_WIKIENGINE = "wikiEngine";
    public static final String ATTR_WIKISESSION = "wikiSession";
    private static final Logger log = LoggerFactory.getLogger(WikiContextFactory.class);
    private static final long serialVersionUID = 1L;
    private final WikiEngine m_engine;
    private String m_mockContextPath;
    private boolean m_contextMap_inited = false;
    private final Map<String, HandlerInfo> m_contextMap = new HashMap<String, HandlerInfo>();

    public static WikiContext findContext(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        WikiContext context = (WikiContext)request.getAttribute(ATTR_CONTEXT);
        return context;
    }

    public static void saveContext(ServletRequest request, WikiContext context) {
        request.setAttribute(ATTR_CONTEXT, (Object)context);
    }

    public WikiContextFactory(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_mockContextPath = StripesURLConstructor.getContextPath(engine);
    }

    public HandlerInfo findEventHandler(String requestContext) {
        HandlerInfo handler;
        if (!this.m_contextMap_inited) {
            this.initRequestContextMap();
        }
        if ((handler = this.m_contextMap.get(requestContext)) == null) {
            throw new IllegalArgumentException("No HandlerInfo found for request context '" + requestContext + "'!");
        }
        return handler;
    }

    public WikiActionBeanContext newContext(HttpServletRequest request, HttpServletResponse response, String requestContext) throws WikiException {
        return this.createContext(requestContext, request, response, null);
    }

    public WikiActionBeanContext newViewContext(HttpServletRequest request, HttpServletResponse response, WikiPage page) {
        if (!this.m_contextMap_inited) {
            this.initRequestContextMap();
        }
        WikiActionBeanContext ctx = null;
        try {
            ctx = this.createContext(WikiContext.VIEW, request, response, page);
            if (ctx == null) {
                throw new IllegalStateException("Could not create new WikiContext of type VIEW! This indicates a bug...");
            }
        }
        catch (WikiException e) {
            e.printStackTrace();
            log.error(e.getMessage(), new Object[0]);
        }
        return ctx;
    }

    public WikiActionBeanContext newViewContext(WikiPage page) {
        return this.newViewContext(null, null, page);
    }

    private void initRequestContextMap() {
        Configuration stripesConfig = StripesFilter.getConfiguration();
        if (stripesConfig == null) {
            throw new InternalWikiException("Could not obtain Stripes configuration. FATAL.");
        }
        ActionResolver resolver = stripesConfig.getActionResolver();
        if (resolver instanceof AnnotatedClassActionResolver) {
            UrlBindingFactory urlBindings = ((AnnotatedClassActionResolver)resolver).getUrlBindingFactory();
            Collection beanClasses = urlBindings.getActionBeanClasses();
            for (Class beanClass : beanClasses) {
                Map<Method, HandlerInfo> handlerMethods = HandlerInfo.getHandlerInfoCollection(beanClass);
                for (HandlerInfo handler : handlerMethods.values()) {
                    String requestContext = handler.getRequestContext();
                    if (this.m_contextMap.containsKey(requestContext)) {
                        HandlerInfo duplicateHandler = this.m_contextMap.get(requestContext);
                        log.error("Bean class " + beanClass.getCanonicalName() + " contains @WikiRequestContext annotation '" + requestContext + "' that duplicates one already declared for " + duplicateHandler.getActionBeanClass(), new Object[0]);
                        continue;
                    }
                    this.m_contextMap.put(requestContext, handler);
                    log.debug("Discovered request context '" + requestContext + "' for WikiActionBean=" + beanClass.getCanonicalName() + ",event=" + handler.getEventName(), new Object[0]);
                }
            }
        }
        this.m_contextMap_inited = true;
    }

    protected WikiActionBeanContext createContext(String requestContext, HttpServletRequest request, HttpServletResponse response, WikiPage page) throws WikiException {
        if (request == null) {
            request = new MockHttpServletRequest(this.m_mockContextPath, "/Wiki.jsp");
            MockHttpSession session = new MockHttpSession(this.m_engine.getServletContext());
            ((MockHttpServletRequest)request).addLocale(new Locale(""));
            ((MockHttpServletRequest)request).setSession((HttpSession)session);
        }
        if (response == null) {
            response = new MockHttpServletResponse();
        }
        WikiActionBeanContext context = new WikiActionBeanContext();
        context.setRequest(request);
        context.setResponse(response);
        context.setServletContext(this.m_engine.getServletContext());
        context.setRequestContext(requestContext);
        this.m_engine.getAuthenticationManager().login(request);
        if (page == null) {
            WikiPath pageName = this.extractPageFromParameter(request);
            if (pageName == null && WikiContext.VIEW.equals(requestContext)) {
                page = this.m_engine.getFrontPage(null);
            }
            if (pageName != null) {
                try {
                    page = this.resolvePage(request, pageName);
                }
                catch (PageNotFoundException pageNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (page != null) {
            context.setPage(page);
        }
        return context;
    }

    protected final WikiPath extractPageFromParameter(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String[] pages = request.getParameterValues("page");
        WikiPath page = null;
        if (pages != null && pages.length > 0) {
            page = WikiPath.valueOf(pages[0]);
            try {
                WikiPath finalPage = this.m_engine.getFinalPageName(page);
                if (finalPage == null) {
                    return page;
                }
                return finalPage;
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
        }
        return null;
    }

    protected final WikiPage resolvePage(HttpServletRequest request, WikiPath page) throws PageNotFoundException, ProviderException {
        int version = -1;
        String rev = request.getParameter("version");
        if (rev != null) {
            version = Integer.parseInt(rev);
        }
        try {
            return this.m_engine.getContentManager().getPage(page, version);
        }
        catch (PageNotFoundException e) {
            String pageName = MarkupParser.cleanLink(page.getPath());
            try {
                return this.m_engine.createPage(WikiPath.valueOf(pageName));
            }
            catch (PageAlreadyExistsException e1) {
                throw new ProviderException(e1.getMessage(), e1);
            }
        }
    }
}

