/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/Wiki.jsp")
public class ViewActionBean
extends AbstractPageActionBean {
    private static final Logger log = LoggerFactory.getLogger(ViewActionBean.class);
    private String m_renameTo = null;
    private int m_version = -1;

    @HandlesEvent(value="ajaxCategories")
    public Resolution ajaxCategories() {
        StreamingResolution r = new StreamingResolution("text/html; charset=UTF-8"){

            public void stream(HttpServletResponse response) throws IOException {
                String result;
                WikiActionBeanContext context = ViewActionBean.this.getContext();
                PrintWriter out = response.getWriter();
                PluginManager mgr = context.getEngine().getPluginManager();
                try {
                    result = mgr.execute(context, "{ReferringPagesPlugin,page=" + ViewActionBean.this.getPage().getName() + ",max=20,before='*',after='\\n'}");
                }
                catch (PluginException e) {
                    result = e.getMessage();
                }
                ((Writer)out).write(result);
            }
        };
        return r;
    }

    @HandlesEvent(value="attachments")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    public Resolution attachments() {
        return new TemplateResolution("PageInfo.jsp").addParameter("tab", new Object[]{"attachments"});
    }

    public String getRenameTo() {
        return this.m_renameTo;
    }

    public int getVersion() {
        return this.m_version;
    }

    @HandlesEvent(value="info")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    @WikiRequestContext(value="info")
    public Resolution info() throws ProviderException {
        WikiPage page = this.getPage();
        if (page.isAttachment()) {
            return new TemplateResolution("AttachmentInfo.jsp");
        }
        return new TemplateResolution("PageInfo.jsp").addParameter("tab", new Object[]{"info"});
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public Resolution resolvePage() throws WikiException {
        WikiPage page;
        WikiActionBeanContext context = this.getContext();
        WikiEngine engine = context.getEngine();
        if (this.isSpecialPageView()) {
            String pageName = context.getRequest().getParameter("page");
            if (pageName != null) {
                URI uri = engine.getSpecialPageReference(pageName);
                if (uri != null) {
                    return new RedirectResolution(uri.toString());
                }
                throw new WikiException("Wiki page name " + pageName + " didn't parse. This is highly unusual.");
            }
            if (log.isDebugEnabled()) {
                log.debug("User did not supply a page name: defaulting to front page.", new Object[0]);
            }
            this.setPage(engine.getFrontPage(null));
        }
        if ((page = this.getPage()) == null) {
            throw new WikiException("Page not supplied, and WikiEngine does not define a front page! This is highly unusual.");
        }
        String specialUrl = (String)((Object)page.getAttribute("alias"));
        if (specialUrl != null) {
            return new RedirectResolution(context.getViewURL(specialUrl));
        }
        specialUrl = (String)((Object)page.getAttribute("redirect"));
        if (specialUrl != null) {
            return new RedirectResolution(context.getViewURL(specialUrl));
        }
        String handler = context.getEventName();
        if (page.isAttachment() && !"info".equals(handler)) {
            return new RedirectResolution(ViewActionBean.class, "info").addParameter("page", new Object[]{page.getPath().toString()});
        }
        if (engine.pageExists(page.getPath().toString(), this.m_version)) {
            try {
                page = engine.getPage(page.getPath().toString(), this.m_version);
                this.setPage(page);
            }
            catch (PageNotFoundException e) {
                throw new WikiException("Did not retrieve the page even though it exists.  This is a BUG. ", e);
            }
        }
        return null;
    }

    @Validate(required=false)
    public void setPage(WikiPage page) {
        super.setPage(page);
    }

    public void setRenameTo(String renameTo) {
        this.m_renameTo = renameTo;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="view")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    @WikiRequestContext(value="view")
    public Resolution view() throws ProviderException {
        return new TemplateResolution("Wiki.jsp").addParameter("tab", new Object[]{"view"});
    }

    private boolean isSpecialPageView() {
        ValidationErrors errors = this.getContext().getValidationErrors();
        List fieldErrors = (List)errors.get((Object)"page");
        if (fieldErrors == null) {
            return false;
        }
        for (ValidationError error : fieldErrors) {
            if (!(error instanceof LocalizableError) || !"edit.specialPage".equals(((LocalizableError)error).getMessageKey())) continue;
            return true;
        }
        return false;
    }
}

