/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.security.Principal;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.SpamProtect;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.workflow.DecisionRequiredException;

@UrlBinding(value="/UserProfile.jsp")
public class UserProfileActionBean
extends AbstractActionBean {
    Logger log = LoggerFactory.getLogger(UserProfileActionBean.class);
    private String m_redirect = null;
    protected UserProfile m_profile = null;
    protected String m_passwordAgain = null;

    public String getPasswordAgain() {
        return this.m_passwordAgain;
    }

    public UserProfile getProfile() {
        return this.m_profile;
    }

    public String getRedirect() {
        return this.m_redirect;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public Resolution initUserProfile() {
        WikiEngine engine = this.getContext().getEngine();
        WikiSession session = this.getContext().getWikiSession();
        UserManager manager = engine.getUserManager();
        this.m_profile = manager.getUserProfile(session);
        this.m_profile.setPassword(null);
        this.getContext().getRequest().setAttribute("userProfile", (Object)this.m_profile);
        return null;
    }

    @HandlesEvent(value="save")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="editProfile")
    @SpamProtect
    public Resolution save() {
        WikiActionBeanContext context = this.getContext();
        ValidationErrors errors = context.getValidationErrors();
        try {
            WikiEngine engine = this.getContext().getEngine();
            engine.getUserManager().setUserProfile(this.getContext().getWikiSession(), this.m_profile);
            CookieAssertionLoginModule.setUserCookie(context.getResponse(), this.m_profile.getFullname());
        }
        catch (DecisionRequiredException e) {
            return new RedirectResolution(ViewActionBean.class).addParameter("page", new Object[]{"ApprovalRequiredForUserProfiles"});
        }
        catch (Exception e) {
            errors.add("profile", (ValidationError)new LocalizableError("profile.saveError", new Object[]{e.getMessage()}));
        }
        if (errors.size() == 0) {
            Principal principal = this.getContext().getWikiSession().getUserPrincipal();
            CookieAssertionLoginModule.setUserCookie(this.getContext().getResponse(), principal.getName());
            RedirectResolution r = new RedirectResolution(ViewActionBean.class);
            if (this.m_redirect != null) {
                r.addParameter("page", new Object[]{this.m_redirect});
            }
            return r;
        }
        RedirectResolution r = new RedirectResolution(ViewActionBean.class);
        if (this.m_redirect != null) {
            r.addParameter("page", new Object[]{this.m_redirect});
        }
        return r;
    }

    public void setPasswordAgain(String password) {
        this.m_passwordAgain = password;
    }

    @ValidateNestedProperties(value={@Validate(field="loginName", required=true, minlength=1, maxlength=100), @Validate(field="fullname", required=true, minlength=1, maxlength=100), @Validate(field="password", minlength=8, maxlength=100), @Validate(field="email", converter=EmailTypeConverter.class)})
    public void setProfile(UserProfile profile) {
        this.m_profile = profile;
    }

    public void setRedirect(String redirect) {
        this.m_redirect = redirect;
        this.getContext().setVariable("redirect", redirect);
    }

    @ValidationMethod(when=ValidationState.NO_ERRORS)
    public void validateNoCollision(ValidationErrors errors) {
        UserProfile otherProfile;
        WikiEngine engine = this.getContext().getEngine();
        WikiSession session = this.getContext().getWikiSession();
        UserManager manager = engine.getUserManager();
        UserDatabase database = manager.getUserDatabase();
        UserProfile oldProfile = manager.getUserProfile(session);
        AuthenticationManager authMgr = engine.getAuthenticationManager();
        if (authMgr.isContainerAuthenticated()) {
            this.m_profile.setLoginName(oldProfile.getLoginName());
            this.m_profile.setPassword(null);
        }
        try {
            otherProfile = database.findByLoginName(this.m_profile.getLoginName());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                errors.add("profile.loginName", (ValidationError)new LocalizableError("profile.nameCollision", new Object[0]));
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        try {
            otherProfile = database.findByFullName(this.m_profile.getFullname());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                errors.add("profile.fullname", (ValidationError)new LocalizableError("profile.nameCollision", new Object[0]));
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
    }

    @ValidationMethod(when=ValidationState.ALWAYS)
    public void validatePasswords(ValidationErrors errors) {
        if (this.m_profile.isNew() && this.m_profile.getPassword() == null) {
            errors.add("profile.password", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
        }
        if (this.m_profile.getPassword() != null && !this.m_profile.getPassword().equals(this.m_passwordAgain)) {
            errors.add("profile.password", (ValidationError)new LocalizableError("profile.noPasswordMatch", new Object[0]));
        }
    }

    @HandlesEvent(value="create")
    @DontValidate
    public Resolution create() {
        return new TemplateResolution("CreateProfile.jsp").addParameter("tab", new Object[]{"profile"});
    }

    @HandlesEvent(value="view")
    @DefaultHandler
    @DontValidate
    @WikiRequestContext(value="profile")
    public Resolution view() {
        return new TemplateResolution("Preferences.jsp").addParameter("tab", new Object[]{"profile"});
    }
}

