/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.security.Principal;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.action.EditActionBean;
import org.apache.wiki.action.LoginActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/UserPreferences.jsp")
public class UserPreferencesActionBean
extends AbstractActionBean {
    private static final Logger log = LoggerFactory.getLogger("JSPWiki");
    private static final String VALID_USER_PATTERN = "^[^( |:)][^:]*";
    private String m_assertedName = null;
    private String m_editor = null;
    private String m_redirect = null;
    private Locale m_locale = null;
    private Preferences.Orientation m_orientation = null;
    private String m_timeFormat = null;
    private TimeZone m_timeZone = null;
    private boolean m_showQuickLinks = false;
    private boolean m_sectionEditing = false;
    private String m_skin = null;

    @HandlesEvent(value="clearAssertedName")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="editPreferences")
    public Resolution clearAssertedName() {
        HttpServletResponse response = this.getContext().getResponse();
        CookieAssertionLoginModule.clearUserCookie(response);
        return new RedirectResolution(LoginActionBean.class, "logout");
    }

    @HandlesEvent(value="editFavorites")
    @WikiRequestContext(value="favorites")
    public Resolution editFavorites() {
        Principal principal = this.getContext().getCurrentUser();
        return new RedirectResolution(EditActionBean.class).addParameter("page", new Object[]{String.valueOf(principal.getName()) + "Favorites"});
    }

    public String getAssertedName() {
        return this.m_assertedName;
    }

    public String getEditor() {
        return this.m_editor;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Preferences.Orientation getOrientation() {
        return this.m_orientation;
    }

    public String getRedirect() {
        return this.m_redirect;
    }

    public String getSkin() {
        return this.m_skin;
    }

    public String getTimeFormat() {
        return this.m_timeFormat;
    }

    public TimeZone getTimeZone() {
        return this.m_timeZone;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public Resolution initPreferenceOptions() {
        WikiSession wikiSession = this.getContext().getWikiSession();
        if (wikiSession.isAsserted()) {
            this.m_assertedName = wikiSession.getUserPrincipal().getName();
        }
        HttpServletRequest request = this.getContext().getRequest();
        Preferences prefs = Preferences.getPreferences(request);
        this.m_editor = (String)prefs.get("Editor");
        this.m_locale = (Locale)prefs.get("Locale");
        this.m_orientation = (Preferences.Orientation)((Object)prefs.get("Orientation"));
        this.m_sectionEditing = (Boolean)prefs.get("SectionEditing");
        this.m_skin = (String)prefs.get("Skin");
        this.m_timeFormat = (String)prefs.get("TimeFormat");
        this.m_timeZone = (TimeZone)prefs.get("TimeZone");
        return null;
    }

    public boolean isSectionEditing() {
        return this.m_sectionEditing;
    }

    public boolean isShowQuickLinks() {
        return this.m_showQuickLinks;
    }

    @HandlesEvent(value="save")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="editPreferences")
    public Resolution save() throws WikiException {
        HttpServletRequest request = this.getContext().getRequest();
        HttpServletResponse response = this.getContext().getResponse();
        if (!this.getContext().getWikiSession().isAuthenticated()) {
            CookieAssertionLoginModule.setUserCookie(response, this.m_assertedName);
        }
        Preferences prefs = Preferences.getPreferences(request);
        prefs.put("Editor", (Object)this.m_editor);
        prefs.put("Locale", (Object)this.m_locale);
        prefs.put("Orientation", (Object)this.m_orientation);
        prefs.put("SectionEditing", (Object)this.m_sectionEditing);
        prefs.put("Skin", (Object)this.m_skin);
        prefs.put("TimeFormat", (Object)this.m_timeFormat);
        prefs.put("TimeZone", (Object)this.m_timeZone);
        prefs.save(this.getContext());
        if (this.m_redirect != null) {
            log.info("Redirecting user to wiki page " + this.m_redirect, new Object[0]);
            return new RedirectResolution(ViewActionBean.class).addParameter("page", new Object[]{this.m_redirect});
        }
        return new RedirectResolution(ViewActionBean.class);
    }

    @Validate(required=false, on={"save"}, minlength=1, maxlength=128, mask="^[^( |:)][^:]*")
    public void setAssertedName(String name) {
        this.m_assertedName = name;
    }

    @Validate(required=true, on={"save"})
    public void setEditor(String editor) {
        this.m_editor = editor;
        if (this.getContext().getRequest() != null) {
            HttpSession session = this.getContext().getRequest().getSession();
            session.setAttribute("editor", (Object)editor);
        }
    }

    @Validate(required=true, on={"save"})
    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Validate(required=true, on={"save"})
    public void setOrientation(Preferences.Orientation orientation) {
        this.m_orientation = orientation;
    }

    @Validate(required=false)
    public void setRedirect(String url) {
        this.m_redirect = url;
    }

    @Validate(required=false, on={"save"})
    public void setSectionEditing(boolean sectionEditing) {
        this.m_sectionEditing = sectionEditing;
    }

    @Validate(required=false)
    public void setShowQuickLinks(boolean showQuickLinks) {
        this.m_showQuickLinks = showQuickLinks;
    }

    @Validate(required=true, on={"save"})
    public void setSkin(String skin) {
        this.m_skin = skin;
    }

    @Validate(required=true, on={"save"})
    public void setTimeFormat(String timeFormat) {
        this.m_timeFormat = timeFormat;
    }

    @Validate(required=true, on={"save"})
    public void setTimeZone(TimeZone timeZone) {
        this.m_timeZone = timeZone;
    }

    @DefaultHandler
    @HandlesEvent(value="prefs")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="editPreferences")
    @WikiRequestContext(value="prefs")
    public Resolution view() {
        return new TemplateResolution("Preferences.jsp").addParameter("tab", new Object[]{"prefs"});
    }
}

