/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.ajax.JavaScriptResolution;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.ui.stripes.AjaxEvent;
import org.apache.wiki.ui.stripes.AjaxResolution;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/Search.jsp")
public class SearchActionBean
extends AbstractActionBean {
    private static Logger log = LoggerFactory.getLogger("JSPWikiSearch");
    public static final Collection<SearchResult> NO_RESULTS = Collections.emptyList();
    private Collection<SearchResult> m_results = NO_RESULTS;
    private String m_query = null;
    private int m_maxItems = 20;
    private int m_start = 0;
    private boolean m_details = false;

    public boolean getDetails() {
        return this.m_details;
    }

    public void setDetails(boolean details) {
        this.m_details = details;
    }

    public int getMaxItems() {
        return this.m_maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.m_maxItems = maxItems;
    }

    public int getStart() {
        return this.m_start;
    }

    public void setStart(int start) {
        this.m_start = start;
    }

    public String getQuery() {
        return this.m_query;
    }

    public Collection<SearchResult> getResults() {
        return this.m_results;
    }

    private List<SearchResult> doSearch(String query) {
        log.info("Searching with query '" + query + "'.", new Object[0]);
        WikiEngine engine = this.getContext().getEngine();
        AuthorizationManager mgr = engine.getAuthorizationManager();
        ArrayList<SearchResult> filteredResults = new ArrayList<SearchResult>();
        try {
            List<SearchResult> results = engine.findPages(query);
            for (SearchResult result : results) {
                WikiPage page = result.getPage();
                PagePermission permission = new PagePermission(page, "view");
                try {
                    if (!mgr.checkPermission(this.getContext().getWikiSession(), permission)) continue;
                    filteredResults.add(result);
                }
                catch (Exception e) {
                    log.error("Searching for page " + page, e);
                }
            }
        }
        catch (Exception e) {
            log.debug("Could not search using query '" + query + "'.", e, new Object[0]);
            SimpleMessage message = new SimpleMessage(e.getMessage(), new Object[0]);
            this.getContext().getMessages().add(message);
            e.printStackTrace();
        }
        return filteredResults;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    @DefaultHandler
    @HandlesEvent(value="search")
    @WikiRequestContext(value="find")
    public Resolution search() {
        this.m_results = this.m_query == null ? NO_RESULTS : this.doSearch(this.m_query);
        return new TemplateResolution("Search.jsp");
    }

    @AjaxEvent
    @HandlesEvent(value="ajaxSearch")
    public Resolution ajaxSearch() {
        this.m_results = this.m_query == null ? NO_RESULTS : this.doSearch(this.m_query);
        return new JavaScriptResolution(this.m_results, new Object[0]);
    }

    @AjaxEvent
    @HandlesEvent(value="quickSearch")
    public Resolution quickSearch() {
        this.m_results = this.m_query == null ? NO_RESULTS : this.doSearch(this.m_query);
        String html = null;
        StringBuilder b = new StringBuilder();
        if (this.m_results.size() > 0) {
            b.append("<ul>");
            for (SearchResult result : this.m_results) {
                String url = this.getContext().getViewURL(result.getPage().getName());
                b.append("<li>");
                b.append("<a href=\"" + url + "\">" + result.getPage().getName() + "</a>");
                b.append(" <span class=\"small\">(" + result.getScore() + ")</span>");
                b.append("</li>");
            }
            b.append("</ul>");
            html = b.toString();
        }
        return new AjaxResolution(this.getContext(), html);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        ALL,
        AUTHORS,
        PAGE_NAMES,
        CONTENTS,
        ATTACHMENTS;

    }
}

