/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.PageRenamer;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.tags.BreadcrumbsTag;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/Rename.jsp")
public class RenameActionBean
extends AbstractPageActionBean {
    private static final Logger log = LoggerFactory.getLogger(RenameActionBean.class);
    private String m_renameTo = null;

    public String getRenameTo() {
        return this.m_renameTo;
    }

    @HandlesEvent(value="rename")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="rename")
    @WikiRequestContext(value="rename")
    public Resolution rename() throws WikiException {
        WikiEngine engine = this.getContext().getEngine();
        String renameFrom = this.getContext().getPage().getName();
        HttpServletRequest request = this.getContext().getRequest();
        log.info("Page rename request for page '" + renameFrom + "' to new name '" + this.m_renameTo + "' from " + request.getRemoteAddr() + " by " + request.getRemoteUser(), new Object[0]);
        PageRenamer renamer = engine.getPageRenamer();
        String renamedTo = renamer.renamePage(this.getContext(), renameFrom, this.m_renameTo);
        BreadcrumbsTag.deleteFromBreadCrumb(request, renameFrom);
        log.info("Page successfully renamed to '" + renamedTo + "'", new Object[0]);
        return new RedirectResolution(ViewActionBean.class).addParameter("page", new Object[]{renamedTo});
    }

    @Validate(required=true, minlength=1, maxlength=100, expression="page.name != renameTo")
    public void setRenameTo(String pageName) {
        this.m_renameTo = pageName;
    }

    @ValidationMethod(on={"rename"})
    public void validateBeforeRename(ValidationErrors errors) {
        if (this.getContext().getEngine().pageExists(this.m_renameTo)) {
            errors.add("renameTo", (ValidationError)new LocalizableError("rename.exists", new Object[0]));
        }
    }
}

