/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.util.HttpUtil;

@UrlBinding(value="/rss.jsp")
public class RSSActionBean
extends AbstractPageActionBean {
    private static final Logger log = LoggerFactory.getLogger(RSSActionBean.class);

    @Validate(required=true, on={"rss"})
    public void setPage(WikiPage page) {
        super.setPage(page);
    }

    @DefaultHandler
    @HandlesEvent(value="rss")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.name}", actions="view")
    @WikiRequestContext(value="rss")
    public Resolution rss() throws IOException {
        final WikiActionBeanContext context = this.getContext();
        final HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        final WikiEngine wiki = context.getEngine();
        final WikiPage page = context.getPage();
        final String mode = this.getRssMode(request);
        final String type = this.getRssType(request);
        final Cache cache = this.getRssCache();
        if (wiki.getBaseURL().length() == 0) {
            response.sendError(500, "The jspwiki.baseURL property has not been defined for this wiki - cannot generate RSS");
            return null;
        }
        if (wiki.getRSSGenerator() == null) {
            response.sendError(404, "RSS feeds are disabled.");
            return null;
        }
        if (page == null || !wiki.pageExists(page.getName())) {
            response.sendError(404, "No such page " + page.getName());
            return null;
        }
        StreamingResolution r = new StreamingResolution(String.valueOf(RSSGenerator.getContentType(type)) + "; charset=UTF-8"){

            protected void stream(HttpServletResponse response) throws Exception {
                List<WikiPage> changed;
                context.setVariable("jspwiki.referenceStyle", "absolute");
                if (mode.equals("blog")) {
                    WeblogPlugin plug = new WeblogPlugin();
                    changed = plug.findBlogEntries(wiki.getContentManager(), page.getName(), new Date(0L), new Date());
                } else {
                    changed = wiki.getVersionHistory(page.getName());
                }
                boolean hasChanged = false;
                Date latest = new Date(0L);
                for (WikiPage p : changed) {
                    if (!HttpUtil.checkFor304(request, p)) {
                        hasChanged = true;
                    }
                    if (!p.getLastModified().after(latest)) continue;
                    latest = p.getLastModified();
                }
                if (!hasChanged && changed.size() > 0) {
                    response.sendError(304);
                    log.info("Requested RSS feed for page " + page.getPath().toString() + ", but nothing changed.", new Object[0]);
                    return;
                }
                response.addDateHeader("Last-Modified", latest.getTime());
                response.addHeader("ETag", HttpUtil.createETag(page));
                String hashKey = String.valueOf(page.getName()) + ";" + mode + ";" + type + ";" + latest.getTime();
                String rss = "";
                Element e = cache.get((Serializable)((Object)hashKey));
                if (e != null) {
                    log.info("Returning cached RSS feed for page " + page.getPath().toString() + ".", new Object[0]);
                    rss = (String)((Object)e.getValue());
                } else {
                    try {
                        log.info("Generating RSS feed for page " + page.getPath().toString() + ".", new Object[0]);
                        rss = wiki.getRSSGenerator().generateFeed(context, changed, mode, type);
                        cache.put(new Element((Serializable)((Object)hashKey), (Serializable)((Object)rss)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                response.getWriter().println(rss);
            }
        };
        return r;
    }

    private Cache getRssCache() {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache("jspwiki.rssCache");
        if (cache == null) {
            cache = new Cache("jspwiki.rssCache", 500, false, false, 86400L, 86400L);
            cacheManager.addCache(cache);
        }
        return cache;
    }

    private String getRssMode(HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode == null || !mode.equals("blog") && !mode.equals("wiki")) {
            mode = "blog";
        }
        return mode;
    }

    private String getRssType(HttpServletRequest request) {
        String type = request.getParameter("type");
        if (type == null || !type.equals("rss10") && !type.equals("rss20") && !type.equals("atom")) {
            type = "rss20";
        }
        return type;
    }
}

