/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/Message.jsp")
public class MessageActionBean
extends AbstractActionBean {
    private static final Logger LOG = LoggerFactory.getLogger(MessageActionBean.class);
    private String m_message = null;
    private Throwable m_realcause = null;

    @DontValidate
    @HandlesEvent(value="error")
    @WikiRequestContext(value="error")
    public Resolution error() {
        WikiActionBeanContext wikiContext = this.getContext();
        HttpServletRequest request = wikiContext.getHttpRequest();
        String msg = "JSPWiki encountered an error.";
        Exception exception = (Exception)request.getAttribute("javax.servlet.jsp.jspException");
        if (exception != null) {
            msg = exception.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = "JSPWiki encountered a " + exception.getClass().getName() + " exception.";
            }
            this.setMessage(msg);
            if (exception instanceof JspException) {
                LOG.debug("IS JSPEXCEPTION", new Object[0]);
                this.m_realcause = ((JspException)exception).getRootCause();
                LOG.debug("REALCAUSE=" + this.m_realcause, new Object[0]);
            }
            if (this.m_realcause == null) {
                this.m_realcause = exception;
            }
        } else {
            this.m_realcause = new Exception("Unknown cause.");
        }
        LOG.debug("Error.jsp exception is: ", exception, new Object[0]);
        return new TemplateResolution("Error.jsp");
    }

    public String getMessage() {
        return this.m_message;
    }

    public Throwable getRealCause() {
        return this.m_realcause;
    }

    public Class<? extends Throwable> getRealCauseClass() {
        return this.m_realcause.getClass();
    }

    public String getThrowingMethod() {
        return this.m_realcause == null ? null : FileUtil.getThrowingMethod(this.m_realcause);
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="message")
    @WikiRequestContext(value="message")
    public Resolution message() {
        return new TemplateResolution("Message.jsp");
    }

    public void setMessage(String message) {
        this.m_message = message;
        if (this.m_message != null) {
            HttpServletRequest request = this.getContext().getRequest();
            request.setAttribute("message", (Object)this.m_message);
        }
    }
}

