/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.mail.AuthenticationFailedException;
import javax.mail.SendFailedException;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.util.MailUtil;
import org.apache.wiki.util.TextUtil;

@UrlBinding(value="/LostPassword.jsp")
public class LostPasswordActionBean
extends AbstractActionBean {
    private static final Logger log = LoggerFactory.getLogger(LostPasswordActionBean.class);
    private String m_email = null;

    public String getEmail() {
        return this.m_email;
    }

    @HandlesEvent(value="reset")
    public Resolution reset() {
        String messageKey = null;
        ResourceBundle rb = this.getContext().getBundle("CoreResources");
        WikiEngine engine = this.getContext().getEngine();
        boolean success = false;
        try {
            UserDatabase userDatabase = engine.getUserManager().getUserDatabase();
            UserProfile profile = userDatabase.findByEmail(this.m_email);
            String email = profile.getEmail();
            String randomPassword = TextUtil.generateRandomPassword();
            Object[] args = new Object[]{profile.getLoginName(), randomPassword, engine.getURLConstructor().makeURL("none", "Login.jsp", true, ""), engine.getApplicationName()};
            String mailMessage = MessageFormat.format(rb.getString("lostpwd.newpassword.email"), args);
            args = new Object[]{engine.getApplicationName()};
            String mailSubject = MessageFormat.format(rb.getString("lostpwd.newpassword.subject"), args);
            MailUtil.sendMessage(engine, email, mailSubject, mailMessage);
            log.info("User " + email + " requested and received a new password.", new Object[0]);
            profile.setPassword(randomPassword);
            userDatabase.save(profile);
            success = true;
        }
        catch (NoSuchPrincipalException e) {
            messageKey = "lostpwd.nouser";
            log.info("Tried to reset password for non-existent user '" + this.m_email + "'", new Object[0]);
        }
        catch (SendFailedException e) {
            messageKey = "lostpwd.nomail";
            log.error("Tried to reset password and got SendFailedException: " + (Object)((Object)e), new Object[0]);
        }
        catch (AuthenticationFailedException e) {
            messageKey = "lostpwd.nomail";
            log.error("Tried to reset password and got AuthenticationFailedException: " + (Object)((Object)e), new Object[0]);
        }
        catch (Exception e) {
            messageKey = "lostpwd.nomail";
            log.error("Tried to reset password and got another exception: " + e, new Object[0]);
        }
        if (success) {
            List messages = this.getContext().getMessages("reset");
            messages.add(new SimpleMessage(rb.getString("lostpwd.emailed"), new Object[0]));
        } else {
            ValidationErrors errors = this.getContext().getValidationErrors();
            errors.addGlobalError((ValidationError)new LocalizableError(messageKey, new Object[]{this.m_email}));
        }
        return new TemplateResolution("Login.jsp").addParameter("tab", new Object[]{"reset"});
    }

    @Validate(required=true, on={"reset"}, converter=EmailTypeConverter.class)
    public void setEmail(String email) {
        this.m_email = email;
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="view")
    public Resolution view() {
        return new TemplateResolution("Login.jsp").addParameter("tab", new Object[]{"reset"});
    }
}

