/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.util.UrlBuilder;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.action.MessageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.login.CookieAuthenticationLoginModule;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/Login.jsp")
public class LoginActionBean
extends AbstractActionBean {
    private static final Logger log = LoggerFactory.getLogger(LoginActionBean.class);
    private String m_username = null;
    private boolean m_remember = false;
    private String m_password;
    private String m_redirect = null;

    private Resolution saveCookiesAndRedirect(String pageName, boolean rememberMe) {
        Principal principal = this.getContext().getWikiSession().getUserPrincipal();
        CookieAssertionLoginModule.setUserCookie(this.getContext().getResponse(), principal.getName());
        if (rememberMe) {
            CookieAuthenticationLoginModule.setLoginCookie(this.getContext().getEngine(), this.getContext().getResponse(), principal.getName());
        }
        UrlBuilder builder = new UrlBuilder(this.getContext().getLocale(), ViewActionBean.class, false);
        if (pageName != null) {
            builder.addParameter("page", new Object[]{pageName});
        }
        return new RedirectResolution(builder.toString());
    }

    public String getJ_password() {
        return this.m_password;
    }

    public boolean getRemember() {
        return this.m_remember;
    }

    public String getJ_username() {
        return this.m_username;
    }

    public String getRedirect() {
        return this.m_redirect;
    }

    @ValidationMethod(on={"login"}, when=ValidationState.NO_ERRORS)
    public void validateCredentials() {
        WikiSession wikiSession = this.getContext().getWikiSession();
        ValidationErrors errors = this.getContext().getValidationErrors();
        HttpServletRequest request = this.getContext().getRequest();
        log.debug("Attempting to authenticate user " + this.m_username, new Object[0]);
        try {
            this.getContext().getEngine().getAuthenticationManager().login(wikiSession, request, this.m_username, this.m_password);
        }
        catch (LoginException e) {
            log.info("Failed to authenticate user " + this.m_username + ", reason: " + e.getMessage(), new Object[0]);
            errors.addGlobalError((ValidationError)new SimpleError(e.getMessage(), new Object[0]));
        }
        catch (WikiSecurityException e) {
            log.info("Failed to authenticate user " + this.m_username + ", reason: " + e.getMessage(), new Object[0]);
            errors.addGlobalError((ValidationError)new SimpleError(e.getMessage(), new Object[0]));
        }
    }

    @HandlesEvent(value="login")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="login")
    public Resolution login() {
        log.info("Successfully authenticated user " + this.m_username + " (custom auth)", new Object[0]);
        return this.saveCookiesAndRedirect(this.m_redirect, this.m_remember);
    }

    @HandlesEvent(value="logout")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="login")
    @WikiRequestContext(value="logout")
    public Resolution logout() {
        WikiEngine engine = this.getContext().getEngine();
        HttpServletRequest request = this.getContext().getRequest();
        HttpServletResponse response = this.getContext().getResponse();
        engine.getAuthenticationManager().logout(request);
        CookieAssertionLoginModule.clearUserCookie(response);
        if (engine.getAuthenticationManager().allowsCookieAuthentication()) {
            CookieAuthenticationLoginModule.clearLoginCookie(engine, request, response);
        }
        return new RedirectResolution(ViewActionBean.class);
    }

    @Validate(required=true, on={"login"}, minlength=1, maxlength=128)
    public void setJ_password(String password) {
        this.m_password = password;
    }

    @Validate
    public void setRemember(boolean remember) {
        this.m_remember = remember;
    }

    @Validate(required=true, on={"login"}, minlength=1, maxlength=128)
    public void setJ_username(String username) {
        this.m_username = username;
    }

    @Validate
    public void setRedirect(String redirect) {
        this.m_redirect = redirect;
        this.getContext().setVariable("redirect", redirect);
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="view")
    @HandlerPermission(permissionClass=WikiPermission.class, target="${context.engine.applicationName}", actions="login")
    @WikiRequestContext(value="login")
    public Resolution view() {
        if (this.getContext().getWikiSession().isAuthenticated()) {
            String accessDenied = new LocalizableError("login.error.noaccess", new Object[0]).getMessage(this.getContext().getRequest().getLocale());
            return new ForwardResolution(MessageActionBean.class).addParameter("message", new Object[]{accessDenied});
        }
        if (this.getContext().getEngine().getAuthenticationManager().isContainerAuthenticated()) {
            HttpSession session = this.getContext().getRequest().getSession();
            Object seen = session.getAttribute("_redirect");
            if (seen != null) {
                this.getContext().getValidationErrors().addGlobalError((ValidationError)new LocalizableError("login.error.noaccess", new Object[0]));
                return new RedirectResolution(MessageActionBean.class);
            }
            session.setAttribute("_redirect", (Object)"I love Outi");
            Principal user = this.getContext().getWikiSession().getLoginPrincipal();
            log.info("Successfully authenticated user " + user.getName() + " (container auth)", new Object[0]);
        }
        return new TemplateResolution("Login.jsp").addParameter("tab", new Object[]{"login"});
    }
}

