/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.HttpCache;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.LdapConfig;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.LdapAuthorizer;
import org.apache.wiki.auth.authorize.WebContainerAuthorizer;
import org.apache.wiki.auth.user.LdapUserDatabase;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.auth.user.XMLUserDatabase;
import org.apache.wiki.ui.stripes.AjaxEvent;
import org.apache.wiki.ui.stripes.AjaxResolution;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.util.CommentedProperties;
import org.apache.wiki.util.CryptoUtil;
import org.apache.wiki.util.TextUtil;
import org.freshcookies.security.Keychain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HttpCache(allow=false)
public class InstallActionBean
extends AbstractActionBean {
    public static final String PROP_ADMIN_ID = "admin";
    public static final String PROP_ADMIN_NAME = "Administrator";
    public static final String PROP_ADMIN_GROUP = "Admin";
    public static final String PROP_ADMIN_PASSWORD_HASH = "admin.passwordHash";
    private static final String CONFIG_LOG_FILE = "log4j_appender_FileLog_File";
    private static final String CONFIG_WORK_DIR = "jspwiki_workDir";
    private static final String CONFIG_PAGE_DIR = "priha_provider_defaultProvider_directory";
    private static final String CONFIG_USERDATABASE = "jspwiki_userdatabase";
    private static final String CONFIG_AUTHORIZER = "jspwiki_authorizer";
    private static final String CONFIG_LDAP_SSL = "ldap_ssl";
    private static final String CONFIG_BASE_URL = "jspwiki_baseURL";
    private static final String CONFIG_ADMIN_PASSWORD_HASH = "admin_passwordHash";
    private String m_bindPassword = null;
    private String m_adminPassword = null;
    private Keychain m_keychain = null;
    private File m_keychainPath = null;
    private String m_logDirectory = null;
    private Map<String, PropertiesMap<String, String>> m_properties = null;

    public static void main(String[] params) {
        int i = 1;
        while (i < 255) {
            char ch = (char)i;
            System.out.print(String.valueOf(i) + ": " + ch + " ");
            System.out.println(Character.isJavaIdentifierPart(ch));
            ++i;
        }
    }

    public boolean getAdminExists() {
        PropertiesMap<String, String> jspwiki = this.m_properties.get("jspwiki");
        if (jspwiki != null) {
            return jspwiki.containsKey(CONFIG_ADMIN_PASSWORD_HASH);
        }
        return false;
    }

    public String getAdminPassword() {
        return this.m_adminPassword;
    }

    public String getBindPassword() {
        return this.m_bindPassword;
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }

    public Map<String, PropertiesMap<String, String>> getProperties() {
        return this.m_properties;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public Resolution init() throws IOException, NoSuchAlgorithmException {
        File logs;
        ServletContext context = this.getContext().getServletContext();
        String path = context.getRealPath("/");
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, PropertiesMap<String, String>>();
        }
        PropertiesMap<String, String> jspwiki = new PropertiesMap<String, String>(new File(path, "/WEB-INF/jspwiki.properties"));
        jspwiki.load();
        this.m_properties.put("jspwiki", jspwiki);
        PropertiesMap log4j = new PropertiesMap(new File(path, "/WEB-INF/classes/log4j.properties"));
        log4j.load();
        this.m_properties.put("log4j", log4j);
        PropertiesMap priha = new PropertiesMap(new File(path, "/WEB-INF/classes/priha.properties"));
        priha.load();
        this.m_properties.put("priha", priha);
        this.m_logDirectory = log4j.get(CONFIG_LOG_FILE);
        if (this.m_logDirectory == null) {
            this.m_logDirectory = System.getProperty("java.io.tmpdir");
        }
        if ((logs = new File(this.m_logDirectory)).exists() && !logs.isDirectory() && (logs = logs.getParentFile()) == null) {
            logs = new File(System.getProperty("java.io.tmpdir"));
        }
        this.m_logDirectory = logs.getAbsolutePath();
        this.initKeychain(path, jspwiki);
        if (!jspwiki.containsKey(CONFIG_BASE_URL) || jspwiki.get(CONFIG_BASE_URL).trim().length() == 0) {
            jspwiki.put(CONFIG_BASE_URL, "http://localhost:8080/JSPWiki/");
        }
        if (!jspwiki.containsKey(CONFIG_USERDATABASE)) {
            jspwiki.put(CONFIG_USERDATABASE, XMLUserDatabase.class.getName());
        }
        if (!jspwiki.containsKey(CONFIG_WORK_DIR)) {
            jspwiki.put(CONFIG_WORK_DIR, System.getProperty("java.io.tmpdir"));
        }
        if (!jspwiki.containsKey(CONFIG_LDAP_SSL)) {
            jspwiki.put(CONFIG_LDAP_SSL, "false");
        }
        if (!jspwiki.containsKey(CONFIG_ADMIN_PASSWORD_HASH)) {
            this.m_adminPassword = String.valueOf(TextUtil.generateRandomPassword()) + TextUtil.generateRandomPassword();
        }
        if (!priha.containsKey(CONFIG_PAGE_DIR)) {
            String pageDir = String.valueOf(this.sanitizeDir(System.getProperty("java.io.tmpdir"))) + "priha/fileprovider";
            priha.put(CONFIG_PAGE_DIR, pageDir);
        }
        return null;
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="install")
    @WikiRequestContext(value="install")
    public Resolution install() {
        return new TemplateResolution("admin/Install.jsp");
    }

    @HandlesEvent(value="save")
    public Resolution save() throws Exception {
        PropertiesMap<String, String> jspwiki = this.m_properties.get("jspwiki");
        jspwiki.put(CONFIG_BASE_URL, this.sanitizeURL(jspwiki.get(CONFIG_BASE_URL)));
        jspwiki.put(CONFIG_WORK_DIR, this.sanitizeDir(jspwiki.get(CONFIG_WORK_DIR)));
        PropertiesMap<String, String> log4j = this.m_properties.get("log4j");
        log4j.put(CONFIG_LOG_FILE, String.valueOf(this.sanitizeDir(this.m_logDirectory)) + "jspwiki.log");
        PropertiesMap<String, String> priha = this.m_properties.get("priha");
        priha.put(CONFIG_PAGE_DIR, this.sanitizeDir(priha.get(CONFIG_PAGE_DIR)));
        String userdatabase = jspwiki.get(CONFIG_USERDATABASE);
        if (LdapUserDatabase.class.getName().equals(userdatabase)) {
            jspwiki.put(CONFIG_AUTHORIZER, LdapAuthorizer.class.getName());
        } else {
            jspwiki.put(CONFIG_AUTHORIZER, WebContainerAuthorizer.class.getName());
        }
        String passwordHash = this.createAdminUser();
        jspwiki.put(CONFIG_ADMIN_PASSWORD_HASH, passwordHash);
        String password = jspwiki.get("jspwiki.keychainPassword");
        if (password == null) {
            throw new WikiSecurityException("Keychain password missing; this should not happen.");
        }
        this.m_keychain.store((OutputStream)new FileOutputStream(this.m_keychainPath), password.toCharArray());
        jspwiki.store();
        log4j.store();
        priha.store();
        this.getContext().getWikiSession().invalidate();
        WikiEngine engine = this.getContext().getEngine();
        engine.restart();
        return new TemplateResolution("admin/InstallSuccess.jsp");
    }

    private String createAdminUser() throws NoSuchAlgorithmException, WikiSecurityException {
        String passwordHash = CryptoUtil.getSaltedPassword(this.m_adminPassword.getBytes());
        UserManager userMgr = this.getContext().getEngine().getUserManager();
        UserDatabase userDb = userMgr.getUserDatabase();
        try {
            userDb.findByLoginName(PROP_ADMIN_ID);
        }
        catch (NoSuchPrincipalException e) {
            UserProfile profile = userDb.newProfile();
            profile.setLoginName(PROP_ADMIN_ID);
            profile.setFullname(PROP_ADMIN_NAME);
            profile.setPassword(this.m_adminPassword);
            userDb.save(profile);
        }
        GroupManager groupMgr = this.getContext().getEngine().getGroupManager();
        Group group = null;
        try {
            group = groupMgr.getGroup(PROP_ADMIN_GROUP);
            group.add(new WikiPrincipal(PROP_ADMIN_NAME));
        }
        catch (NoSuchPrincipalException e) {
            group = groupMgr.parseGroup(PROP_ADMIN_GROUP, PROP_ADMIN_NAME, true);
        }
        groupMgr.setGroup(this.getContext().getWikiSession(), group);
        return passwordHash;
    }

    @Validate(required=true, on={"save"}, minlength=16)
    public void setAdminPassword(String password) {
        this.m_adminPassword = password;
    }

    @Validate(required=false)
    public void setBindPassword(String password) throws KeyStoreException {
        this.m_bindPassword = password;
        if (password != null) {
            Keychain.Password keypass = new Keychain.Password(this.m_bindPassword);
            this.m_keychain.setEntry("ldap.bindPassword", (KeyStore.Entry)keypass);
        }
    }

    @Validate(required=true, on={"save"})
    public void setLogDirectory(String dir) {
        this.m_logDirectory = dir;
    }

    @ValidateNestedProperties(value={@Validate(field="jspwiki.jspwiki_applicationName", required=true, on={"save"}), @Validate(field="jspwiki.jspwiki_baseURL", required=true, on={"save"}), @Validate(field="priha.priha_provider_defaultProvider_directory", required=true, on={"save"}), @Validate(field="jspwiki.jspwiki_workDir", required=true, on={"save"}), @Validate(field="jspwiki.jspwiki_userdatabase", required=true, on={"save"}), @Validate(field="jspwiki.ldap_connectionURL", required=true, on={"testLdapConnection", "testLdapAuthentication", "testLdapUsers", "testLdapRoles"}), @Validate(field="jspwiki.ldap_bindUser", required=true, on={"testLdapAuthentication"}), @Validate(field="jspwiki.ldap_userBase", required=true, on={"testLdapUsers"}), @Validate(field="jspwiki.ldap_roleBase", required=true, on={"testLdapRoles"})})
    public void setProperties(Map<String, PropertiesMap<String, String>> properties) {
        this.m_properties = properties;
    }

    @AjaxEvent
    @HandlesEvent(value="testLdapAuthentication")
    public Resolution testLdapAuthentication() throws WikiSecurityException {
        return this.testLdapConnection();
    }

    @AjaxEvent
    @HandlesEvent(value="testLdapConnection")
    public Resolution testLdapConnection() throws WikiSecurityException {
        block2: {
            WikiActionBeanContext context = this.getContext();
            try {
                this.initLdapConnection();
                List messages = context.getMessages();
                messages.add(new SimpleMessage("Success!", new Object[0]));
            }
            catch (Exception e) {
                ValidationErrors errors = context.getValidationErrors();
                errors.addGlobalError((ValidationError)new SimpleError(e.getMessage(), new Object[0]));
                if (e.getCause() == null) break block2;
                errors.addGlobalError((ValidationError)new SimpleError(" Cause: " + e.getCause().getMessage(), new Object[0]));
            }
        }
        return new AjaxResolution(this.getContext());
    }

    @AjaxEvent
    @HandlesEvent(value="testLdapRoles")
    public Resolution testLdapRoleLookup() throws WikiSecurityException {
        block3: {
            WikiActionBeanContext context = this.getContext();
            PropertiesMap<String, String> jspwiki = this.m_properties.get("jspwiki");
            try {
                LdapAuthorizer authorizer = new LdapAuthorizer();
                authorizer.initialize(context.getEngine(), ((PropertiesMap)jspwiki).m_props);
                List messages = context.getMessages();
                Principal[] principals = authorizer.getRoles();
                messages.add(new SimpleMessage("Found " + principals.length + " roles.", new Object[0]));
                if (principals.length > 0) {
                    messages.add(new SimpleMessage("Details for first role...", new Object[0]));
                    messages.add(new SimpleMessage("Name: " + principals[0].getName(), new Object[0]));
                }
            }
            catch (Exception e) {
                ValidationErrors errors = context.getValidationErrors();
                errors.addGlobalError((ValidationError)new SimpleError("Error: " + e.getMessage(), new Object[0]));
                if (e.getCause() == null) break block3;
                errors.addGlobalError((ValidationError)new SimpleError(" Cause: " + e.getCause().getMessage(), new Object[0]));
            }
        }
        return new AjaxResolution(this.getContext());
    }

    @AjaxEvent
    @HandlesEvent(value="testLdapUsers")
    public Resolution testLdapUserLookup() {
        block3: {
            WikiActionBeanContext context = this.getContext();
            PropertiesMap<String, String> jspwiki = this.m_properties.get("jspwiki");
            try {
                LdapUserDatabase db = new LdapUserDatabase();
                db.initialize(context.getEngine(), ((PropertiesMap)jspwiki).m_props);
                List messages = context.getMessages();
                Principal[] principals = db.getWikiNames();
                messages.add(new SimpleMessage("Found " + principals.length + " users.", new Object[0]));
                if (principals.length > 0) {
                    UserProfile user = db.findByWikiName(principals[0].getName());
                    messages.add(new SimpleMessage("Details for first user...", new Object[0]));
                    messages.add(new SimpleMessage("Uid: " + user.getUid(), new Object[0]));
                    messages.add(new SimpleMessage("Login name: " + user.getLoginName(), new Object[0]));
                    messages.add(new SimpleMessage("Full name: " + user.getFullname(), new Object[0]));
                    messages.add(new SimpleMessage("Wiki name: " + user.getWikiName(), new Object[0]));
                    messages.add(new SimpleMessage("E-mail: " + user.getEmail(), new Object[0]));
                }
            }
            catch (Exception e) {
                ValidationErrors errors = context.getValidationErrors();
                errors.addGlobalError((ValidationError)new SimpleError(e.getMessage(), new Object[0]));
                if (e.getCause() == null) break block3;
                errors.addGlobalError((ValidationError)new SimpleError(" Cause: " + e.getCause().getMessage(), new Object[0]));
            }
        }
        return new AjaxResolution(this.getContext());
    }

    private void initKeychain(String path, PropertiesMap<String, String> jspwiki) throws IOException, NoSuchAlgorithmException {
        AuthenticationManager authMgr = this.getContext().getEngine().getAuthenticationManager();
        this.m_keychain = authMgr.getKeychain();
        boolean keychainUnlocked = false;
        String password = null;
        if (!this.m_keychain.isLoaded() && (password = jspwiki.get("jspwiki.keychainPassword")) != null) {
            try {
                authMgr.unlockKeychain(password);
                keychainUnlocked = true;
            }
            catch (WikiSecurityException wikiSecurityException) {
                // empty catch block
            }
        }
        if (!keychainUnlocked) {
            password = String.valueOf(TextUtil.generateRandomPassword()) + TextUtil.generateRandomPassword();
            this.m_keychain.load(null, password.toCharArray());
        }
        jspwiki.put("jspwiki.keychainPath", "keychain");
        jspwiki.put("jspwiki.keychainPassword", password);
        this.m_keychainPath = new File(path, "/WEB-INF/keychain");
    }

    private LdapContext initLdapConnection() throws NamingException {
        Hashtable<String, String> env;
        PropertiesMap<String, String> jspwiki = this.m_properties.get("jspwiki");
        LdapConfig config = LdapConfig.getInstance(this.m_keychain, ((PropertiesMap)jspwiki).m_props, new String[0]);
        List messages = this.getContext().getMessages();
        if (!jspwiki.containsKey("ldap_bindUser")) {
            env = config.newJndiEnvironment();
            messages.add(new SimpleMessage("Binding as anonymous user.", new Object[0]));
        } else {
            String username = jspwiki.get("ldap_bindUser");
            env = config.newJndiEnvironment(username, this.m_bindPassword);
            String principal = env.get("java.naming.security.principal");
            messages.add(new SimpleMessage("Binding with principal: " + principal.toString(), new Object[0]));
        }
        return new InitialLdapContext(env, null);
    }

    private String sanitizeDir(String dir) {
        String s = dir;
        s = TextUtil.replaceString(s, "\\", "\\\\");
        if (!(s = s.trim()).endsWith("\\") || !s.endsWith("/")) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }

    private String sanitizeURL(String url) {
        String s = url;
        s = TextUtil.replaceString(s, "\\", "/");
        if (!(s = s.trim()).endsWith("/")) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesMap<K, V>
    implements Map<String, String> {
        private final File m_file;
        private final CommentedProperties m_props;
        private final Map<String, String> m_settings;
        private Map<String, String> m_escapedKeys = new HashMap<String, String>();

        private static String escapedKey(String key) {
            String escapedKey = key.replace(".", "_");
            return escapedKey;
        }

        public PropertiesMap(File file) {
            this.m_file = file;
            this.m_props = new CommentedProperties();
            this.m_settings = new HashMap<String, String>();
        }

        @Override
        public void clear() {
            this.m_settings.clear();
            this.m_props.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m_settings.containsKey(key.toString());
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m_settings.containsValue(value.toString());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.m_settings.entrySet();
        }

        @Override
        public String get(Object key) {
            return this.m_settings.get(key.toString());
        }

        public String getPath() {
            return this.m_file.getAbsolutePath();
        }

        @Override
        public boolean isEmpty() {
            return this.m_settings.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.m_settings.keySet();
        }

        public void load() throws IOException {
            FileInputStream in = new FileInputStream(this.m_file);
            try {
                this.m_props.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            for (Map.Entry<Object, Object> entry : this.m_props.entrySet()) {
                String key = entry.getKey().toString();
                String escapedKey = PropertiesMap.escapedKey(key);
                Object value = entry.getValue();
                this.m_settings.put(escapedKey, value == null ? null : value.toString());
                this.m_escapedKeys.put(escapedKey, key);
            }
        }

        @Override
        public String put(String key, String value) {
            String unescapedKey = this.unescapedKey(key);
            this.m_props.setProperty(unescapedKey, value);
            return this.m_settings.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public String remove(Object key) {
            this.m_props.remove(this.unescapedKey(key.toString()));
            return this.m_settings.remove(key);
        }

        @Override
        public int size() {
            return this.m_settings.size();
        }

        public void store() throws IOException {
            FileOutputStream out = new FileOutputStream(this.m_file);
            try {
                this.m_props.store(out, null);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        public String toString() {
            return this.m_props.toString();
        }

        @Override
        public Collection<String> values() {
            return this.m_settings.values();
        }

        private String unescapedKey(String key) {
            if (this.m_escapedKeys.containsKey(key)) {
                return this.m_escapedKeys.get(key);
            }
            String unescapedKey = key.replace("_", ".");
            this.m_escapedKeys.put(key, unescapedKey);
            return unescapedKey;
        }
    }
}

