/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.action.LoginActionBean;
import org.apache.wiki.action.MessageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.LineDelimitedTypeConverter;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/Group.jsp")
public class GroupActionBean
extends AbstractActionBean {
    private static final String DEFAULT_NEW_GROUP_NAME = "MyGroup";
    private static final Comparator<? super Principal> PRINCIPAL_COMPARATOR = new PrincipalComparator();
    private Group m_group = null;
    private static Logger log = LoggerFactory.getLogger(GroupActionBean.class);
    private List<Principal> m_members = new ArrayList<Principal>();

    @Before(stages={LifecycleStage.CustomValidation})
    public Resolution checkSavePermission() {
        String handler = this.getContext().getEventName();
        if (!"save".equals(handler)) {
            return null;
        }
        Permission permission = this.isNew() ? new WikiPermission("*", "createGroups") : new GroupPermission("*:" + this.m_group.getName(), "edit");
        WikiSession session = this.getContext().getWikiSession();
        AuthorizationManager mgr = this.getContext().getEngine().getAuthorizationManager();
        boolean allowed = mgr.checkPermission(session, permission);
        RedirectResolution r = null;
        if (!allowed) {
            r = new RedirectResolution(LoginActionBean.class);
            r.includeRequestParameters(true);
            if (log.isDebugEnabled()) {
                log.debug("CheckSavePermission rejected access to ActionBean=" + this.getClass().getCanonicalName() + ", method=" + handler, new Object[0]);
            }
        }
        return r;
    }

    @HandlesEvent(value="create")
    @HandlerPermission(permissionClass=WikiPermission.class, target="*", actions="createGroups")
    @WikiRequestContext(value="createGroup")
    public Resolution create() {
        String groupName = this.m_group == null ? DEFAULT_NEW_GROUP_NAME : this.m_group.getName();
        TemplateResolution r = new TemplateResolution("EditGroup.jsp");
        r.addParameter("group", new Object[]{groupName});
        r.addParameter("members", new Object[]{this.getContext().getWikiSession().getUserPrincipal()});
        return r;
    }

    @HandlesEvent(value="delete")
    @HandlerPermission(permissionClass=GroupPermission.class, target="${group.name}", actions="delete")
    @WikiRequestContext(value="deleteGroup")
    public Resolution delete() throws StripesRuntimeException {
        try {
            WikiEngine engine = this.getContext().getEngine();
            GroupManager groupMgr = engine.getGroupManager();
            groupMgr.removeGroup(this.m_group.getName());
        }
        catch (WikiSecurityException e) {
            throw new StripesRuntimeException((Throwable)e);
        }
        return new RedirectResolution(ViewActionBean.class);
    }

    @HandlesEvent(value="edit")
    @HandlerPermission(permissionClass=GroupPermission.class, target="${group.name}", actions="edit")
    @WikiRequestContext(value="editGroup")
    public Resolution edit() {
        return new TemplateResolution("EditGroup.jsp").addParameter("group", new Object[]{this.m_group.getName()});
    }

    public Group getGroup() {
        return this.m_group;
    }

    public List<Principal> getMembers() {
        return this.m_members;
    }

    public boolean isNew() {
        if (this.m_group == null) {
            return true;
        }
        GroupManager mgr = this.getContext().getEngine().getGroupManager();
        try {
            mgr.getGroup(this.m_group.getName());
            return false;
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            return true;
        }
    }

    @HandlesEvent(value="save")
    public Resolution save() throws WikiSecurityException {
        GroupManager mgr = this.getContext().getEngine().getGroupManager();
        mgr.setGroup(this.getContext().getWikiSession(), this.m_group);
        return new RedirectResolution(GroupActionBean.class, "view").addParameter("group", new Object[]{this.m_group.getName()});
    }

    @Validate(required=true, on={"view,edit,delete,save"})
    public void setGroup(Group group) {
        this.m_group = group;
        this.m_members.clear();
        Principal[] principalArray = group.members();
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal member = principalArray[n2];
            this.m_members.add(member);
            ++n2;
        }
    }

    @Validate(required=true, on={"save"}, converter=LineDelimitedTypeConverter.class)
    public void setMembers(List<Principal> members) {
        this.m_members = members;
        Collections.sort(this.m_members, PRINCIPAL_COMPARATOR);
        this.m_group.clear();
        for (Principal member : members) {
            this.m_group.add(member);
        }
    }

    @ValidationMethod(on={"save"}, when=ValidationState.NO_ERRORS)
    public void validateIsLegalName(ValidationErrors errors) {
        String name = this.m_group.getName();
        if (Role.isReservedName(name)) {
            errors.add("group", (ValidationError)new LocalizableError("editgroup.illegalname", new Object[0]));
        }
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="view")
    @HandlerPermission(permissionClass=GroupPermission.class, target="${group.name}", actions="view")
    @WikiRequestContext(value="group")
    public Resolution view() {
        GroupManager mgr = this.getContext().getEngine().getGroupManager();
        if (this.m_group != null && mgr.findRole(this.m_group.getName()) != null) {
            return new TemplateResolution("Group.jsp");
        }
        ValidationErrors errors = this.getContext().getValidationErrors();
        List fieldErrors = (List)errors.get((Object)"group");
        if (fieldErrors != null) {
            for (ValidationError fieldError : fieldErrors) {
                LocalizableError error;
                if (!(fieldError instanceof LocalizableError) || !"editgroup.illegalname".equals((error = (LocalizableError)fieldError).getMessageKey())) continue;
                return new ForwardResolution(MessageActionBean.class, "error");
            }
        }
        if (this.m_group == null) {
            int suffix = 1;
            while (mgr.findRole("Group" + suffix) != null) {
                ++suffix;
            }
            try {
                this.m_group = mgr.getGroup("Group" + suffix, true);
            }
            catch (Exception e) {
                return new RedirectResolution(MessageActionBean.class, "error").flash((ActionBean)this);
            }
        }
        return new RedirectResolution(GroupActionBean.class, "create").addParameter("group", new Object[]{this.m_group.getName()});
    }
}

