/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import org.apache.commons.lang.time.StopWatch;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.AjaxResolution;

public class EditDialogActionBean
extends AbstractActionBean {
    private static final Logger log = LoggerFactory.getLogger(EditDialogActionBean.class);

    @DefaultHandler
    @HandlesEvent(value="suggestions")
    public Resolution suggestions(String wikiName, int maxLength) {
        StopWatch sw = new StopWatch();
        sw.start();
        ArrayList<String> list = new ArrayList<String>(maxLength);
        if (wikiName.length() > 0) {
            Set<String> allPages;
            String filename = "";
            int pos = wikiName.indexOf("/");
            if (pos >= 0) {
                filename = wikiName.substring(pos).toLowerCase();
                wikiName = wikiName.substring(0, pos);
            }
            String cleanWikiName = String.valueOf(MarkupParser.cleanLink(wikiName).toLowerCase()) + filename;
            String oldStyleName = String.valueOf(MarkupParser.wikifyLink(wikiName).toLowerCase()) + filename;
            try {
                allPages = this.getContext().getEngine().getReferenceManager().findCreated();
            }
            catch (ProviderException e) {
                allPages = new TreeSet<String>();
            }
            int counter = 0;
            Iterator<String> i = allPages.iterator();
            while (i.hasNext() && counter < maxLength) {
                String p = i.next();
                String pp = p.toLowerCase();
                if (!pp.startsWith(cleanWikiName) && !pp.startsWith(oldStyleName)) continue;
                list.add(p);
                ++counter;
            }
        }
        sw.stop();
        if (log.isDebugEnabled()) {
            log.debug("Suggestion request for " + wikiName + " done in " + sw, new Object[0]);
        }
        return new AjaxResolution(this.getContext(), list);
    }
}

