/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.HttpCache;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.lock.PageLock;
import org.apache.wiki.filters.RedirectException;
import org.apache.wiki.htmltowiki.HtmlStringToWikiTranslator;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.ui.stripes.AjaxEvent;
import org.apache.wiki.ui.stripes.AjaxResolution;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.SpamProtect;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HttpCache(allow=false)
@UrlBinding(value="/Edit.jsp")
public class EditActionBean
extends AbstractPageActionBean {
    private static final String LOCK_PREFIX = "lock-";
    private static final Logger log = LoggerFactory.getLogger(EditActionBean.class);
    private String m_author = null;
    private String m_wikiText = null;
    private String m_changenote = null;
    private boolean m_append = false;
    private boolean m_overrideConflict = false;
    private Map<String, Boolean> m_options = new HashMap<String, Boolean>();
    private String m_conflictText = null;
    private String m_htmlText = null;
    private String m_email = null;
    private long m_startTime = -1L;

    @AjaxEvent
    @HandlesEvent(value="preview")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    @WikiRequestContext(value="preview")
    public Resolution preview() throws IOException {
        WikiActionBeanContext context = this.getContext();
        RenderingManager renderer = context.getEngine().getRenderingManager();
        MarkupParser mp = renderer.getParser(context, this.m_wikiText);
        mp.disableAccessRules();
        WikiDocument doc = mp.parse();
        String result = renderer.getHTML((WikiContext)context, doc);
        AjaxResolution r = new AjaxResolution(context, result);
        return r;
    }

    @DontValidate
    @HandlesEvent(value="cancel")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="edit")
    @WikiRequestContext(value="cancel")
    public Resolution cancel() {
        WikiPage page = this.getPage();
        String pagereq = page.getName();
        log.debug("Cancelled editing " + pagereq, new Object[0]);
        HttpSession session = this.getContext().getRequest().getSession();
        WikiEngine engine = this.getContext().getEngine();
        PageLock lock = (PageLock)session.getAttribute(LOCK_PREFIX + pagereq);
        engine.getContentManager().unlockPage(lock);
        session.removeAttribute(LOCK_PREFIX + pagereq);
        return new RedirectResolution(ViewActionBean.class).addParameter("page", new Object[]{pagereq});
    }

    @HandlesEvent(value="comment")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="comment")
    @WikiRequestContext(value="comment")
    public Resolution comment() throws ProviderException {
        this.m_append = true;
        this.initEditFields("Commenting on");
        return new TemplateResolution("Comment.jsp");
    }

    @DefaultHandler
    @HandlesEvent(value="edit")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="edit")
    @WikiRequestContext(value="edit")
    public Resolution edit() throws ProviderException {
        this.setWikiText(this.getPage().getContentAsString());
        this.initEditFields("Editing");
        WikiActionBeanContext context = this.getContext();
        EditorManager editors = context.getEngine().getEditorManager();
        return new TemplateResolution(editors.getEditorPath(context));
    }

    public boolean getAppend() {
        return this.m_append;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getChangenote() {
        return this.m_changenote;
    }

    public String getConflictText() {
        return this.m_conflictText;
    }

    public String getHtmlPageText() {
        return this.m_htmlText;
    }

    public String getEmail() {
        return this.m_email;
    }

    public Map<String, Boolean> getOptions() {
        return this.m_options;
    }

    public boolean getOverrideConflict() {
        return this.m_overrideConflict;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public String getWikiText() {
        return this.m_wikiText;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void initDefaultValues() {
        UserManager mgr;
        UserProfile profile;
        WikiSession wikiSession = this.getContext().getWikiSession();
        Principal principal = wikiSession.getUserPrincipal();
        if (wikiSession.isAuthenticated()) {
            this.m_author = TextUtil.replaceEntities(principal.getName());
        } else if (this.m_author == null) {
            this.setAuthor(principal.getName());
            if (principal instanceof WikiPrincipal && "ipAddress".equals(((WikiPrincipal)principal).getType())) {
                this.setAuthor("Anonymous");
            }
        }
        if (wikiSession.isAuthenticated() && (profile = (mgr = this.getContext().getEngine().getUserManager()).getUserProfile(wikiSession)).getEmail() != null && profile.getEmail().length() > 0) {
            this.setEmail(profile.getEmail());
        }
    }

    @ValidationMethod(on={"edit,comment"}, when=ValidationState.ALWAYS)
    public void validateNoLocks() throws ProviderException {
        WikiPage latest;
        WikiPage page = this.getPage();
        WikiActionBeanContext wikiContext = this.getContext();
        ValidationErrors errors = this.getContext().getValidationErrors();
        WikiEngine engine = wikiContext.getEngine();
        ContentManager mgr = engine.getContentManager();
        PageLock lock = mgr.getCurrentLock(page);
        if (lock != null && !lock.getLocker().equals(wikiContext.getCurrentUser().getName())) {
            errors.addGlobalError((ValidationError)new LocalizableError("edit.locked", new Object[]{lock.getLocker(), lock.getTimeLeft()}));
        }
        try {
            latest = engine.getPage(page.getName());
        }
        catch (PageNotFoundException e) {
            latest = page;
        }
        if (latest.getVersion() != page.getVersion()) {
            errors.addGlobalError((ValidationError)new LocalizableError("edit.restoring", new Object[]{page.getVersion()}));
        }
    }

    @ValidationMethod(on={"save"}, when=ValidationState.NO_ERRORS)
    public void validateNoConflicts() throws ProviderException {
        URI uri;
        long lastModified;
        ValidationErrors errors = this.getContext().getValidationErrors();
        WikiPage page = this.getPage();
        boolean exists = this.getContext().getEngine().pageExists(page);
        long l = lastModified = exists ? page.getLastModified().getTime() : -1L;
        if (!this.m_overrideConflict && exists && this.m_startTime < lastModified) {
            String conflictText = page.getContentAsString();
            conflictText = StringEscapeUtils.escapeXml((String)conflictText);
            conflictText = TextUtil.replaceString(conflictText, "\n", "<br />");
            this.setConflictText(conflictText);
            errors.add("text", (ValidationError)new LocalizableError("edit.conflict", new Object[0]));
        }
        if ((uri = this.getContext().getEngine().getSpecialPageReference(page.getName())) != null) {
            errors.add("page", (ValidationError)new LocalizableError("edit.specialpage", new Object[0]));
        }
    }

    @HandlesEvent(value="save")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="edit")
    @WikiRequestContext(value="save")
    @SpamProtect(content={"wikiText"})
    public Resolution save() throws WikiException {
        WikiSession wikiSession = this.getContext().getWikiSession();
        HttpServletRequest request = this.getContext().getHttpRequest();
        HttpSession session = request.getSession();
        WikiActionBeanContext wikiContext = this.getContext();
        WikiPage page = this.getPage();
        WikiEngine engine = this.getContext().getEngine();
        String pagereq = page.getName();
        log.info("Saving page " + page.getName() + ". UserPrincipal=" + wikiSession.getUserPrincipal().getName() + ", Author=" + this.m_author + ", Host=" + this.getContext().getRequest().getRemoteAddr(), new Object[0]);
        page.setAuthor(this.m_author);
        if (this.m_changenote != null) {
            page.setAttribute("changenote", (Serializable)((Object)this.m_changenote));
        } else {
            page.setAttribute("changenote", (Serializable)((Object)""));
        }
        try {
            if (this.m_append) {
                StringBuffer pageText = new StringBuffer(engine.getText(pagereq));
                if (pageText.length() > 0) {
                    pageText.append("\n\n----\n\n");
                }
                pageText.append(this.m_wikiText);
                if (this.m_author != null && this.m_author.length() > 0) {
                    String signature = this.m_author;
                    if (this.m_email != null && this.m_email.length() > 0) {
                        String link = HttpUtil.guessValidURI(this.m_email);
                        signature = "[" + this.m_author + "|" + link + "]";
                    }
                    Calendar cal = Calendar.getInstance();
                    Preferences prefs = Preferences.getPreferences(request);
                    SimpleDateFormat fmt = prefs.getDateFormat(Preferences.TimeFormat.DATETIME);
                    pageText.append("\n\n--" + signature + ", " + fmt.format(cal.getTime()));
                }
                engine.saveText(wikiContext, pageText.toString());
            } else {
                engine.saveText(wikiContext, this.m_wikiText);
            }
            PageLock lock = (PageLock)session.getAttribute(LOCK_PREFIX + pagereq);
            engine.getContentManager().unlockPage(lock);
            session.removeAttribute(LOCK_PREFIX + page.getName());
        }
        catch (DecisionRequiredException ex) {
            PageLock lock = (PageLock)session.getAttribute(LOCK_PREFIX + pagereq);
            engine.getContentManager().unlockPage(lock);
            session.removeAttribute(LOCK_PREFIX + page.getName());
            return new RedirectResolution(ViewActionBean.class, "view").addParameter("page", new Object[]{"ApprovalRequiredForPageChanges"});
        }
        catch (RedirectException ex) {
            throw new WikiException("Strange redirection: " + ex.getMessage(), ex);
        }
        return new RedirectResolution(ViewActionBean.class, "view").addParameter("page", new Object[]{pagereq});
    }

    @Validate(required=true, encrypted=true, on={"save"})
    public void setAppend(boolean append) {
        this.m_append = append;
    }

    @Validate(required=false)
    public void setAuthor(String author) {
        WikiSession session = this.getContext().getWikiSession();
        if (!session.isAuthenticated()) {
            this.m_author = TextUtil.replaceEntities(author);
            HttpServletResponse response = this.getContext().getResponse();
            CookieAssertionLoginModule.setUserCookie(response, this.m_author);
        }
    }

    @Validate(required=false)
    public void setConflictText(String conflictText) {
        this.m_conflictText = conflictText;
    }

    @Validate(required=false)
    public void setChangenote(String changenote) {
        this.m_changenote = changenote;
    }

    @Validate(required=false)
    public void setHtmlPageText(String html) throws IOException, JDOMException {
        this.m_htmlText = html;
        this.m_wikiText = new HtmlStringToWikiTranslator().translate(html, this.getContext());
    }

    @Validate(required=false, converter=EmailTypeConverter.class)
    public void setEmail(String email) {
        WikiEngine engine;
        UserProfile profile;
        this.m_email = email;
        Cookie linkcookie = new Cookie("link", email);
        linkcookie.setMaxAge(86486400);
        this.getContext().getResponse().addCookie(linkcookie);
        WikiSession session = this.getContext().getWikiSession();
        if (session.isAuthenticated() && email.equals((profile = (engine = this.getContext().getEngine()).getUserManager().getUserProfile(session)).getEmail())) {
            LocalizableMessage message = new LocalizableMessage("changed.email", new Object[]{profile.getEmail(), email});
            this.getContext().getMessages().add(message);
        }
    }

    @Validate(required=false)
    public void setOptions(Map<String, Boolean> options) {
        this.m_options = options;
    }

    @Validate(required=false)
    public void setOverrideConflict(boolean override) {
        this.m_overrideConflict = override;
    }

    @Validate(required=true, encrypted=true, on={"save"})
    public void setStartTime(long time) {
        this.m_startTime = time;
    }

    @Validate(required=true, on={"save"})
    public void setWikiText(String text) {
        this.m_wikiText = text;
    }

    private void initEditFields(String logPrefix) {
        WikiActionBeanContext wikiContext = this.getContext();
        HttpServletRequest request = wikiContext.getRequest();
        Principal user = wikiContext.getCurrentUser();
        WikiPage page = this.getPage();
        String pageName = page.getName();
        log.info(String.valueOf(logPrefix) + " " + pageName + ". User=" + request.getRemoteUser() + ", host=" + request.getRemoteAddr(), new Object[0]);
        this.setStartTime(System.currentTimeMillis());
        ContentManager mgr = wikiContext.getEngine().getContentManager();
        PageLock lock = mgr.lockPage(page, user.getName());
        if (lock != null) {
            HttpSession session = request.getSession();
            session.setAttribute(LOCK_PREFIX + pageName, (Object)lock);
        }
    }
}

