/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/Diff.jsp")
public class DiffActionBean
extends AbstractPageActionBean {
    private int m_r1 = -1;
    private int m_r2 = -1;
    private String m_diffProvider = "TraditionalDiffProvider";

    public int getR2() {
        return this.m_r2;
    }

    public int getR1() {
        return this.m_r1;
    }

    @Validate(required=false)
    public void setR1(int r1) {
        this.m_r1 = r1;
    }

    @Validate(required=false)
    public void setR2(int r2) {
        this.m_r2 = r2;
    }

    @DontBind
    public String getDiffProvider() {
        return this.m_diffProvider;
    }

    @DefaultHandler
    @HandlesEvent(value="diff")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    @WikiRequestContext(value="diff")
    public Resolution diff() throws ProviderException, PageNotFoundException {
        int currentVersion;
        if (this.getR2() == -1 && (currentVersion = this.getPage().getVersion()) > 1) {
            this.setR2(currentVersion - 1);
        }
        WikiActionBeanContext c = this.getContext();
        this.m_diffProvider = c.getEngine().getVariable(c, "jspwiki.diffProvider");
        WikiPage page = this.getPage();
        if (page.isAttachment()) {
            return new TemplateResolution("AttachmentInfo.jsp");
        }
        return new TemplateResolution("PageInfo.jsp");
    }
}

