/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.BreadcrumbsTag;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.WikiRequestContext;

@UrlBinding(value="/Delete.jsp")
public class DeleteActionBean
extends AbstractPageActionBean {
    private static final Logger log = LoggerFactory.getLogger(DeleteActionBean.class);
    private int m_version = Integer.MIN_VALUE;

    @HandlesEvent(value="delete")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="delete")
    @WikiRequestContext(value="del")
    public Resolution delete() throws PageNotFoundException, ProviderException {
        String redirPage;
        WikiEngine engine = this.getContext().getEngine();
        WikiPage page = this.getPage();
        String path = page.getPath().toString();
        boolean isAttachment = page.isAttachment();
        if (this.m_version == Integer.MIN_VALUE) {
            HttpServletRequest request = this.getContext().getRequest();
            log.info("Deleting page " + path + ". User=" + request.getRemoteUser() + ", host=" + request.getRemoteAddr(), new Object[0]);
            engine.deletePage(path.toString());
            BreadcrumbsTag.deleteFromBreadCrumb(request, path);
        } else {
            WikiPage p = engine.getPage(path, this.m_version);
            log.debug("Deleting page=" + path + ", version=" + this.m_version, new Object[0]);
            engine.deleteVersion(p);
        }
        if (isAttachment) {
            redirPage = page.getParent().getName();
            return new RedirectResolution(ViewActionBean.class, "attachments").addParameter("page", new Object[]{redirPage});
        }
        redirPage = engine.pageExists(path) ? path : engine.getFrontPage();
        return new RedirectResolution(ViewActionBean.class, "view").addParameter("page", new Object[]{redirPage});
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    @ValidationMethod(when=ValidationState.ALWAYS)
    public void validateBeforeDelete() throws PageNotFoundException, ProviderException {
        if (this.m_version == Integer.MIN_VALUE) {
            return;
        }
        WikiEngine engine = this.getContext().getEngine();
        if (engine.pageExists(this.getPage().getName(), this.m_version)) {
            this.setPage(engine.getPage(this.getPage().getName(), this.m_version));
            return;
        }
        ValidationErrors errors = this.getContext().getValidationErrors();
        errors.add("version", (ValidationError)new LocalizableError("version.invalid", new Object[0]));
    }
}

