/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/attach/{page}")
public class AttachmentActionBean
extends AbstractPageActionBean {
    private static final Logger log = LoggerFactory.getLogger(AttachmentActionBean.class);
    private List<FileBean> m_newAttachments;
    private String m_changeNote = null;
    private int m_version = -1;

    public int getVersion() {
        return this.m_version;
    }

    @Validate(required=false)
    public void setVersion(int version) {
        this.m_version = version;
    }

    public List<FileBean> getNewAttachments() {
        return this.m_newAttachments;
    }

    public void setNewAttachments(List<FileBean> newAttachments) {
        this.m_newAttachments = newAttachments;
    }

    @Validate(required=false)
    public void setChangenote(String changenote) {
        this.m_changeNote = changenote;
    }

    public String getChangenote() {
        return this.m_changeNote;
    }

    @HandlesEvent(value="upload")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="upload")
    @WikiRequestContext(value="upload")
    public Resolution upload() throws Exception {
        for (FileBean attachment : this.m_newAttachments) {
            if (attachment == null) continue;
            this.executeUpload(attachment);
            log.debug("Executed upload; " + this.m_newAttachments.size() + " attachments found.", new Object[0]);
        }
        return new RedirectResolution(ViewActionBean.class, "attachments").addParameter("page", new Object[]{this.getPage().getName()});
    }

    @DefaultHandler
    @HandlesEvent(value="download")
    @HandlerPermission(permissionClass=PagePermission.class, target="${page.path}", actions="view")
    @WikiRequestContext(value="download")
    public Resolution download() throws Exception {
        Attachment att = (Attachment)this.getPage();
        StreamingResolution r = new StreamingResolution(att.getContentType(), att.getContentAsStream());
        r.setFilename(att.getPath().getName());
        HttpServletResponse response = this.getContext().getResponse();
        if (att.getLastModified() != null) {
            response.addDateHeader("Last-Modified", att.getLastModified().getTime());
        }
        if (!att.isCacheable()) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-control", "no-cache");
        }
        if (att.getSize() >= 0L) {
            response.setContentLength((int)att.getSize());
        }
        if (log.isDebugEnabled()) {
            HttpServletRequest req = this.getContext().getRequest();
            String msg = "Attachment " + att.getFileName() + " sent to " + req.getRemoteUser() + " on " + req.getRemoteAddr();
            log.debug(msg, new Object[0]);
        }
        return r;
    }

    @ValidationMethod(on={"download"})
    public void validateDownloadedFile(ValidationErrors errors) {
        WikiPath path = this.getPage().getPath();
        ContentManager manager = this.getContext().getEngine().getContentManager();
        try {
            JCRWikiPage page = manager.getPage(path, this.m_version);
            if (!page.isAttachment()) {
                errors.add("download", (ValidationError)new LocalizableError("notAnAttachment", new Object[]{path.toString(), this.m_version}));
                return;
            }
        }
        catch (PageNotFoundException e) {
            errors.add("cantFindAttachment", (ValidationError)new LocalizableError(e.getMessage(), new Object[]{path.toString(), this.m_version}));
            return;
        }
        catch (ProviderException e) {
            errors.add("error", (ValidationError)new LocalizableError(e.getMessage(), new Object[]{path.toString(), this.m_version}));
            return;
        }
    }

    @ValidationMethod(on={"upload"})
    public void validateUploadedFileType(ValidationErrors errors) {
        AttachmentManager mgr = this.getContext().getEngine().getAttachmentManager();
        for (FileBean attachment : this.m_newAttachments) {
            if (attachment == null) continue;
            String filename = attachment.getFileName();
            try {
                filename = AttachmentManager.cleanFileName(filename);
            }
            catch (WikiException e) {
                errors.add("newAttachments", (ValidationError)new LocalizableError(e.getMessage(), new Object[]{filename}));
            }
            if (mgr.isFileTypeAllowed(filename)) continue;
            errors.add("newAttachments", (ValidationError)new LocalizableError("attach.bad.filetype", new Object[]{filename}));
        }
    }

    private boolean executeUpload(FileBean filebean) throws Exception {
        boolean created = false;
        WikiActionBeanContext context = this.getContext();
        WikiEngine engine = context.getEngine();
        AttachmentManager mgr = engine.getAttachmentManager();
        InputStream data = filebean.getInputStream();
        String filename = filebean.getFileName();
        filename = AttachmentManager.cleanFileName(filename);
        log.debug("file=" + filename, new Object[0]);
        Principal user = context.getCurrentUser();
        WikiPage page = context.getPage();
        WikiPage attachment = null;
        for (WikiPage currentAttachment : mgr.listAttachments(page)) {
            if (!filename.equals(currentAttachment.getPath().getName())) continue;
            attachment = (Attachment)currentAttachment;
        }
        if (attachment == null) {
            WikiPath path = WikiPath.valueOf(String.valueOf(page.getPath().toString()) + "/" + filename);
            attachment = engine.getContentManager().addPage(path, filebean.getContentType());
            created = true;
        }
        if (user != null) {
            attachment.setAuthor(user.getName());
        }
        if (this.m_changeNote != null && this.m_changeNote.length() > 0) {
            attachment.setAttribute("changenote", (Serializable)((Object)this.m_changeNote));
        }
        try {
            engine.getAttachmentManager().storeAttachment((Attachment)attachment, data);
        }
        catch (ProviderException pe) {
            throw new ProviderException(context.getBundle("CoreResources").getString(pe.getMessage()), pe);
        }
        long size = filebean.getSize();
        data.close();
        filebean.delete();
        log.info("User " + user + " uploaded attachment to " + this.getPage().getName() + " called " + filename + ", size " + size + " bytes.", new Object[0]);
        return created;
    }
}

