/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.ui.stripes.WikiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UrlBinding(value="/admin/Users.jsp")
public class AdministerProfilesActionBean
extends AbstractActionBean {
    private static Logger log = LoggerFactory.getLogger(AdministerProfilesActionBean.class);
    private String[] m_deleteLoginNames;
    private List<UserProfile> m_users;

    @ValidateNestedProperties(value={@Validate(field="loginName", required=true, minlength=3, maxlength=50), @Validate(field="password", required=true, minlength=6, maxlength=128), @Validate(field="fullName", required=true, minlength=3, maxlength=50), @Validate(field="wikiName", required=true, minlength=3, maxlength=50), @Validate(field="email", required=false, converter=EmailTypeConverter.class)})
    public String[] getDeleteLoginNames() {
        return this.m_deleteLoginNames;
    }

    public void setDeleteLoginNames(String[] deleteLoginNames) {
        this.m_deleteLoginNames = deleteLoginNames;
    }

    public List<UserProfile> getUsers() {
        return this.m_users;
    }

    public void setUsers(List<UserProfile> profiles) {
        this.m_users = profiles;
    }

    @HandlesEvent(value="save")
    @WikiRequestContext(value="adminProfiles")
    public Resolution saveChanges() throws WikiSecurityException {
        UserDatabase db = super.getContext().getEngine().getUserManager().getUserDatabase();
        for (UserProfile users : this.m_users) {
            UserProfile existingProfile;
            try {
                existingProfile = db.findByLoginName(users.getLoginName());
            }
            catch (NoSuchPrincipalException e) {
                existingProfile = this.getContext().getEngine().getUserManager().getUserDatabase().newProfile();
            }
            existingProfile.setLoginName(users.getLoginName());
            existingProfile.setFullname(users.getFullname());
            existingProfile.setEmail(users.getEmail());
            if (users.getPassword() != null && users.getPassword().length() > 0) {
                existingProfile.setPassword(users.getPassword());
            }
            db.save(existingProfile);
        }
        if (this.m_deleteLoginNames != null) {
            String[] stringArray = this.m_deleteLoginNames;
            int n = this.m_deleteLoginNames.length;
            int n2 = 0;
            while (n2 < n) {
                String loginName = stringArray[n2];
                try {
                    db.deleteByLoginName(loginName);
                }
                catch (NoSuchPrincipalException e) {
                    throw new WikiSecurityException(e.getMessage());
                }
                ++n2;
            }
        }
        return new TemplateResolution("admin/Admin.jsp").addParameter("tab", new Object[]{"users"});
    }

    @DefaultHandler
    @DontValidate
    @HandlesEvent(value="view")
    @HandlerPermission(permissionClass=AllPermission.class, target="*")
    public Resolution view() throws WikiSecurityException {
        UserDatabase db = this.getContext().getEngine().getUserManager().getUserDatabase();
        Principal[] wikiNames = db.getWikiNames();
        this.m_users = new ArrayList<UserProfile>();
        Principal[] principalArray = wikiNames;
        int n = wikiNames.length;
        int n2 = 0;
        while (n2 < n) {
            Principal wikiName = principalArray[n2];
            try {
                UserProfile user = db.findByWikiName(wikiName.getName());
                this.m_users.add(user);
            }
            catch (NoSuchPrincipalException e) {
                log.error("Could not find user with wikiName = " + wikiName.getName() + ". Is the database corrupted? ", new Object[0]);
            }
            ++n2;
        }
        return new TemplateResolution("admin/Users.jsp").addParameter("tab", new Object[]{"users"});
    }
}

