/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.auth.SecurityVerifier;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.ui.admin.AdminBean;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.TemplateResolution;
import org.apache.wiki.util.TextUtil;

@UrlBinding(value="/admin/Admin.jsp")
public class AdminActionBean
extends AbstractActionBean {
    private AdminBean m_bean = null;
    private SecurityVerifier m_securityVerifier = null;

    @HandlesEvent(value="security")
    @HandlerPermission(permissionClass=AllPermission.class, target="*")
    public Resolution security() {
        WikiEngine engine = this.getContext().getEngine();
        if (!TextUtil.isPositive(engine.getWikiProperties().getProperty("jspwiki-x.securityconfig.enable"))) {
            return new StreamingResolution("text/html"){

                public void stream(HttpServletResponse response) throws Exception {
                    PrintWriter out = response.getWriter();
                    out.print("<html><body><p>Security config is disabled.</p></body></html>");
                }
            };
        }
        this.m_securityVerifier = new SecurityVerifier(engine, this.getContext().getWikiSession());
        return new TemplateResolution("admin/tabs/Security.jsp").addParameter("tab", new Object[]{"security"});
    }

    public SecurityVerifier getVerifier() {
        return this.m_securityVerifier;
    }

    public AdminBean getBean() {
        return this.m_bean;
    }

    @Validate(required=true, on={"admin"})
    public void setBean(AdminBean bean) {
        this.m_bean = bean;
    }

    private boolean isAdminUiEnabled() {
        return true;
    }

    @DefaultHandler
    @HandlesEvent(value="view")
    @HandlerPermission(permissionClass=AllPermission.class, target="*")
    public Resolution view() {
        if (!this.isAdminUiEnabled()) {
            return new StreamingResolution("text/html"){

                public void stream(HttpServletResponse response) throws Exception {
                    PrintWriter out = response.getWriter();
                    out.print("<html><body><p>Admin UI is disabled.</p></body></html>");
                }
            };
        }
        if (this.getContext().getRequest().getParameter("tab") == null) {
            return new TemplateResolution("admin/Admin.jsp").addParameter("tab", new Object[]{"security"});
        }
        return new TemplateResolution("admin/Admin.jsp");
    }
}

