/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.action;

import java.util.Collections;
import java.util.List;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.validation.Validate;
import org.apache.wiki.action.AbstractActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.PageTimeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPageActionBean
extends AbstractActionBean {
    private List<WikiPage> m_attachments = null;
    private List<WikiPage> m_history = null;
    private PageTimeComparator HISTORY_COMPARATOR = new PageTimeComparator(PageTimeComparator.Order.DESCENDING);

    @DontBind
    public List<WikiPage> getAttachments() throws ProviderException {
        if (this.m_attachments == null) {
            AttachmentManager mgr = this.getContext().getEngine().getAttachmentManager();
            this.m_attachments = Collections.unmodifiableList(mgr.listAttachments(this.getPage()));
        }
        return this.m_attachments;
    }

    @DontBind
    public List<WikiPage> getHistory() throws ProviderException, PageNotFoundException {
        if (this.m_history == null) {
            List<WikiPage> history = this.getContext().getEngine().getVersionHistory(this.getPage().getName());
            Collections.sort(history, this.HISTORY_COMPARATOR);
            this.m_history = Collections.unmodifiableList(history);
        }
        return this.m_history;
    }

    public WikiPage getPage() {
        return this.getContext().getPage();
    }

    @Validate(required=true)
    public void setPage(WikiPage page) {
        this.getContext().setPage(page);
    }
}

