/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiSession
implements WikiEventListener {
    public static final String ANONYMOUS = "anonymous";
    public static final String ASSERTED = "asserted";
    public static final String AUTHENTICATED = "authenticated";
    private static final int ONE = 48;
    private static final int NINE = 57;
    private static final int DOT = 46;
    private static final Logger log = LoggerFactory.getLogger(WikiSession.class);
    private static final String ALL = "*";
    private static ThreadLocal<WikiSession> c_guestSession = new ThreadLocal();
    private final Subject m_subject = new Subject();
    private final Map<String, Set<String>> m_messages = new HashMap<String, Set<String>>();
    private WikiEngine m_engine = null;
    private String m_status = "anonymous";
    private Principal m_userPrincipal = WikiPrincipal.GUEST;
    private Principal m_loginPrincipal = WikiPrincipal.GUEST;
    private Locale m_cachedLocale = Locale.getDefault();

    protected final boolean isInGroup(Group group) {
        Principal[] principalArray = this.getPrincipals();
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal principal = principalArray[n2];
            if (this.isAuthenticated() && group.isMember(principal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private WikiSession() {
    }

    public final boolean isAsserted() {
        return this.m_subject.getPrincipals().contains(Role.ASSERTED);
    }

    public final boolean isAuthenticated() {
        if (this.m_subject.getPrincipals().contains(Role.AUTHENTICATED)) {
            return true;
        }
        if (!this.isAnonymous() && !this.isAsserted()) {
            this.m_subject.getPrincipals().add(Role.AUTHENTICATED);
            return true;
        }
        return false;
    }

    public final boolean isAnonymous() {
        Set<Principal> principals = this.m_subject.getPrincipals();
        return principals.contains(Role.ANONYMOUS) || principals.contains(WikiPrincipal.GUEST) || WikiSession.isIPV4Address(this.getUserPrincipal().getName());
    }

    public final Principal getLoginPrincipal() {
        return this.m_loginPrincipal;
    }

    public final Principal getUserPrincipal() {
        return this.m_userPrincipal;
    }

    public final Locale getLocale() {
        return this.m_cachedLocale;
    }

    public final void addMessage(String message) {
        this.addMessage(ALL, message);
    }

    public final void addMessage(String topic, String message) {
        Set<String> messages;
        if (topic == null) {
            throw new IllegalArgumentException("addMessage: topic cannot be null.");
        }
        if (message == null) {
            message = "";
        }
        if ((messages = this.m_messages.get(topic)) == null) {
            messages = new LinkedHashSet<String>();
            this.m_messages.put(topic, messages);
        }
        messages.add(message);
    }

    public final void clearMessages() {
        this.m_messages.clear();
    }

    public final void clearMessages(String topic) {
        Set<String> messages = this.m_messages.get(topic);
        if (messages != null) {
            this.m_messages.clear();
        }
    }

    public final String[] getMessages() {
        return this.getMessages(ALL);
    }

    public final String[] getMessages(String topic) {
        Set<String> messages = this.m_messages.get(topic);
        if (messages == null || messages.size() == 0) {
            return new String[0];
        }
        return messages.toArray(new String[messages.size()]);
    }

    public final Principal[] getPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (Principal principal : this.m_subject.getPrincipals()) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            principals.add(principal);
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public final Principal[] getRoles() {
        HashSet<Principal> roles = new HashSet<Principal>();
        roles.addAll(this.m_subject.getPrincipals(Role.class));
        roles.addAll(this.m_subject.getPrincipals(GroupPrincipal.class));
        Principal[] roleArray = roles.toArray(new Principal[roles.size()]);
        Arrays.sort(roleArray, WikiPrincipal.COMPARATOR);
        return roleArray;
    }

    public static final void removeWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (engine == null || request == null) {
            throw new IllegalArgumentException("Request or engine cannot be null.");
        }
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        monitor.remove(request.getSession());
    }

    public final boolean hasPrincipal(Principal principal) {
        return this.m_subject.getPrincipals().contains(principal);
    }

    @Override
    public final void actionPerformed(WikiEvent event) {
        WikiSecurityEvent e;
        if (event instanceof WikiSecurityEvent && (e = (WikiSecurityEvent)event).getTarget() != null) {
            switch (e.getType()) {
                case 46: {
                    Group group = (Group)e.getTarget();
                    if (!this.isInGroup(group)) break;
                    this.m_subject.getPrincipals().add(group.getPrincipal());
                    break;
                }
                case 47: {
                    Group group = (Group)e.getTarget();
                    if (!this.m_subject.getPrincipals().contains(group.getPrincipal())) break;
                    this.m_subject.getPrincipals().remove(group.getPrincipal());
                    break;
                }
                case 48: {
                    this.m_subject.getPrincipals().removeAll(this.m_subject.getPrincipals(GroupPrincipal.class));
                    break;
                }
                case 30: 
                case 35: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target) || this.m_status != AUTHENTICATED) break;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    principals.add((Principal)e.getPrincipal());
                    break;
                }
                case 31: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = ANONYMOUS;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.ANONYMOUS);
                    break;
                }
                case 32: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = ASSERTED;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.ASSERTED);
                    break;
                }
                case 40: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = AUTHENTICATED;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.AUTHENTICATED);
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
                case 53: {
                    WikiSession source = (WikiSession)e.getSource();
                    if (!this.equals(source)) break;
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
                case 54: {
                    WikiSession source = (WikiSession)e.getSource();
                    if (!this.equals(source) || this.m_status != AUTHENTICATED) break;
                    UserProfile[] profiles = (UserProfile[])e.getTarget();
                    UserProfile newProfile = profiles[1];
                    if (newProfile.getFullname() == null) {
                        throw new IllegalStateException("User profile FullName cannot be null.");
                    }
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_loginPrincipal = new WikiPrincipal(newProfile.getLoginName());
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.AUTHENTICATED);
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
            }
        }
    }

    public final void invalidate() {
        this.m_subject.getPrincipals().clear();
        this.m_subject.getPrincipals().add(WikiPrincipal.GUEST);
        this.m_subject.getPrincipals().add(Role.ANONYMOUS);
        this.m_subject.getPrincipals().add(Role.ALL);
        this.m_userPrincipal = WikiPrincipal.GUEST;
        this.m_loginPrincipal = WikiPrincipal.GUEST;
        GroupManager groupMgr = this.m_engine.getGroupManager();
        AuthenticationManager authMgr = this.m_engine.getAuthenticationManager();
        UserManager userMgr = this.m_engine.getUserManager();
        groupMgr.addWikiEventListener(this);
        authMgr.addWikiEventListener(this);
        userMgr.addWikiEventListener(this);
    }

    protected final void injectGroupPrincipals() {
        this.m_subject.getPrincipals().removeAll(this.m_subject.getPrincipals(GroupPrincipal.class));
        GroupManager manager = this.m_engine.getGroupManager();
        Principal[] principalArray = manager.getRoles();
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal group = principalArray[n2];
            if (manager.isUserInRole(this, group)) {
                this.m_subject.getPrincipals().add(group);
            }
            ++n2;
        }
    }

    protected final void injectUserProfilePrincipals() {
        String searchId = this.m_loginPrincipal.getName();
        if (searchId == null) {
            log.info("Refresh principals failed because WikiSession had no user Principal; maybe not logged in?", new Object[0]);
            return;
        }
        UserDatabase database = this.m_engine.getUserManager().getUserDatabase();
        if (database == null) {
            throw new IllegalStateException("User database cannot be null.");
        }
        try {
            Principal[] principals;
            UserProfile profile = database.find(searchId);
            Principal[] principalArray = principals = database.getPrincipals(profile.getLoginName());
            int n = principals.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isFullNamePrincipal;
                Principal principal = principalArray[n2];
                this.m_subject.getPrincipals().add(principal);
                boolean bl = isFullNamePrincipal = principal instanceof WikiPrincipal && ((WikiPrincipal)principal).getType() == "fullName";
                if (isFullNamePrincipal) {
                    this.m_userPrincipal = principal;
                } else if (!(this.m_userPrincipal instanceof WikiPrincipal)) {
                    this.m_userPrincipal = principal;
                }
                ++n2;
            }
        }
        catch (NoSuchPrincipalException e) {
            log.warn("User profile '" + searchId + "' not found. This is normal for container-auth users who haven't set up a profile yet.", new Object[0]);
        }
    }

    public final String getStatus() {
        return this.m_status;
    }

    public static final WikiSession getWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (request == null) {
            if (log.isDebugEnabled()) {
                log.debug("Looking up WikiSession for NULL HttpRequest: returning guestSession()", new Object[0]);
            }
            return WikiSession.staticGuestSession(engine);
        }
        HttpSession session = request.getSession();
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        WikiSession wikiSession = monitor.find(session);
        wikiSession.m_engine = engine;
        wikiSession.m_cachedLocale = request.getLocale();
        return wikiSession;
    }

    public static final WikiSession guestSession(WikiEngine engine) {
        WikiSession session = new WikiSession();
        session.m_engine = engine;
        session.invalidate();
        return session;
    }

    private static WikiSession staticGuestSession(WikiEngine engine) {
        WikiSession session = c_guestSession.get();
        if (session == null) {
            session = WikiSession.guestSession(engine);
            c_guestSession.set(session);
        }
        return session;
    }

    public static final int sessions(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.sessions();
    }

    public static final Principal[] userPrincipals(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.userPrincipals();
    }

    public static final Object doPrivileged(WikiSession session, PrivilegedAction<?> action) throws AccessControlException {
        return Subject.doAsPrivileged(session.m_subject, action, null);
    }

    protected static final boolean isIPV4Address(String name) {
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        int[] addr = new int[4];
        int currentOctet = 0;
        int i = 0;
        while (i < name.length()) {
            boolean isDot;
            char ch = name.charAt(i);
            boolean isDigit = ch >= '0' && ch <= '9';
            boolean bl = isDot = ch == '.';
            if (!isDigit && !isDot) {
                return false;
            }
            if (isDigit) {
                addr[currentOctet] = 10 * addr[currentOctet] + (ch - 48);
                if (addr[currentOctet] > 255) {
                    return false;
                }
            } else {
                if (name.charAt(i - 1) == '.') {
                    return false;
                }
                ++currentOctet;
            }
            ++i;
        }
        return currentOctet == 3;
    }
}

