/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.NoSuchVariableException;
import org.apache.wiki.PageManager;
import org.apache.wiki.Release;
import org.apache.wiki.VariableManager;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.WikiActionBean;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.api.FilterException;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.acl.DefaultAclManager;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.PageRenamer;
import org.apache.wiki.content.ReferenceManager;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.content.resolver.EnglishPluralsPageNameResolver;
import org.apache.wiki.content.resolver.PageNameResolver;
import org.apache.wiki.content.resolver.SpecialPageNameResolver;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.rss.RSSThread;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.admin.AdminBeanManager;
import org.apache.wiki.ui.progress.ProgressManager;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.ui.stripes.WikiInterceptor;
import org.apache.wiki.url.StripesURLConstructor;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PageTimeComparator;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.StringTransmutator;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.WatchDog;
import org.apache.wiki.util.WikiBackgroundThread;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;
import org.apache.wiki.workflow.WorkflowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiEngine {
    private static final String ATTR_WIKIENGINE = "org.apache.wiki.WikiEngine";
    private static final Logger log = LoggerFactory.getLogger(WikiEngine.class);
    private Properties m_properties;
    public static final String PROP_APPNAME = "jspwiki.applicationName";
    public static final String PROP_INTERWIKIREF = "jspwiki.interWikiRef.";
    public static final String PROP_STOREUSERNAME = "jspwiki.storeUserName";
    public static final String PROP_BASEURL = "jspwiki.baseURL";
    public static final String PROP_REFSTYLE = "jspwiki.referenceStyle";
    public static final String PROP_BEAUTIFYTITLE = "jspwiki.breakTitleWithSpaces";
    public static final String PROP_WORKDIR = "jspwiki.workDir";
    public static final String PREFS_COOKIE_NAME = "JSPWikiUserProfile";
    public static final String PROP_MATCHPLURALS = "jspwiki.translatorReader.matchEnglishPlurals";
    public static final String PROP_TEMPLATEDIR = "jspwiki.templateDir";
    public static final String PROP_FRONTPAGE = "jspwiki.frontPage";
    public static final String PROP_URLCONSTRUCTOR = "jspwiki.urlConstructor";
    public static final String PROP_RUNFILTERS = "jspwiki.runFilters";
    private PageRenamer m_pageRenamer = null;
    public static final String PROP_ACL_MANAGER_IMPL = "jspwiki.aclManager";
    public static final String PROP_ALLOW_CREATION_OF_EMPTY_PAGES = "jspwiki.allowCreationOfEmptyPages";
    private static final Comparator<WikiPage> PAGE_TIME_COMPARATOR = PageTimeComparator.DEFAULT_PAGETIME_COMPARATOR;
    private boolean m_saveUserInfo = true;
    private String m_baseURL;
    private String m_rootPath = System.getProperty("user.dir");
    private ReferenceManager m_referenceManager = null;
    private PluginManager m_pluginManager;
    private VariableManager m_variableManager;
    private AttachmentManager m_attachmentManager = null;
    private PageManager m_pageManager = null;
    private AuthorizationManager m_authorizationManager = null;
    private AuthenticationManager m_authenticationManager = null;
    private AclManager m_aclManager = null;
    private ContentManager m_contentManager;
    private WikiContextFactory m_contextFactory = null;
    private TemplateManager m_templateManager = null;
    private DifferenceManager m_differenceManager;
    private FilterManager m_filterManager;
    private SearchManager m_searchManager = null;
    private UserManager m_userManager = null;
    private GroupManager m_groupManager = null;
    private RenderingManager m_renderingManager;
    private EditorManager m_editorManager;
    private InternationalizationManager m_internationalizationManager;
    private ProgressManager m_progressManager;
    private StripesURLConstructor m_urlConstructor;
    private RSSGenerator m_rssGenerator;
    private String m_rssFile;
    private ServletContext m_servletContext = null;
    private boolean m_beautifyTitle = false;
    private String m_templateDir;
    private String m_frontPage;
    private Date m_startTime;
    private String m_workDir;
    private String m_appid = "";
    private String[] m_spaces;
    private boolean m_isConfigured = false;
    private List<PageNameResolver> m_nameResolvers = new ArrayList<PageNameResolver>();
    private SpecialPageNameResolver m_specialPageResolver;
    private WorkflowManager m_workflowMgr = null;
    private AdminBeanManager m_adminBeanManager;
    private Map<String, Object> m_attributes = Collections.synchronizedMap(new HashMap());

    public static synchronized WikiEngine getInstance(ServletConfig config) throws InternalWikiException {
        return WikiEngine.getInstance(config.getServletContext(), null);
    }

    public static synchronized WikiEngine getInstance(ServletConfig config, Properties props) {
        return WikiEngine.getInstance(config.getServletContext(), props);
    }

    public static synchronized WikiEngine getInstance(ServletContext context, Properties props) throws InternalWikiException {
        WikiEngine engine = (WikiEngine)context.getAttribute(ATTR_WIKIENGINE);
        if (engine == null) {
            String appid = Integer.toString(context.hashCode());
            context.log(" Assigning new engine to " + appid);
            try {
                if (props == null) {
                    props = PropertyReader.loadWebAppProps(context);
                }
                engine = new WikiEngine(context, appid, props);
                context.setAttribute(ATTR_WIKIENGINE, (Object)engine);
            }
            catch (Exception e) {
                context.log("ERROR: Failed to create a Wiki engine: " + e.getMessage());
                throw new InternalWikiException("No wiki engine, check logs.");
            }
        }
        return engine;
    }

    public WikiEngine(Properties properties) throws WikiException {
        try {
            this.initialize(properties);
        }
        catch (WikiException e) {
            this.shutdown();
            throw e;
        }
    }

    protected WikiEngine(ServletContext context, String appid, Properties props) throws WikiException {
        this.m_servletContext = context;
        this.m_appid = appid;
        if (context != null) {
            context.setAttribute(ATTR_WIKIENGINE, (Object)this);
            this.m_rootPath = context.getRealPath("/");
        }
        try {
            this.initialize(props);
            if (this.m_rootPath == null) {
                log.warn("Root path for this Wiki is null. This is normal if deployed as a WAR or executed in mock context.", new Object[0]);
            } else {
                log.info("Root path for this Wiki is: '" + this.m_rootPath + "'", new Object[0]);
            }
        }
        catch (Exception e) {
            String msg = "JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage();
            if (context != null) {
                context.log(msg);
            }
            this.shutdown();
            throw new WikiException(msg, e);
        }
    }

    private void initialize(Properties props) throws WikiException {
        this.m_startTime = new Date();
        this.m_properties = props;
        LoggerFactory.initialize(this.m_properties.getProperty(PROP_APPNAME));
        log.info("*******************************************", new Object[0]);
        log.info("JSPWiki " + Release.getVersionString() + " starting. Whee!", new Object[0]);
        this.fireEvent(-1);
        log.debug("Java version: " + System.getProperty("java.runtime.version"), new Object[0]);
        log.debug("Java vendor: " + System.getProperty("java.vm.vendor"), new Object[0]);
        log.debug("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"), new Object[0]);
        log.debug("Default server locale: " + Locale.getDefault(), new Object[0]);
        log.debug("Default server timezone: " + TimeZone.getDefault().getDisplayName(true, 1), new Object[0]);
        if (this.m_servletContext != null) {
            log.info("Servlet container: " + this.m_servletContext.getServerInfo(), new Object[0]);
            if (this.m_servletContext.getMajorVersion() < 2 || this.m_servletContext.getMajorVersion() == 2 && this.m_servletContext.getMinorVersion() < 4) {
                throw new InternalWikiException("I require a container which supports at least version 2.4 of Servlet specification");
            }
        }
        log.debug("Configuring WikiEngine...", new Object[0]);
        this.m_workDir = TextUtil.getStringProperty(props, PROP_WORKDIR, null);
        if (this.m_workDir == null) {
            this.m_workDir = System.getProperty("java.io.tmpdir", ".");
            this.m_workDir = String.valueOf(this.m_workDir) + File.separator + "JSPWiki" + "-" + this.m_appid;
        }
        try {
            File f = new File(this.m_workDir);
            f.mkdirs();
            if (!f.exists()) {
                throw new WikiException("Work directory does not exist: " + this.m_workDir);
            }
            if (!f.canRead()) {
                throw new WikiException("No permission to read work directory: " + this.m_workDir);
            }
            if (!f.canWrite()) {
                throw new WikiException("No permission to write to work directory: " + this.m_workDir);
            }
            if (!f.isDirectory()) {
                throw new WikiException("jspwiki.workDir does not point to a directory: " + this.m_workDir);
            }
        }
        catch (SecurityException e) {
            log.error("Unable to find or create the working directory: " + this.m_workDir, e);
            throw new IllegalArgumentException("Unable to find or create the working dir: " + this.m_workDir);
        }
        log.info("JSPWiki working directory is '" + this.m_workDir + "'", new Object[0]);
        this.m_saveUserInfo = TextUtil.getBooleanProperty(props, PROP_STOREUSERNAME, this.m_saveUserInfo);
        this.m_baseURL = TextUtil.getStringProperty(props, PROP_BASEURL, "");
        if (!this.m_baseURL.endsWith("/")) {
            this.m_baseURL = String.valueOf(this.m_baseURL) + "/";
        }
        this.m_beautifyTitle = TextUtil.getBooleanProperty(props, PROP_BEAUTIFYTITLE, this.m_beautifyTitle);
        this.m_templateDir = TextUtil.getStringProperty(props, PROP_TEMPLATEDIR, "default");
        this.m_frontPage = TextUtil.getStringProperty(props, PROP_FRONTPAGE, "Main");
        this.m_spaces = new String[]{"Main"};
        try {
            this.m_urlConstructor = new StripesURLConstructor();
            this.m_urlConstructor.initialize(this, props);
            this.m_contextFactory = new WikiContextFactory(this, props);
            WikiBackgroundThread.registerTimer(this);
            this.m_specialPageResolver = new SpecialPageNameResolver(this);
            this.m_nameResolvers.add(this.m_specialPageResolver);
            this.m_nameResolvers.add(new EnglishPluralsPageNameResolver(this));
            this.m_contentManager = (ContentManager)ClassUtil.getMappedObject(ContentManager.class.getName(), this);
            this.m_pageManager = (PageManager)ClassUtil.getMappedObject(PageManager.class.getName(), this, props);
            this.m_pluginManager = (PluginManager)ClassUtil.getMappedObject(PluginManager.class.getName(), this, props);
            this.m_differenceManager = (DifferenceManager)ClassUtil.getMappedObject(DifferenceManager.class.getName(), this, props);
            this.m_attachmentManager = (AttachmentManager)ClassUtil.getMappedObject(AttachmentManager.class.getName(), this, props);
            this.m_variableManager = (VariableManager)ClassUtil.getMappedObject(VariableManager.class.getName(), props);
            this.m_renderingManager = (RenderingManager)ClassUtil.getMappedObject(RenderingManager.class.getName());
            this.m_authenticationManager = (AuthenticationManager)ClassUtil.getMappedObject(AuthenticationManager.class.getName());
            this.m_authorizationManager = (AuthorizationManager)ClassUtil.getMappedObject(AuthorizationManager.class.getName());
            this.m_userManager = (UserManager)ClassUtil.getMappedObject(UserManager.class.getName());
            this.m_groupManager = (GroupManager)ClassUtil.getMappedObject(GroupManager.class.getName());
            this.m_editorManager = (EditorManager)ClassUtil.getMappedObject(EditorManager.class.getName(), this);
            this.m_editorManager.initialize(props);
            this.m_progressManager = new ProgressManager();
            this.m_authenticationManager.initialize(this, props);
            this.m_authorizationManager.initialize(this, props);
            this.m_userManager.initialize(this, props);
            this.m_groupManager.initialize(this, props);
            this.m_aclManager = this.getAclManager();
            this.m_workflowMgr = (WorkflowManager)ClassUtil.getMappedObject(WorkflowManager.class.getName());
            this.m_workflowMgr.initialize(this, props);
            this.m_internationalizationManager = (InternationalizationManager)ClassUtil.getMappedObject(InternationalizationManager.class.getName(), this);
            this.m_templateManager = (TemplateManager)ClassUtil.getMappedObject(TemplateManager.class.getName(), this, props);
            this.m_adminBeanManager = (AdminBeanManager)ClassUtil.getMappedObject(AdminBeanManager.class.getName(), this);
            this.m_filterManager = (FilterManager)ClassUtil.getMappedObject(FilterManager.class.getName(), this, props);
            this.m_renderingManager.initialize(this, props);
            this.m_referenceManager = (ReferenceManager)ClassUtil.getMappedObject(ReferenceManager.class.getName());
            this.m_referenceManager.initialize(this, props);
            this.m_searchManager = (SearchManager)ClassUtil.getMappedObject(SearchManager.class.getName());
            this.m_searchManager.initialize(this, props);
        }
        catch (RuntimeException e) {
            log.error("Failed to start managers, stacktrace follows: ", e);
            throw new WikiException("Failed to start managers: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("JSPWiki could not start, due to an unknown exception while starting, stacktrace follows: ", e);
            throw new WikiException("Failed to start; please check log files for better information.", e);
        }
        try {
            if (TextUtil.getBooleanProperty(props, "jspwiki.rss.generate", false)) {
                this.m_rssGenerator = (RSSGenerator)ClassUtil.getMappedObject(RSSGenerator.class.getName(), this, props);
            }
            this.m_pageRenamer = (PageRenamer)ClassUtil.getMappedObject(PageRenamer.class.getName(), this, props);
        }
        catch (Exception e) {
            log.error("Unable to start RSS generator - JSPWiki will still work, but there will be no RSS feed.", e);
        }
        if (this.m_rssGenerator != null) {
            this.m_rssFile = TextUtil.getStringProperty(props, "jspwiki.rss.fileName", "rss.rdf");
            File rssFile = null;
            rssFile = this.m_rssFile.startsWith(File.separator) ? new File(this.m_rssFile) : new File(this.getRootPath(), this.m_rssFile);
            int rssInterval = TextUtil.getIntegerProperty(props, "jspwiki.rss.interval", 3600);
            RSSThread rssThread = new RSSThread(this, rssFile, rssInterval);
            rssThread.start();
        }
        this.fireEvent(0);
        log.info("WikiEngine configured.", new Object[0]);
        this.m_isConfigured = true;
    }

    public static String getRequiredProperty(Properties props, String key) throws NoRequiredPropertyException {
        String value = TextUtil.getStringProperty(props, key, null);
        if (value == null) {
            throw new NoRequiredPropertyException("Required property not found", key);
        }
        return value;
    }

    public Properties getWikiProperties() {
        return this.m_properties;
    }

    public String getWorkDir() {
        return this.m_workDir;
    }

    public String getPluginSearchPath() {
        return TextUtil.getStringProperty(this.m_properties, "jspwiki.plugin.searchPath", null);
    }

    public String getTemplateDir() {
        return this.m_templateDir;
    }

    public TemplateManager getTemplateManager() {
        return this.m_templateManager;
    }

    public String getBaseURL() {
        return this.m_baseURL;
    }

    public String[] getSpaces() {
        return this.m_spaces;
    }

    public Date getStartTime() {
        return (Date)this.m_startTime.clone();
    }

    public String getViewURL(String pageName) {
        if (pageName == null) {
            pageName = this.getFrontPage();
        }
        return this.getURLConstructor().makeURL(WikiContext.VIEW, pageName, true, null);
    }

    public String getEditURL(String pageName) {
        return this.m_urlConstructor.makeURL("edit", pageName, false, null);
    }

    public String getAttachmentURL(String attName) {
        return this.m_urlConstructor.makeURL(WikiContext.ATTACH, attName, false, null);
    }

    public String getURL(String context, String pageName, String params, boolean absolute) {
        if (pageName == null) {
            pageName = this.getFrontPage();
        }
        return this.m_urlConstructor.makeURL(context, pageName, absolute, params);
    }

    public String getFrontPage() {
        try {
            return this.getFrontPage(null).getPath().toString();
        }
        catch (ProviderException e) {
            return "ErrorFrontPageCannotBeDetermined";
        }
    }

    public WikiPage getFrontPage(String space) throws ProviderException {
        WikiPage p;
        WikiPath name = new WikiPath(space, this.m_frontPage);
        try {
            p = this.m_contentManager.getPage(name);
        }
        catch (PageNotFoundException e) {
            try {
                p = this.createPage(name);
            }
            catch (PageAlreadyExistsException e1) {
                throw new ProviderException(e1.getMessage(), e1);
            }
        }
        return p;
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public String safeGetParameter(ServletRequest request, String name) {
        try {
            String res = request.getParameter(name);
            if (res != null) {
                res = new String(res.getBytes("ISO-8859-1"), this.getContentEncoding());
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding", e);
            return "";
        }
    }

    public String safeGetQueryString(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        try {
            int pos1;
            String res = request.getQueryString();
            if (res != null && (pos1 = (res = new String(res.getBytes("ISO-8859-1"), this.getContentEncoding())).indexOf("page=")) >= 0) {
                String tmpRes = res.substring(0, pos1);
                int pos2 = res.indexOf("&", pos1) + 1;
                if (pos2 > 0 && pos2 < res.length()) {
                    tmpRes = String.valueOf(tmpRes) + res.substring(pos2);
                }
                res = tmpRes;
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding", e);
            return "";
        }
    }

    public String getInterWikiURL(String wikiName) {
        return TextUtil.getStringProperty(this.m_properties, PROP_INTERWIKIREF + wikiName, null);
    }

    public List<String> getAllInterWikiLinks() {
        ArrayList<String> links = new ArrayList<String>();
        Enumeration<?> e = this.m_properties.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            if (!prop.startsWith(PROP_INTERWIKIREF)) continue;
            links.add(prop.substring(prop.lastIndexOf(".") + 1));
        }
        return links;
    }

    public List<String> getAllInlinedImagePatterns() {
        return JSPWikiMarkupParser.getImagePatterns(this);
    }

    public URI getSpecialPageReference(String original) {
        URI uri = this.m_specialPageResolver.getSpecialPageURI(original);
        return uri;
    }

    public String getApplicationName() {
        String appName = TextUtil.getStringProperty(this.m_properties, PROP_APPNAME, "JSPWiki");
        return MarkupParser.cleanLink(appName);
    }

    public String beautifyTitle(WikiPath path) {
        if ("Main".equals(path.getSpace())) {
            return this.beautifyTitle(path.getPath());
        }
        return this.beautifyTitle(path.toString());
    }

    public String beautifyTitle(String title) {
        if (this.m_beautifyTitle) {
            try {
                Attachment att;
                try {
                    att = this.m_attachmentManager.getAttachmentInfo(title);
                }
                catch (PageNotFoundException e) {
                    return TextUtil.beautifyString(title);
                }
                try {
                    String parent = TextUtil.beautifyString(att.getParent().getName());
                    return String.valueOf(parent) + "/" + att.getFileName();
                }
                catch (PageNotFoundException e) {
                    return title;
                }
            }
            catch (ProviderException e) {
                return title;
            }
        }
        return title;
    }

    public String beautifyTitleNoBreak(String title) {
        if (this.m_beautifyTitle) {
            return TextUtil.beautifyString(title, "&nbsp;");
        }
        return title;
    }

    public boolean pageExists(String page) {
        try {
            return this.pageExists(page, -1);
        }
        catch (ProviderException e) {
            return false;
        }
    }

    public boolean pageExists(String page, int version) throws ProviderException {
        WikiPath path = WikiPath.valueOf(page);
        WikiPath finalPath = this.getFinalPageName(path);
        finalPath = finalPath == null ? path : finalPath;
        return this.m_contentManager.pageExists(finalPath, version);
    }

    public boolean pageExists(WikiPage page) throws ProviderException {
        return this.pageExists(page.getPath().toString(), -1);
    }

    public String encodeName(String pagename) {
        try {
            return URLEncoder.encode(pagename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("UTF-8 not a supported encoding!?!  Your platform is b0rked.");
        }
    }

    public String decodeName(String pagerequest) {
        try {
            return URLDecoder.decode(pagerequest, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("UTF-8 not a supported encoding!?!  Your platform is b0rked.");
        }
    }

    public String getContentEncoding() {
        return "UTF-8";
    }

    public WorkflowManager getWorkflowManager() {
        return this.m_workflowMgr;
    }

    public String getText(String page) {
        return this.getText(page, -1);
    }

    public String getText(String page, int version) {
        String result = this.getPureText(page, version);
        result = TextUtil.replaceEntities(result);
        return result;
    }

    public String getText(WikiContext context, WikiPage page) {
        return this.getText(page.getName(), page.getVersion());
    }

    public String getPureText(String page, int version) {
        String result = null;
        try {
            try {
                JCRWikiPage p = this.m_contentManager.getPage(WikiPath.valueOf(page), version);
                result = p.getContentAsString();
            }
            catch (PageNotFoundException pageNotFoundException) {
                if (result == null) {
                    result = "";
                }
            }
            catch (ProviderException providerException) {
                if (result == null) {
                    result = "";
                }
            }
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public String getPureText(WikiPage page) throws PageNotFoundException, ProviderException {
        return page.getContentAsString();
    }

    public String getHTML(WikiContext context, WikiPage page) {
        String pagedata = null;
        pagedata = this.getPureText(page.getName(), page.getVersion());
        String res = this.textToHTML(context, pagedata);
        return res;
    }

    public String getHTML(String page) throws PageNotFoundException, ProviderException {
        return this.getHTML(page, -1);
    }

    public String getHTML(String pagename, int version) throws PageNotFoundException, ProviderException {
        WikiPage page = this.getPage(pagename, version);
        WikiActionBeanContext context = this.m_contextFactory.newViewContext(page);
        String res = this.getHTML(context, page);
        return res;
    }

    public String textToHTML(WikiContext context, String pagedata) {
        String result = "";
        boolean runFilters = "true".equals(this.m_variableManager.getValue(context, PROP_RUNFILTERS, "true"));
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            if (runFilters) {
                pagedata = this.m_filterManager.doPreTranslateFiltering(context, pagedata);
            }
            result = this.m_renderingManager.getHTML(context, pagedata);
            if (runFilters) {
                result = this.m_filterManager.doPostTranslateFiltering(context, result);
            }
        }
        catch (FilterException filterException) {
            // empty catch block
        }
        sw.stop();
        if (log.isDebugEnabled()) {
            log.debug("Page " + context.getRealPage().getName() + " rendered, took " + sw, new Object[0]);
        }
        return result;
    }

    public void restart() throws WikiException {
        this.shutdown();
        LogManager.resetConfiguration();
        ClassLoader cl = this.getClass().getClassLoader();
        URL log4jprops = cl.getResource("log4j.properties");
        if (log4jprops != null) {
            PropertyConfigurator.configure((URL)log4jprops);
        }
        this.m_properties = PropertyReader.loadWebAppProps(this.m_servletContext);
        this.initialize(this.m_properties);
    }

    public void shutdown() {
        this.fireEvent(1);
        if (this.m_filterManager != null) {
            this.m_filterManager.destroy();
        }
        LoggerFactory.unRegisterAllLoggerMBeans();
        if (this.m_contentManager != null) {
            this.m_contentManager.shutdown();
        }
        WikiBackgroundThread.unregisterTimer(this);
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, null, true, false);
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, attLinkHook, true, false);
    }

    private String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook, boolean parseAccessRules, boolean justParse) {
        String result = "";
        if (pagedata == null) {
            log.error("NULL pagedata to textToHTML()", new Object[0]);
            return null;
        }
        boolean runFilters = "true".equals(this.m_variableManager.getValue(context, PROP_RUNFILTERS, "true"));
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            if (runFilters) {
                pagedata = this.m_filterManager.doPreTranslateFiltering(context, pagedata);
            }
            MarkupParser mp = this.m_renderingManager.getParser(context, pagedata);
            mp.addLocalLinkHook(localLinkHook);
            mp.addExternalLinkHook(extLinkHook);
            mp.addAttachmentLinkHook(attLinkHook);
            if (!parseAccessRules) {
                mp.disableAccessRules();
            }
            WikiDocument doc = mp.parse();
            if (!justParse) {
                result = this.m_renderingManager.getHTML(context, doc);
                if (runFilters) {
                    result = this.m_filterManager.doPostTranslateFiltering(context, result);
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug("Page " + context.getRealPage().getName() + " rendered, took " + sw, new Object[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to scan page data: ", e);
        }
        catch (FilterException filterException) {
            // empty catch block
        }
        return result;
    }

    public void saveText(WikiContext context, String text) throws WikiException {
        boolean allowEmpty;
        WikiPage page = context.getPage();
        String oldText = page.getContentAsString();
        String proposedText = TextUtil.normalizePostData(text);
        if (oldText != null && oldText.equals(proposedText)) {
            return;
        }
        if (oldText == null) {
            oldText = "";
        }
        if (!(allowEmpty = TextUtil.getBooleanProperty(this.m_properties, PROP_ALLOW_CREATION_OF_EMPTY_PAGES, false)) && !this.pageExists(page) && text.trim().equals("")) {
            return;
        }
        WorkflowBuilder builder = WorkflowBuilder.getBuilder(this);
        Principal submitter = context.getCurrentUser();
        ContentManager.PreSaveWikiPageTask prepTask = new ContentManager.PreSaveWikiPageTask(context, proposedText);
        ContentManager.SaveWikiPageTask completionTask = new ContentManager.SaveWikiPageTask();
        String diffText = this.m_differenceManager.makeDiff(context, oldText, proposedText);
        boolean isAuthenticated = context.getWikiSession().isAuthenticated();
        Fact[] facts = new Fact[]{new Fact("fact.pageName", (Serializable)((Object)page.getName())), new Fact("fact.diffText", (Serializable)((Object)diffText)), new Fact("fact.proposedText", (Serializable)((Object)proposedText)), new Fact("fact.currentText", (Serializable)((Object)oldText)), new Fact("fact.isAuthenticated", Boolean.valueOf(isAuthenticated))};
        String rejectKey = isAuthenticated ? "notification.saveWikiPage.reject" : null;
        Workflow workflow = builder.buildApprovalWorkflow(submitter, "workflow.saveWikiPage", prepTask, "decision.saveWikiPage", facts, completionTask, rejectKey);
        this.m_workflowMgr.start(workflow);
        if (workflow.getCurrentStep() instanceof Decision) {
            throw new DecisionRequiredException("The page contents must be approved before they become active.");
        }
    }

    public int getPageCount() {
        try {
            return this.m_contentManager.getTotalPageCount(null);
        }
        catch (ProviderException e) {
            return -1;
        }
    }

    public String getCurrentProvider() {
        return this.m_contentManager.getProvider();
    }

    public String getCurrentProviderInfo() {
        return this.m_contentManager.getProviderDescription();
    }

    public List<WikiPage> getRecentChanges(String space) {
        try {
            List<WikiPage> pages = this.m_contentManager.getAllPages(space);
            Collections.sort(pages, PAGE_TIME_COMPARATOR);
            return pages;
        }
        catch (ProviderException e) {
            log.error("Unable to fetch all pages: ", e);
            return null;
        }
    }

    public List<SearchResult> findPages(String query) throws ProviderException, IOException {
        List<SearchResult> results = this.m_searchManager.findPages(query);
        return results;
    }

    public WikiPage createPage(WikiPath name) throws PageAlreadyExistsException, ProviderException {
        return this.m_contentManager.addPage(name, "text/x-jspwiki");
    }

    public WikiPage createPage(String fqn) throws PageAlreadyExistsException, ProviderException {
        return this.createPage(WikiPath.valueOf(fqn));
    }

    public WikiPage getPage(String pagereq) throws PageNotFoundException, ProviderException {
        return this.getPage(WikiPath.valueOf(pagereq));
    }

    public WikiPage getPage(WikiPath name) throws PageNotFoundException, ProviderException {
        return this.m_contentManager.getPage(name);
    }

    public WikiPage getPage(String pagereq, int version) throws PageNotFoundException, ProviderException {
        JCRWikiPage p = this.m_contentManager.getPage(WikiPath.valueOf(pagereq), version);
        return p;
    }

    public List<WikiPage> getVersionHistory(String page) throws PageNotFoundException, ProviderException {
        return this.m_contentManager.getVersionHistory(WikiPath.valueOf(page));
    }

    public String getDiff(WikiContext context, int version1, int version2) {
        String page = context.getPage().getName();
        String page1 = this.getPureText(page, version1);
        String page2 = this.getPureText(page, version2);
        if (version1 == -1) {
            page1 = "";
        }
        String diff = this.m_differenceManager.makeDiff(context, page1, page2);
        return diff;
    }

    public ReferenceManager getReferenceManager() {
        return this.m_referenceManager;
    }

    public RenderingManager getRenderingManager() {
        return this.m_renderingManager;
    }

    public PluginManager getPluginManager() {
        return this.m_pluginManager;
    }

    public VariableManager getVariableManager() {
        return this.m_variableManager;
    }

    public String getVariable(WikiContext context, String name) {
        try {
            return this.m_variableManager.getValue(context, name);
        }
        catch (NoSuchVariableException e) {
            return null;
        }
    }

    public PageManager getPageManager() {
        return this.m_pageManager;
    }

    public WikiContextFactory getWikiContextFactory() {
        return this.m_contextFactory;
    }

    public AttachmentManager getAttachmentManager() {
        return this.m_attachmentManager;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.m_authorizationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.m_authenticationManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public SearchManager getSearchManager() {
        return this.m_searchManager;
    }

    public ProgressManager getProgressManager() {
        return this.m_progressManager;
    }

    public WikiContext createContext(HttpServletRequest request, String requestContext) {
        WikiActionBeanContext context;
        if (!this.m_isConfigured) {
            throw new InternalWikiException("WikiEngine has not been properly started.  It is likely that the configuration is faulty.  Please check all logs for the possible reason.");
        }
        if (request != null) {
            try {
                WikiActionBean actionBean = WikiInterceptor.findActionBean((ServletRequest)request);
                context = actionBean.getContext();
                context.setRequestContext(requestContext);
            }
            catch (IllegalStateException actionBean) {
                // empty catch block
            }
        }
        try {
            context = this.m_contextFactory.newContext(request, null, requestContext);
            request.setAttribute("wikiEngine", (Object)this);
            WikiSession wikiSession = SessionMonitor.getInstance(this).find(request.getSession());
            request.setAttribute("wikiSession", (Object)wikiSession);
            WikiContextFactory.saveContext((ServletRequest)request, context);
            return context;
        }
        catch (WikiException e) {
            log.error("Could not create context: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public void deletePage(String pageName) throws ProviderException {
        try {
            WikiPage p = this.getPage(pageName);
            this.m_contentManager.deletePage(p);
        }
        catch (PageNotFoundException pageNotFoundException) {
            // empty catch block
        }
    }

    public void deleteVersion(WikiPage page) throws ProviderException {
        this.m_contentManager.deleteVersion(page);
    }

    public String getGlobalRSSURL() {
        if (this.m_rssGenerator != null && this.m_rssGenerator.isEnabled()) {
            return String.valueOf(this.getBaseURL()) + this.m_rssFile;
        }
        return null;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public StripesURLConstructor getURLConstructor() {
        return this.m_urlConstructor;
    }

    public RSSGenerator getRSSGenerator() {
        return this.m_rssGenerator;
    }

    public String renamePage(WikiContext context, String renameFrom, String renameTo, boolean changeReferrers) throws WikiException {
        return this.m_contentManager.renamePage(context, renameFrom, renameTo);
    }

    public PageRenamer getPageRenamer() {
        return this.m_pageRenamer;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public AdminBeanManager getAdminBeanManager() {
        return this.m_adminBeanManager;
    }

    public AclManager getAclManager() {
        if (this.m_aclManager == null) {
            try {
                String s = this.m_properties.getProperty(PROP_ACL_MANAGER_IMPL, DefaultAclManager.class.getName());
                this.m_aclManager = (AclManager)ClassUtil.getMappedObject(s);
                this.m_aclManager.initialize(this, this.m_properties);
            }
            catch (WikiException we) {
                log.error("unable to instantiate class for AclManager: " + we.getMessage(), new Object[0]);
                throw new InternalWikiException("Cannot instantiate AclManager, please check logs.");
            }
        }
        return this.m_aclManager;
    }

    public ContentManager getContentManager() {
        return this.m_contentManager;
    }

    public DifferenceManager getDifferenceManager() {
        return this.m_differenceManager;
    }

    public EditorManager getEditorManager() {
        return this.m_editorManager;
    }

    public InternationalizationManager getInternationalizationManager() {
        return this.m_internationalizationManager;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiEngineEvent(this, type));
        }
    }

    public void setAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public Object removeAttribute(String key) {
        return this.m_attributes.remove(key);
    }

    public WatchDog getCurrentWatchDog() {
        return WatchDog.getCurrentWatchDog(this);
    }

    public void release() {
        this.m_contentManager.release();
    }

    public final WikiPath getFinalPageName(WikiPath page) throws ProviderException {
        if (this.getContentManager().pageExists(page)) {
            return page;
        }
        for (PageNameResolver resolver : this.m_nameResolvers) {
            WikiPath resolvedPath = resolver.resolve(page);
            if (resolvedPath == null) continue;
            return resolvedPath;
        }
        return null;
    }
}

