/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.NoSuchVariableException;
import org.apache.wiki.Release;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.filters.PageFilter;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.preferences.Preferences;

public class VariableManager {
    private static Logger log = LoggerFactory.getLogger(VariableManager.class);
    public static final String VAR_ERROR = "error";
    public static final String VAR_MSG = "msg";
    static final String[] THE_BIG_NO_NO_LIST = new String[]{"jspwiki.auth.masterpassword"};

    public VariableManager(Properties props) {
    }

    public static boolean isVariableLink(String link) {
        return link.startsWith("{$");
    }

    public String parseAndGetValue(WikiContext context, String link) throws IllegalArgumentException, NoSuchVariableException {
        if (!link.startsWith("{$")) {
            throw new IllegalArgumentException("Link does not start with {$");
        }
        if (!link.endsWith("}")) {
            throw new IllegalArgumentException("Link does not end with }");
        }
        String varName = link.substring(2, link.length() - 1);
        return this.getValue(context, varName.trim());
    }

    public String expandVariables(WikiContext context, String source) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            if (source.charAt(i) == '{') {
                if (i < source.length() - 2 && source.charAt(i + 1) == '$') {
                    int end = source.indexOf(125, i);
                    if (end != -1) {
                        String value;
                        String varname = source.substring(i + 2, end);
                        try {
                            value = this.getValue(context, varname);
                        }
                        catch (NoSuchVariableException e) {
                            value = e.getMessage();
                        }
                        catch (IllegalArgumentException e) {
                            value = e.getMessage();
                        }
                        result.append(value);
                        i = end;
                    }
                } else {
                    result.append('{');
                }
            } else {
                result.append(source.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public String getValue(WikiContext context, String varName, String defValue) {
        try {
            return this.getValue(context, varName);
        }
        catch (NoSuchVariableException e) {
            return defValue;
        }
    }

    public String getValue(WikiContext context, String varName) throws IllegalArgumentException, NoSuchVariableException {
        if (varName == null) {
            throw new IllegalArgumentException("Null variable name.");
        }
        if (varName.length() == 0) {
            throw new IllegalArgumentException("Zero length variable name.");
        }
        String name = varName.toLowerCase();
        int i = 0;
        while (i < THE_BIG_NO_NO_LIST.length) {
            if (name.equals(THE_BIG_NO_NO_LIST[i])) {
                return "";
            }
            ++i;
        }
        try {
            SystemVariables sysvars = new SystemVariables(context);
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method method = sysvars.getClass().getMethod(methodName, new Class[0]);
            return (String)method.invoke((Object)sysvars, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            Properties props;
            String s;
            Serializable metadata;
            Serializable metadata2;
            WikiPage pg;
            if (context.getVariable(varName) != null) {
                return context.getVariable(varName).toString();
            }
            HttpServletRequest req = context.getHttpRequest();
            if (req != null && req.getSession() != null) {
                HttpSession session = req.getSession();
                try {
                    String s2 = (String)session.getAttribute(varName);
                    if (s2 != null) {
                        return s2;
                    }
                    s2 = context.getHttpParameter(varName);
                    if (s2 != null) {
                        return s2;
                    }
                }
                catch (ClassCastException s2) {
                    // empty catch block
                }
            }
            if ((pg = context.getPage()) != null && (metadata2 = pg.getAttribute(varName)) != null) {
                return metadata2.toString();
            }
            WikiPage rpg = context.getRealPage();
            if (rpg != null && (metadata = rpg.getAttribute(varName)) != null) {
                return metadata.toString();
            }
            if (varName.startsWith("jspwiki.") && (s = (props = context.getEngine().getWikiProperties()).getProperty(varName)) != null) {
                return s;
            }
            if (varName.toLowerCase().startsWith("timestamp")) {
                StringTokenizer tok = new StringTokenizer(varName, " ");
                int numTokens = tok.countTokens();
                if (numTokens == 1) {
                    Preferences prefs = Preferences.getPreferences(req);
                    return prefs.getDateFormat(Preferences.TimeFormat.DATETIME).format(new Date());
                }
                if (numTokens >= 2) {
                    String ignoreFirstToken = tok.nextToken();
                    String parm1 = tok.nextToken("=").trim();
                    if (!parm1.startsWith("format")) {
                        return String.valueOf(context.getBundle("CoreResources").getString("varmgr.dateformat.invalid.parm")) + parm1;
                    }
                    String dateFormatString = tok.nextToken();
                    SimpleDateFormat dateFormat = null;
                    try {
                        dateFormat = new SimpleDateFormat(dateFormatString);
                        return dateFormat.format(new Date());
                    }
                    catch (RuntimeException e) {
                        return String.valueOf(context.getBundle("CoreResources").getString("varmgr.dateformat.invalid.format")) + dateFormatString;
                    }
                }
            }
            if (varName.equals(VAR_ERROR) || varName.equals(VAR_MSG)) {
                return "";
            }
            throw new NoSuchVariableException("No variable " + varName + " defined.");
        }
        catch (Exception e) {
            log.info("Interesting exception: cannot fetch variable value '" + varName + "'.", e, new Object[0]);
            return "";
        }
    }

    private static class SystemVariables {
        private WikiContext m_context;

        public SystemVariables(WikiContext context) {
            this.m_context = context;
        }

        public String getPagename() {
            WikiPage page = this.m_context.getPage();
            return page == null ? null : page.getName();
        }

        public String getApplicationname() {
            return this.m_context.getEngine().getApplicationName();
        }

        public String getJspwikiversion() {
            return Release.getVersionString();
        }

        public String getEncoding() {
            return this.m_context.getEngine().getContentEncoding();
        }

        public String getTotalpages() {
            return Integer.toString(this.m_context.getEngine().getPageCount());
        }

        public String getPageprovider() {
            return this.m_context.getEngine().getCurrentProvider();
        }

        public String getPageproviderdescription() {
            return this.m_context.getEngine().getCurrentProviderInfo();
        }

        public String getAttachmentprovider() {
            return "DEPRECATED";
        }

        public String getAttachmentproviderdescription() {
            return "DEPRECATED";
        }

        public String getInterwikilinks() {
            StringBuilder res = new StringBuilder();
            for (String link : this.m_context.getEngine().getAllInterWikiLinks()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append(link);
                res.append(" --> ");
                res.append(this.m_context.getEngine().getInterWikiURL(link));
            }
            return res.toString();
        }

        public String getInlinedimages() {
            StringBuilder res = new StringBuilder();
            for (String ptrn : this.m_context.getEngine().getAllInlinedImagePatterns()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append(ptrn);
            }
            return res.toString();
        }

        public String getPluginpath() {
            String s = this.m_context.getEngine().getPluginSearchPath();
            return s == null ? "-" : s;
        }

        public String getBaseurl() {
            return this.m_context.getEngine().getBaseURL();
        }

        public String getUptime() {
            Date now = new Date();
            long secondsRunning = (now.getTime() - this.m_context.getEngine().getStartTime().getTime()) / 1000L;
            long seconds = secondsRunning % 60L;
            long minutes = (secondsRunning /= 60L) % 60L;
            long hours = (secondsRunning /= 60L) % 24L;
            long days = secondsRunning /= 24L;
            return String.valueOf(days) + "d, " + hours + "h " + minutes + "m " + seconds + "s";
        }

        public String getLoginstatus() {
            WikiSession session = this.m_context.getWikiSession();
            return this.m_context.getBundle("CoreResources").getString("varmgr." + session.getStatus());
        }

        public String getUsername() {
            Principal wup = this.m_context.getCurrentUser();
            ResourceBundle rb = this.m_context.getBundle("CoreResources");
            return wup != null ? wup.getName() : rb.getString("varmgr.not.logged.in");
        }

        public String getRequestcontext() {
            return this.m_context.getRequestContext();
        }

        public String getPagefilters() {
            List<PageFilter> filters = this.m_context.getEngine().getFilterManager().getFilterList();
            StringBuilder sb = new StringBuilder();
            for (PageFilter filter : filters) {
                String f = filter.getClass().getName();
                if (filter instanceof InternalModule) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(f);
            }
            return sb.toString();
        }
    }
}

