/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.content.lock.PageLock;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.providers.WikiPageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageManager
extends ModuleManager {
    private static final long serialVersionUID = 1L;
    public static final String PROP_PAGEPROVIDER = "jspwiki.pageProvider";
    public static final String PROP_USECACHE = "jspwiki.usePageCache";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";
    public static final String PRESAVE_TASK_MESSAGE_KEY = "task.preSaveWikiPage";
    public static final String PRESAVE_WIKI_CONTEXT = "wikiContext";
    public static final String SAVE_APPROVER = "workflow.saveWikiPage";
    public static final String SAVE_DECISION_MESSAGE_KEY = "decision.saveWikiPage";
    public static final String SAVE_REJECT_MESSAGE_KEY = "notification.saveWikiPage.reject";
    public static final String SAVE_TASK_MESSAGE_KEY = "task.saveWikiPage";
    public static final String FACT_PAGE_NAME = "fact.pageName";
    public static final String FACT_DIFF_TEXT = "fact.diffText";
    public static final String FACT_CURRENT_TEXT = "fact.currentText";
    public static final String FACT_PROPOSED_TEXT = "fact.proposedText";
    public static final String FACT_IS_AUTHENTICATED = "fact.isAuthenticated";
    static Logger log = LoggerFactory.getLogger(PageManager.class);
    private WikiPageProvider m_provider;

    public PageManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
    }

    public WikiPageProvider getProvider() {
        return this.m_provider;
    }

    public List<WikiPage> getAllPages() throws ProviderException {
        return this.m_engine.getContentManager().getAllPages(null);
    }

    public String getPageText(String pageName, int version) throws PageNotFoundException, ProviderException {
        JCRWikiPage p = this.m_engine.getContentManager().getPage(WikiPath.valueOf(pageName), version);
        if (p != null) {
            return p.getContentAsString();
        }
        return null;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public void putPageText(WikiPage page, String content) throws ProviderException {
        JCRWikiPage p;
        try {
            p = this.m_engine.getContentManager().getPage(page.getPath());
        }
        catch (PageNotFoundException e) {
            try {
                p = this.m_engine.getContentManager().addPage(page.getPath(), "text/x-jspwiki");
            }
            catch (PageAlreadyExistsException e1) {
                throw new ProviderException(e1.getMessage(), e1);
            }
        }
        p.setContent(content);
        p.save();
    }

    public PageLock lockPage(WikiPage page, String user) {
        return this.m_engine.getContentManager().lockPage(page, user);
    }

    public void unlockPage(PageLock lock) {
        this.m_engine.getContentManager().unlockPage(lock);
    }

    public PageLock getCurrentLock(WikiPage page) {
        return this.m_engine.getContentManager().getCurrentLock(page);
    }

    public List<PageLock> getActiveLocks() {
        return this.m_engine.getContentManager().getActiveLocks();
    }

    public WikiPage getPageInfo(String pageName, int version) throws PageNotFoundException, ProviderException {
        return this.m_engine.getContentManager().getPage(WikiPath.valueOf(pageName), version);
    }

    public List<WikiPage> getVersionHistory(String pageName) throws PageNotFoundException, ProviderException {
        return this.m_engine.getContentManager().getVersionHistory(WikiPath.valueOf(pageName));
    }

    public String getProviderDescription() {
        return this.m_engine.getContentManager().getProviderDescription();
    }

    public int getTotalPageCount() {
        try {
            return this.m_engine.getContentManager().getTotalPageCount(null);
        }
        catch (ProviderException e) {
            return -1;
        }
    }

    public boolean pageExists(String pageName) throws ProviderException {
        return this.m_engine.pageExists(pageName);
    }

    public boolean pageExists(String pageName, int version) throws ProviderException {
        return this.m_engine.pageExists(pageName, version);
    }

    public void deleteVersion(WikiPage page) throws ProviderException {
        this.m_engine.getContentManager().deleteVersion(page);
    }

    public void deletePage(WikiPage page) throws ProviderException {
        this.m_engine.getContentManager().deletePage(page);
    }

    public Collection<WikiModuleInfo> modules() {
        return null;
    }
}

