/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class StreamFile
extends DfsServlet {
    static InetSocketAddress nameNodeAddr;
    static DataNode datanode;
    private static final Configuration masterConf;

    protected DFSClient getDFSClient(HttpServletRequest request) throws IOException {
        Configuration conf = new Configuration(masterConf);
        UnixUserGroupInformation.saveToConf(conf, "hadoop.job.ugi", this.getUGI(request));
        return new DFSClient(nameNodeAddr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("filename");
        if (filename == null || filename.length() == 0) {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.print("Invalid input");
            return;
        }
        DFSClient dfs = this.getDFSClient(request);
        DFSClient.DFSInputStream in = dfs.open(filename);
        ServletOutputStream os = response.getOutputStream();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
        byte[] buf = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            ((InputStream)in).close();
            os.close();
            dfs.close();
        }
    }

    static {
        datanode = null;
        masterConf = new Configuration();
        datanode = DataNode.getDataNode();
        if (datanode != null) {
            nameNodeAddr = datanode.getNameNodeAddr();
        }
    }
}

