/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.unmarshal;

import java.util.ArrayList;
import org.apache.deltacloud.client.Action;
import org.apache.deltacloud.client.AddressList;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.Instance;
import org.apache.deltacloud.client.unmarshal.AbstractActionAwareUnmarshaller;
import org.apache.deltacloud.client.unmarshal.ActionUnmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstanceUnmarshaller
extends AbstractActionAwareUnmarshaller<Instance> {
    public InstanceUnmarshaller() {
        super("instance", Instance.class, "link");
    }

    @Override
    protected Instance doUnmarshall(Element element, Instance instance) throws Exception {
        instance.setId(this.getAttributeText("id", element));
        instance.setName(this.getFirstElementText("name", element));
        instance.setOwnerId(this.getFirstElementText("owner_id", element));
        instance.setOwnerId(this.getFirstElementText("owner_id", element));
        instance.setImageId(this.getFirstElementAttributeText("image", "id", element));
        instance.setProfileId(this.getFirstElementAttributeText("hardware_profile", "id", element));
        instance.setRealmId(this.getFirstElementAttributeText("realm", "id", element));
        instance.setState(this.getFirstElementText("state", element));
        this.setKeyname(instance, element);
        instance.setActions(this.getActions(element, instance));
        instance.setPublicAddresses(this.getAddressList("public_addresses", element));
        instance.setPrivateAddresses(this.getAddressList("private_addresses", element));
        return instance;
    }

    private AddressList getAddressList(String elementName, Element element) {
        NodeList addressList;
        Element addressElement = this.getFirstElement(elementName, element);
        if (addressElement != null && (addressList = addressElement.getChildNodes()) != null) {
            ArrayList<String> addresses = new ArrayList<String>();
            for (int i = 0; i < addressList.getLength(); ++i) {
                String address;
                Node addressNode = addressList.item(i);
                if (addressNode == null || (address = this.stripText(addressNode.getTextContent())) == null || address.length() <= 0) continue;
                addresses.add(address);
            }
            return new AddressList(addresses);
        }
        return new AddressList();
    }

    private void setKeyname(Instance instance, Element element) {
        Element loginElement;
        Element authenticationElement = this.getFirstElement("authentication", element);
        if (authenticationElement != null && (loginElement = this.getFirstElement("login", authenticationElement)) != null) {
            String keyname = this.getFirstElementText("keyname", loginElement);
            instance.setKeyId(keyname);
        }
    }

    @Override
    protected Action<Instance> unmarshallAction(Element element) throws DeltaCloudClientException {
        Action<Instance> action = new Action<Instance>();
        new ActionUnmarshaller().unmarshall(element, action);
        return action;
    }
}

