/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.unmarshal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractDOMUnmarshaller<DELTACLOUDOBJECT> {
    private Class<DELTACLOUDOBJECT> type;
    private String tagName;

    public AbstractDOMUnmarshaller(String tagName, Class<DELTACLOUDOBJECT> type) {
        this.type = type;
        this.tagName = tagName;
    }

    public DELTACLOUDOBJECT unmarshall(InputStream inputStream, DELTACLOUDOBJECT deltacloudObject) throws DeltaCloudClientException {
        try {
            Element element = this.getFirstElement(this.tagName, this.getDocument(inputStream));
            if (element == null) {
                return null;
            }
            return this.unmarshall(element, deltacloudObject);
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(MessageFormat.format("Could not unmarshall type \"{0}\"", this.type), e);
        }
    }

    protected Document getDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    public DELTACLOUDOBJECT unmarshall(Element element, DELTACLOUDOBJECT resource) throws DeltaCloudClientException {
        try {
            return this.doUnmarshall(element, resource);
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(MessageFormat.format("Could not unmarshall type \"{0}\"", this.type), e);
        }
    }

    protected abstract DELTACLOUDOBJECT doUnmarshall(Element var1, DELTACLOUDOBJECT var2) throws Exception;

    protected String getFirstElementAttributeText(String elementName, String attributeId, Element element) {
        Element firstElement = this.getFirstElement(elementName, element);
        if (firstElement == null) {
            return null;
        }
        return firstElement.getAttribute(attributeId);
    }

    protected String getFirstElementText(String elementName, Element element) {
        Element firstElement = this.getFirstElement(elementName, element);
        if (firstElement == null) {
            return null;
        }
        return firstElement.getTextContent();
    }

    protected Element getFirstElement(String elementName, Element element) {
        NodeList elements = element.getElementsByTagName(elementName);
        if (elements != null && elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    protected Element getFirstElement(String elementName, Document document) {
        NodeList elements = document.getElementsByTagName(elementName);
        if (elements != null && elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    protected String getAttributeText(String attributeName, Element element) {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute != null) {
            return attribute.getTextContent();
        }
        return null;
    }

    protected String stripText(String textContent) {
        if (textContent == null || textContent.length() == 0) {
            return textContent;
        }
        return textContent.trim();
    }
}

