/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.deltacloud.client.DeltaCloudNotFoundClientException;
import org.apache.deltacloud.client.HttpMethod;
import org.apache.deltacloud.client.request.DeltaCloudRequest;
import org.apache.deltacloud.client.transport.AbstractHttpTransport;
import org.apache.deltacloud.client.transport.Base64Coder;

public class URLConnectionTransport
extends AbstractHttpTransport {
    private static final char USERNAME_PASSWORD_DELIMITER = ':';
    private static final String PROPERTY_AUTHORIZATION = "Authorization";
    private static final String PROPERTY_ACCEPT = "Accept";
    private static final String PREFIX_BASIC_AUTHENTICATION = "Basic ";
    private static final int TIMEOUT = 10240;

    public URLConnectionTransport(String username, String password) {
        super(username, password);
    }

    @Override
    protected InputStream doRequest(DeltaCloudRequest request) throws Exception {
        HttpURLConnection connection = null;
        try {
            URL url = request.getUrl();
            connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setAllowUserInteraction(false);
            connection.setConnectTimeout(10240);
            connection.setRequestProperty(PROPERTY_ACCEPT, "application/xml;q=1");
            connection.setInstanceFollowRedirects(true);
            this.addCredentials(connection);
            this.setRequestMethod(request, connection);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            return in;
        }
        catch (FileNotFoundException e) {
            throw new DeltaCloudNotFoundClientException(MessageFormat.format("Could not find resource {0}", request.getUrlString()));
        }
        catch (IOException e) {
            HttpError httpError = HttpError.getInstance(e, connection);
            if (httpError != null) {
                this.throwOnHttpErrors(httpError.getStatusCode(), httpError.getStatusMessage(), request.getUrl());
            }
            throw e;
        }
    }

    private void setRequestMethod(DeltaCloudRequest request, HttpURLConnection connection) throws IOException {
        HttpMethod httpMethod = request.getHttpMethod();
        connection.setRequestMethod(httpMethod.name());
        switch (httpMethod) {
            case PUT: 
            case POST: {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", "0");
                connection.setDoOutput(true);
                connection.getOutputStream().flush();
                break;
            }
            case GET: {
                connection.setDoOutput(false);
            }
        }
    }

    private void addCredentials(URLConnection urlConnection) throws IOException {
        String username = this.getUsername();
        String password = this.getPassword();
        if (username != null && password != null) {
            String credentials = PREFIX_BASIC_AUTHENTICATION + this.getAuthenticationValue(username, password);
            urlConnection.setRequestProperty(PROPERTY_AUTHORIZATION, credentials);
        }
    }

    private String getAuthenticationValue(String username, String password) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(username.getBytes());
        out.write(58);
        out.write(password.getBytes());
        char[] encoded = Base64Coder.encode(out.toByteArray());
        return new String(encoded);
    }

    private static final class HttpError {
        private static final Pattern STATUS_REGEX = Pattern.compile(".+ HTTP response code: ([0-9]{3}) .+");
        private int statusCode;
        private String statusMessage;

        private HttpError(int statusCode, String statusMessage) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
        }

        public static HttpError getInstance(IOException ioe, HttpURLConnection connection) throws IOException {
            HttpError httpError = null;
            try {
                int statusCode = HttpError.getStatusCode(ioe);
                if (statusCode > -1) {
                    String statusMessage = connection.getResponseMessage();
                    httpError = new HttpError(statusCode, statusMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return httpError;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        private static int getStatusCode(IOException e) {
            Matcher matcher = STATUS_REGEX.matcher(e.getMessage());
            if (matcher.matches()) {
                return HttpError.getStatusCode(matcher.group(1));
            }
            return -1;
        }

        private static int getStatusCode(String statusCode) {
            try {
                return Integer.parseInt(statusCode);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

