/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client;

import java.io.InputStream;
import java.util.List;
import org.apache.deltacloud.client.AddressList;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.StateAware;
import org.apache.deltacloud.client.unmarshal.InstanceUnmarshaller;

public class Instance
extends StateAware<Instance> {
    private static final long serialVersionUID = 1L;
    private String ownerId;
    private String name;
    private String imageId;
    private String profileId;
    private String memory;
    private String storage;
    private String cpu;
    private String realmId;
    private String keyId;
    private AddressList publicAddresses;
    private AddressList privateAddresses;

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    protected void setMemory(String memory) {
        this.memory = memory;
    }

    protected void setStorage(String storage) {
        this.storage = storage;
    }

    protected void setCPU(String cpu) {
        this.cpu = cpu;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setPrivateAddresses(AddressList privateAddresses) {
        this.privateAddresses = privateAddresses;
    }

    public void setPublicAddresses(AddressList publicAddresses) {
        this.publicAddresses = publicAddresses;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getMemory() {
        return this.memory;
    }

    public String getStorage() {
        return this.storage;
    }

    public String getCPU() {
        return this.cpu;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public List<String> getPublicAddresses() {
        return this.publicAddresses.getAddress();
    }

    public List<String> getPrivateAddresses() {
        return this.privateAddresses.getAddress();
    }

    @Override
    protected void doUpdate(InputStream in) throws DeltaCloudClientException {
        new InstanceUnmarshaller().unmarshall(in, this);
    }

    @Override
    public String toString() {
        int i;
        String s = "";
        s = s + "Instance:\t" + this.getId() + "\n";
        s = s + "Owner:\t\t" + this.getOwnerId() + "\n";
        s = s + "Image:\t\t" + this.getImageId() + "\n";
        s = s + "Realm:\t\t" + this.getRealmId() + "\n";
        s = s + "Profile:\t\t" + this.getProfileId() + "\n";
        if (this.getMemory() != null) {
            s = s + "Memory:\t\t" + this.getMemory() + "\n";
        }
        if (this.getStorage() != null) {
            s = s + "Storage:\t\t" + this.getStorage() + "\n";
        }
        if (this.getCPU() != null) {
            s = s + "CPU:\t\t" + this.getCPU() + "\n";
        }
        s = s + "State:\t\t" + (Object)((Object)this.getState()) + "\n";
        List actions = this.getActions();
        if (actions != null) {
            for (i = 0; i < actions.size(); ++i) {
                s = i == 0 ? s + "Actions:\t" + actions.get(i) + "\n" : s + "\t\t" + actions.get(i) + "\n";
            }
        }
        for (i = 0; i < this.publicAddresses.getAddress().size(); ++i) {
            s = i == 0 ? s + "Public Addr:\t" + this.publicAddresses.getAddress().get(i) + "\n" : s + "\t\t" + this.publicAddresses.getAddress().get(i) + "\n";
        }
        for (i = 0; i < this.publicAddresses.getAddress().size(); ++i) {
            s = i == 0 ? s + "Private Addr:\t" + this.publicAddresses.getAddress().get(i) + "\n" : s + "\t\t" + this.privateAddresses.getAddress().get(i) + "\n";
        }
        return s;
    }
}

