/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.deltacloud.client.IdAware;
import org.apache.deltacloud.client.Property;

public class HardwareProfile
extends IdAware {
    private static final long serialVersionUID = 1L;
    private List<Property> properties;

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        return this.properties;
    }

    public Property getNamedProperty(Property.Names nameEnum) {
        if (nameEnum == null) {
            return null;
        }
        return this.getNamedProperty(nameEnum.name().toLowerCase());
    }

    public Property getNamedProperty(String name) {
        if (this.properties != null) {
            for (Property p : this.properties) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    public String getArchitecture() {
        Property p = this.getNamedProperty(Property.Names.ARCHITECTURE);
        if (p != null) {
            return p.getValue();
        }
        return null;
    }

    public String getMemory() {
        Property p = this.getNamedProperty("memory");
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public String getStorage() {
        Property p = this.getNamedProperty("storage");
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public String getCPU() {
        Property p = this.getNamedProperty("cpu");
        if (p != null) {
            return p.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        s = s + "Hardware-profile:\t\t" + this.getId() + "\n";
        for (Property p : this.properties) {
            s = s + p.getName() + ":\t\t" + p.getValue() + "\n";
        }
        return s;
    }
}

