/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.deltacloud.client.API;
import org.apache.deltacloud.client.Action;
import org.apache.deltacloud.client.DeltaCloudClient;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.HardwareProfile;
import org.apache.deltacloud.client.Image;
import org.apache.deltacloud.client.Instance;
import org.apache.deltacloud.client.Key;
import org.apache.deltacloud.client.Realm;
import org.apache.deltacloud.client.request.CreateInstanceRequest;
import org.apache.deltacloud.client.request.CreateKeyRequest;
import org.apache.deltacloud.client.request.DeltaCloudRequest;
import org.apache.deltacloud.client.request.ListHardwareProfileRequest;
import org.apache.deltacloud.client.request.ListHardwareProfilesRequest;
import org.apache.deltacloud.client.request.ListImageRequest;
import org.apache.deltacloud.client.request.ListImagesRequest;
import org.apache.deltacloud.client.request.ListInstanceRequest;
import org.apache.deltacloud.client.request.ListInstancesRequest;
import org.apache.deltacloud.client.request.ListKeyRequest;
import org.apache.deltacloud.client.request.ListKeysRequest;
import org.apache.deltacloud.client.request.ListRealmRequest;
import org.apache.deltacloud.client.request.ListRealmsRequest;
import org.apache.deltacloud.client.request.PerformActionRequest;
import org.apache.deltacloud.client.request.TypeRequest;
import org.apache.deltacloud.client.transport.IHttpTransport;
import org.apache.deltacloud.client.transport.URLConnectionTransport;
import org.apache.deltacloud.client.unmarshal.APIUnmarshaller;
import org.apache.deltacloud.client.unmarshal.HardwareProfileUnmarshaller;
import org.apache.deltacloud.client.unmarshal.HardwareProfilesUnmarshaller;
import org.apache.deltacloud.client.unmarshal.ImageUnmarshaller;
import org.apache.deltacloud.client.unmarshal.ImagesUnmarshaller;
import org.apache.deltacloud.client.unmarshal.InstanceUnmarshaller;
import org.apache.deltacloud.client.unmarshal.InstancesUnmarshaller;
import org.apache.deltacloud.client.unmarshal.KeyUnmarshaller;
import org.apache.deltacloud.client.unmarshal.KeysUnmarshaller;
import org.apache.deltacloud.client.unmarshal.RealmUnmarshaller;
import org.apache.deltacloud.client.unmarshal.RealmsUnmarshaller;

public class DeltaCloudClientImpl
implements DeltaCloudClient {
    private String baseUrl;
    private IHttpTransport transport;

    public DeltaCloudClientImpl(String url) throws MalformedURLException, DeltaCloudClientException {
        this(url, null, null);
    }

    public DeltaCloudClientImpl(String url, String username, String password) throws MalformedURLException, DeltaCloudClientException {
        this(url, new URLConnectionTransport(username, password));
    }

    public DeltaCloudClientImpl(String url, IHttpTransport transport) throws DeltaCloudClientException {
        this.baseUrl = url;
        this.transport = transport;
    }

    protected InputStream request(DeltaCloudRequest deltaCloudRequest) throws DeltaCloudClientException {
        return this.transport.request(deltaCloudRequest);
    }

    @Override
    public API.Driver getServerType() {
        try {
            InputStream response = this.request(new TypeRequest(this.baseUrl));
            API api = new APIUnmarshaller().unmarshall(response, new API());
            return api.getDriver();
        }
        catch (DeltaCloudClientException e) {
            return API.Driver.UNKNOWN;
        }
    }

    @Override
    public Instance createInstance(String imageId) throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new CreateInstanceRequest(this.baseUrl, imageId));
            return new InstanceUnmarshaller().unmarshall(response, new Instance());
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    @Override
    public Instance createInstance(String name, String imageId, String profileId, String realmId, String memory, String storage) throws DeltaCloudClientException {
        return this.createInstance(name, imageId, profileId, realmId, null, memory, storage);
    }

    @Override
    public Instance createInstance(String name, String imageId, String profileId, String realmId, String keyId, String memory, String storage) throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new CreateInstanceRequest(this.baseUrl, name, imageId, profileId, realmId, keyId, memory, storage));
            Instance instance = new InstanceUnmarshaller().unmarshall(response, new Instance());
            if (keyId != null) {
                instance.setKeyId(keyId);
            }
            return instance;
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    @Override
    public HardwareProfile listProfile(String profileId) throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new ListHardwareProfileRequest(this.baseUrl, profileId));
            return new HardwareProfileUnmarshaller().unmarshall(response, new HardwareProfile());
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    @Override
    public List<HardwareProfile> listProfiles() throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new ListHardwareProfilesRequest(this.baseUrl));
            ArrayList<HardwareProfile> profiles = new ArrayList<HardwareProfile>();
            new HardwareProfilesUnmarshaller().unmarshall(response, profiles);
            return profiles;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(MessageFormat.format("could not get realms on cloud at \"{0}\"", this.baseUrl), e);
        }
    }

    @Override
    public List<Image> listImages() throws DeltaCloudClientException {
        InputStream response = this.request(new ListImagesRequest(this.baseUrl));
        ArrayList<Image> images = new ArrayList<Image>();
        new ImagesUnmarshaller().unmarshall(response, images);
        return images;
    }

    @Override
    public Image listImages(String imageId) throws DeltaCloudClientException {
        InputStream response = this.request(new ListImageRequest(this.baseUrl, imageId));
        return new ImageUnmarshaller().unmarshall(response, new Image());
    }

    @Override
    public List<Instance> listInstances() throws DeltaCloudClientException {
        InputStream inputStream = this.request(new ListInstancesRequest(this.baseUrl));
        ArrayList<Instance> instances = new ArrayList<Instance>();
        new InstancesUnmarshaller().unmarshall(inputStream, instances);
        return instances;
    }

    @Override
    public Instance listInstances(String instanceId) throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new ListInstanceRequest(this.baseUrl, instanceId));
            return new InstanceUnmarshaller().unmarshall(response, new Instance());
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    @Override
    public List<Realm> listRealms() throws DeltaCloudClientException {
        try {
            InputStream inputStream = this.request(new ListRealmsRequest(this.baseUrl));
            ArrayList<Realm> realms = new ArrayList<Realm>();
            new RealmsUnmarshaller().unmarshall(inputStream, realms);
            return realms;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(MessageFormat.format("could not get realms on cloud at \"{0}\"", this.baseUrl), e);
        }
    }

    @Override
    public Realm listRealms(String realmId) throws DeltaCloudClientException {
        try {
            InputStream response = this.request(new ListRealmRequest(this.baseUrl, realmId));
            return new RealmUnmarshaller().unmarshall(response, new Realm());
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(MessageFormat.format("could not get realms on cloud at \"{0}\"", this.baseUrl), e);
        }
    }

    @Override
    public Key createKey(String keyname) throws DeltaCloudClientException {
        try {
            CreateKeyRequest keyRequest = new CreateKeyRequest(this.baseUrl, keyname);
            InputStream inputStream = this.request(keyRequest);
            Key key = new KeyUnmarshaller().unmarshall(inputStream, new Key());
            return key;
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    @Override
    public List<Key> listKeys() throws DeltaCloudClientException {
        InputStream inputStream = this.request(new ListKeysRequest(this.baseUrl));
        ArrayList<Key> keys = new ArrayList<Key>();
        new KeysUnmarshaller().unmarshall(inputStream, keys);
        return keys;
    }

    @Override
    public Key listKey(String id) throws DeltaCloudClientException {
        InputStream inputStream = this.request(new ListKeyRequest(this.baseUrl, id));
        Key key = new KeyUnmarshaller().unmarshall(inputStream, new Key());
        return key;
    }

    @Override
    public InputStream performAction(Action<?> action) throws DeltaCloudClientException {
        InputStream in = null;
        if (action != null) {
            try {
                in = this.request(new PerformActionRequest(action.getUrl(), action.getMethod()));
            }
            catch (DeltaCloudClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeltaCloudClientException(e);
            }
        }
        return in;
    }
}

